/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.audio;

import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class AudioFormat {
    public static final AudioFormat PCM_SIGNED = new AudioFormat("NONE", "PCM_SIGNED", null, null, null, null);
    public static final AudioFormat MP3 = new AudioFormat("NONE", "MP3", null, null, null, null);
    public static final AudioFormat WAV = new AudioFormat("WAVE", "PCM_SIGNED", null, null, null, null);
    public static final AudioFormat OGG = new AudioFormat("OGG", "VORBIS", null, null, null, null);
    public static final AudioFormat AAC = new AudioFormat("NONE", "AAC", null, null, null, null);
    public static final String CONTAINER_NONE = "NONE";
    public static final String CONTAINER_WAVE = "WAVE";
    public static final String CONTAINER_OGG = "OGG";
    public static final String CODEC_PCM_SIGNED = "PCM_SIGNED";
    public static final String CODEC_PCM_UNSIGNED = "PCM_UNSIGNED";
    public static final String CODEC_PCM_ALAW = "ALAW";
    public static final String CODEC_PCM_ULAW = "ULAW";
    public static final String CODEC_MP3 = "MP3";
    public static final String CODEC_VORBIS = "VORBIS";
    public static final String CODEC_AAC = "AAC";
    private final @Nullable String codec;
    private final @Nullable String container;
    private final @Nullable Boolean bigEndian;
    private final @Nullable Integer bitDepth;
    private final @Nullable Integer bitRate;
    private final @Nullable Long frequency;
    private final @Nullable Integer channels;

    public AudioFormat(@Nullable String container, @Nullable String codec, @Nullable Boolean bigEndian, @Nullable Integer bitDepth, @Nullable Integer bitRate, @Nullable Long frequency) {
        this(container, codec, bigEndian, bitDepth, bitRate, frequency, 1);
    }

    public AudioFormat(@Nullable String container, @Nullable String codec, @Nullable Boolean bigEndian, @Nullable Integer bitDepth, @Nullable Integer bitRate, @Nullable Long frequency, @Nullable Integer channels) {
        this.container = container;
        this.codec = codec;
        this.bigEndian = bigEndian;
        this.bitDepth = bitDepth;
        this.bitRate = bitRate;
        this.frequency = frequency;
        this.channels = channels;
    }

    public @Nullable String getCodec() {
        return this.codec;
    }

    public @Nullable String getContainer() {
        return this.container;
    }

    public @Nullable Boolean isBigEndian() {
        return this.bigEndian;
    }

    public @Nullable Integer getBitDepth() {
        return this.bitDepth;
    }

    public @Nullable Integer getBitRate() {
        return this.bitRate;
    }

    public @Nullable Long getFrequency() {
        return this.frequency;
    }

    public @Nullable Integer getChannels() {
        return this.channels;
    }

    public boolean isCompatible(@Nullable AudioFormat audioFormat) {
        Long frequency;
        Integer bitRate;
        Integer bitDepth;
        Boolean bigEndian;
        String codec;
        String container;
        if (audioFormat == null) {
            return false;
        }
        String string = this.getContainer();
        if (string instanceof String && !(container = string).equals(audioFormat.getContainer())) {
            return false;
        }
        String string2 = this.getCodec();
        if (string2 instanceof String && !(codec = string2).equals(audioFormat.getCodec())) {
            return false;
        }
        Boolean bl = this.isBigEndian();
        if (bl instanceof Boolean && !(bigEndian = bl).equals(audioFormat.isBigEndian())) {
            return false;
        }
        Integer n = this.getBitDepth();
        if (n instanceof Integer && !(bitDepth = n).equals(audioFormat.getBitDepth())) {
            return false;
        }
        Integer n2 = this.getBitRate();
        if (n2 instanceof Integer && !(bitRate = n2).equals(audioFormat.getBitRate())) {
            return false;
        }
        Long l = this.getFrequency();
        return !(l instanceof Long) || (frequency = l).equals(audioFormat.getFrequency());
    }

    public static @Nullable AudioFormat getBestMatch(Set<AudioFormat> inputs, Set<AudioFormat> outputs) {
        AudioFormat preferredFormat = AudioFormat.getPreferredFormat(inputs);
        if (preferredFormat != null) {
            for (AudioFormat output : outputs) {
                if (output.isCompatible(preferredFormat)) {
                    return preferredFormat;
                }
                for (AudioFormat input : inputs) {
                    if (!output.isCompatible(input)) continue;
                    return input;
                }
            }
        }
        return null;
    }

    public static @Nullable AudioFormat getPreferredFormat(Set<AudioFormat> audioFormats) {
        for (AudioFormat currentAudioFormat : audioFormats) {
            if (currentAudioFormat.getCodec() == null || currentAudioFormat.getContainer() == null || currentAudioFormat.isBigEndian() == null || currentAudioFormat.getBitDepth() == null || currentAudioFormat.getBitRate() == null || currentAudioFormat.getFrequency() == null || !CONTAINER_WAVE.equals(currentAudioFormat.getContainer())) continue;
            return currentAudioFormat;
        }
        for (AudioFormat currentAudioFormat : audioFormats) {
            Integer channel;
            AudioFormat format = currentAudioFormat;
            if (format.getCodec() == null || format.getContainer() == null || !CONTAINER_WAVE.equals(format.getContainer()) && (!CONTAINER_NONE.equals(format.getContainer()) || !CODEC_PCM_SIGNED.equals(format.getCodec()))) continue;
            Integer n = channel = format.getChannels() == null ? Integer.valueOf(1) : format.getChannels();
            if (format.isBigEndian() == null) {
                format = new AudioFormat(format.getContainer(), format.getCodec(), Boolean.TRUE, format.getBitDepth(), format.getBitRate(), format.getFrequency(), channel);
            }
            if (format.getBitDepth() == null || format.getBitRate() == null || format.getFrequency() == null) {
                int defaultBitDepth = 16;
                long defaultFrequency = 16384L;
                Integer bitRate = format.getBitRate();
                Long frequency = format.getFrequency();
                Integer bitDepth = format.getBitDepth();
                if (bitRate == null) {
                    if (bitDepth == null) {
                        bitDepth = defaultBitDepth;
                    }
                    if (frequency == null) {
                        frequency = defaultFrequency;
                    }
                    bitRate = bitDepth * frequency.intValue();
                } else if (bitDepth == null) {
                    if (frequency == null) {
                        frequency = defaultFrequency;
                    }
                    bitDepth = bitRate / frequency.intValue();
                } else if (frequency == null) {
                    frequency = bitRate.longValue() / bitDepth.longValue();
                }
                format = new AudioFormat(format.getContainer(), format.getCodec(), format.isBigEndian(), bitDepth, bitRate, frequency, channel);
            }
            return format;
        }
        return null;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof AudioFormat) {
            AudioFormat format = (AudioFormat)obj;
            return Objects.equals(this.getCodec(), format.getCodec()) && Objects.equals(this.getContainer(), format.getContainer()) && Objects.equals(this.isBigEndian(), format.isBigEndian()) && Objects.equals(this.getBitDepth(), format.getBitDepth()) && Objects.equals(this.getBitRate(), format.getBitRate()) && Objects.equals(this.getFrequency(), format.getFrequency()) && Objects.equals(this.getChannels(), format.getChannels());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int prime = 31;
        int result = 1;
        Boolean bl = this.bigEndian;
        if (bl instanceof Object) {
            Object localBigEndian = bl;
            n7 = localBigEndian.hashCode();
        } else {
            n7 = 0;
        }
        result = 31 * result + n7;
        Integer n8 = this.bitDepth;
        if (n8 instanceof Object) {
            Object localBitDepth = n8;
            n6 = localBitDepth.hashCode();
        } else {
            n6 = 0;
        }
        result = 31 * result + n6;
        Integer n9 = this.bitRate;
        if (n9 instanceof Object) {
            Object localBitRate = n9;
            n5 = localBitRate.hashCode();
        } else {
            n5 = 0;
        }
        result = 31 * result + n5;
        String string = this.codec;
        if (string instanceof Object) {
            Object localCodec = string;
            n4 = localCodec.hashCode();
        } else {
            n4 = 0;
        }
        result = 31 * result + n4;
        String string2 = this.container;
        if (string2 instanceof Object) {
            Object localContainer = string2;
            n3 = localContainer.hashCode();
        } else {
            n3 = 0;
        }
        result = 31 * result + n3;
        Long l = this.frequency;
        if (l instanceof Object) {
            Object localFrequency = l;
            n2 = localFrequency.hashCode();
        } else {
            n2 = 0;
        }
        result = 31 * result + n2;
        Integer n10 = this.channels;
        if (n10 instanceof Object) {
            Object localChannels = n10;
            n = localChannels.hashCode();
        } else {
            n = 0;
        }
        result = 31 * result + n;
        return result;
    }

    public String toString() {
        return "AudioFormat [" + (String)(this.codec != null ? "codec=" + this.codec + ", " : "") + (String)(this.container != null ? "container=" + this.container + ", " : "") + (String)(this.bigEndian != null ? "bigEndian=" + String.valueOf(this.bigEndian) + ", " : "") + (String)(this.bitDepth != null ? "bitDepth=" + String.valueOf(this.bitDepth) + ", " : "") + (String)(this.bitRate != null ? "bitRate=" + String.valueOf(this.bitRate) + ", " : "") + (String)(this.frequency != null ? "frequency=" + String.valueOf(this.frequency) + ", " : "") + (String)(this.channels != null ? "channels=" + String.valueOf(this.channels) : "") + "]";
    }
}

