/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.websocket;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.whispersystems.signalservice.api.util.Preconditions;

public class WebsocketResponse {
    private final int status;
    private final String body;
    private final Map<String, String> headers;
    private final boolean unidentified;

    WebsocketResponse(int status, String body, List<String> headers, boolean unidentified) {
        this(status, body, WebsocketResponse.parseHeaders(headers), unidentified);
    }

    WebsocketResponse(int status, String body, Map<String, String> headerMap, boolean unidentified) {
        this.status = status;
        this.body = body;
        this.headers = headerMap;
        this.unidentified = unidentified;
    }

    public int getStatus() {
        return this.status;
    }

    public String getBody() {
        return this.body;
    }

    public String getHeader(String key) {
        return this.headers.get(Preconditions.checkNotNull(key.toLowerCase()));
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public boolean isUnidentified() {
        return this.unidentified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebsocketResponse that = (WebsocketResponse)o;
        return this.status == that.status && this.unidentified == that.unidentified && Objects.equals(this.body, that.body) && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.body, this.headers, this.unidentified);
    }

    private static Map<String, String> parseHeaders(List<String> rawHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>(rawHeaders.size());
        for (String raw : rawHeaders) {
            int colonIndex;
            if (raw == null || raw.isEmpty() || (colonIndex = raw.indexOf(":")) <= 0 || colonIndex >= raw.length() - 1) continue;
            String key = raw.substring(0, colonIndex).trim().toLowerCase();
            String value = raw.substring(colonIndex + 1).trim();
            headers.put(key, value);
        }
        return headers;
    }
}

