/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.asamk.signal.json.JsonAttachment;
import org.asamk.signal.json.JsonGroupInfo;
import org.asamk.signal.json.JsonMention;
import org.asamk.signal.json.JsonPayment;
import org.asamk.signal.json.JsonPreview;
import org.asamk.signal.json.JsonQuote;
import org.asamk.signal.json.JsonReaction;
import org.asamk.signal.json.JsonRemoteDelete;
import org.asamk.signal.json.JsonSharedContact;
import org.asamk.signal.json.JsonSticker;
import org.asamk.signal.json.JsonStoryContext;
import org.asamk.signal.json.JsonTextStyle;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.MessageEnvelope;

record JsonDataMessage(long timestamp, String message, Integer expiresInSeconds, @JsonInclude(value=JsonInclude.Include.NON_NULL) Boolean viewOnce, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonReaction reaction, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonQuote quote, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonPayment payment, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonMention> mentions, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonPreview> previews, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonAttachment> attachments, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonSticker sticker, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonRemoteDelete remoteDelete, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonSharedContact> contacts, @JsonInclude(value=JsonInclude.Include.NON_NULL) List<JsonTextStyle> textStyles, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonGroupInfo groupInfo, @JsonInclude(value=JsonInclude.Include.NON_NULL) JsonStoryContext storyContext) {
    static JsonDataMessage from(MessageEnvelope.Data dataMessage, Manager m) {
        long timestamp = dataMessage.timestamp();
        JsonGroupInfo groupInfo = dataMessage.groupContext().isPresent() ? JsonGroupInfo.from((MessageEnvelope.Data.GroupContext)dataMessage.groupContext().get(), m) : null;
        JsonStoryContext storyContext = dataMessage.storyContext().isPresent() ? JsonStoryContext.from((MessageEnvelope.Data.StoryContext)dataMessage.storyContext().get()) : null;
        String message = dataMessage.body().orElse(null);
        int expiresInSeconds = dataMessage.expiresInSeconds();
        boolean viewOnce = dataMessage.isViewOnce();
        JsonReaction reaction = dataMessage.reaction().map(JsonReaction::from).orElse(null);
        JsonQuote quote = dataMessage.quote().isPresent() ? JsonQuote.from((MessageEnvelope.Data.Quote)dataMessage.quote().get()) : null;
        JsonPayment payment = dataMessage.payment().isPresent() ? JsonPayment.from((MessageEnvelope.Data.Payment)dataMessage.payment().get()) : null;
        List<JsonMention> mentions = !dataMessage.mentions().isEmpty() ? dataMessage.mentions().stream().map(JsonMention::from).toList() : null;
        List<JsonPreview> previews = !dataMessage.previews().isEmpty() ? dataMessage.previews().stream().map(JsonPreview::from).toList() : null;
        JsonRemoteDelete remoteDelete = dataMessage.remoteDeleteId().isPresent() ? new JsonRemoteDelete((Long)dataMessage.remoteDeleteId().get()) : null;
        List<JsonAttachment> attachments = !dataMessage.attachments().isEmpty() ? dataMessage.attachments().stream().map(JsonAttachment::from).toList() : null;
        JsonSticker sticker = dataMessage.sticker().isPresent() ? JsonSticker.from((MessageEnvelope.Data.Sticker)dataMessage.sticker().get()) : null;
        List<JsonSharedContact> contacts = !dataMessage.sharedContacts().isEmpty() ? dataMessage.sharedContacts().stream().map(JsonSharedContact::from).toList() : null;
        List<JsonTextStyle> textStyles = !dataMessage.textStyles().isEmpty() ? dataMessage.textStyles().stream().map(JsonTextStyle::from).toList() : null;
        return new JsonDataMessage(timestamp, message, expiresInSeconds, viewOnce, reaction, quote, payment, mentions, previews, attachments, sticker, remoteDelete, contacts, textStyles, groupInfo, storyContext);
    }
}

