/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.util.Optional;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.Configuration;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.output.OutputWriter;

public class UpdateConfigurationCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "updateConfiguration";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Update signal configs and sync them to linked devices.");
        subparser.addArgument(new String[]{"--read-receipts"}).type(Boolean.class).help("Indicates if Signal should send read receipts.");
        subparser.addArgument(new String[]{"--unidentified-delivery-indicators"}).type(Boolean.class).help("Indicates if Signal should show unidentified delivery indicators.");
        subparser.addArgument(new String[]{"--typing-indicators"}).type(Boolean.class).help("Indicates if Signal should send/show typing indicators.");
        subparser.addArgument(new String[]{"--link-previews"}).type(Boolean.class).help("Indicates if Signal should generate link previews.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        Boolean readReceipts = ns.getBoolean("read-receipts");
        Boolean unidentifiedDeliveryIndicators = ns.getBoolean("unidentified-delivery-indicators");
        Boolean typingIndicators = ns.getBoolean("typing-indicators");
        Boolean linkPreviews = ns.getBoolean("link-previews");
        try {
            m.updateConfiguration(new Configuration(Optional.ofNullable(readReceipts), Optional.ofNullable(unidentifiedDeliveryIndicators), Optional.ofNullable(typingIndicators), Optional.ofNullable(linkPreviews)));
        }
        catch (NotPrimaryDeviceException e) {
            throw new UserErrorException("This command doesn't work on linked devices.");
        }
    }
}

