/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.StickerPack;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.Hex;

public class ListStickerPacksCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "listStickerPacks";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Show a list of known sticker packs.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager c, OutputWriter outputWriter) throws CommandException {
        List stickerPacks = c.getStickerPacks();
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonWriter.class, PlainTextWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonWriter jsonWriter = (JsonWriter)outputWriter3;
                List<JsonStickerPack> jsonStickerPacks = stickerPacks.stream().map(JsonStickerPack::new).toList();
                jsonWriter.write(jsonStickerPacks);
                break;
            }
            case 1: {
                PlainTextWriter plainTextWriter = (PlainTextWriter)outputWriter3;
                for (StickerPack sticker : stickerPacks) {
                    plainTextWriter.println("Pack {}: \u201c{}\u201d by \u201c{}\u201d has {} stickers. {}", Hex.toStringCondensed(sticker.packId().serialize()), sticker.title(), sticker.author(), sticker.stickers().size(), sticker.url().getUrl());
                }
            }
        }
    }

    private record JsonStickerPack(String packId, String url, boolean installed, String title, String author, JsonSticker cover, List<JsonSticker> stickers) {
        JsonStickerPack(StickerPack stickerPack) {
            this(Hex.toStringCondensed(stickerPack.packId().serialize()), stickerPack.url().getUrl().toString(), stickerPack.installed(), stickerPack.title(), stickerPack.author(), stickerPack.cover().map(JsonSticker::new).orElse(null), stickerPack.stickers().stream().map(JsonSticker::new).toList());
        }

        private record JsonSticker(int id, String emoji, String contentType) {
            JsonSticker(StickerPack.Sticker sticker) {
                this(sticker.id(), sticker.emoji(), sticker.contentType());
            }
        }
    }
}

