/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.zkgroup;

import java.security.SecureRandom;
import java.util.Arrays;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.NotarySignature;
import org.signal.libsignal.zkgroup.ServerPublicParams;
import org.signal.libsignal.zkgroup.internal.ByteArray;

public final class ServerSecretParams
extends NativeHandleGuard.SimpleOwner {
    public static ServerSecretParams generate() {
        return ServerSecretParams.generate(new SecureRandom());
    }

    public static ServerSecretParams generate(SecureRandom secureRandom) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        return new ServerSecretParams(Native.ServerSecretParams_GenerateDeterministic(random));
    }

    public ServerSecretParams(byte[] contents) throws InvalidInputException {
        super(FilterExceptions.filterExceptions(() -> Native.ServerSecretParams_Deserialize(contents)));
    }

    ServerSecretParams(long nativeHandle) {
        super(nativeHandle);
    }

    public ServerPublicParams getPublicParams() {
        return new ServerPublicParams(this.guardedMap(Native::ServerSecretParams_GetPublicParams));
    }

    public NotarySignature sign(byte[] message) {
        return this.sign(new SecureRandom(), message);
    }

    public NotarySignature sign(SecureRandom secureRandom, byte[] message) {
        byte[] random = new byte[32];
        secureRandom.nextBytes(random);
        byte[] newContents = this.guardedMap(nativeHandle -> Native.ServerSecretParams_SignDeterministic(nativeHandle, random, message));
        try {
            return new NotarySignature(newContents);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected void release(long handle) {
        Native.ServerSecretParams_Destroy(handle);
    }

    public byte[] serialize() {
        return this.guardedMap(Native::ServerSecretParams_Serialize);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + Arrays.hashCode(this.serialize());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerPublicParams other = (ServerPublicParams)o;
        return ByteArray.constantTimeEqual(this.serialize(), other.serialize());
    }
}

