// generated by diplomat-tool
import { Weekday } from "./Weekday.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * Documents which days of the week are considered to be a part of the weekend
 *
 * See the [Rust documentation for `WeekdaySetIterator`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekdaySetIterator.html) for more information.
 */
const WeekdaySetIterator_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_WeekdaySetIterator_destroy_mv1(ptr);
});

export class WeekdaySetIterator {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("WeekdaySetIterator is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            WeekdaySetIterator_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * See the [Rust documentation for `next`](https://docs.rs/icu/latest/icu/calendar/week/struct.WeekdaySetIterator.html#method.next) for more information.
     */
    #iteratorNext() {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_WeekdaySetIterator_next_mv1(diplomatReceive.buffer, this.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new Weekday(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            diplomatReceive.free();
        }
    }

    next(){
        const out = this.#iteratorNext();

        return {
            value: out,
            done: out === null,
        };
    }

    constructor(symbol, ptr, selfEdge) {
        return this.#internalConstructor(...arguments)
    }
}