/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.internal.Cast;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.event.AbstractBroadcastDispatch;
import org.gradle.util.internal.CollectionUtils;

public abstract class BroadcastDispatch<T>
extends AbstractBroadcastDispatch<T> {
    private BroadcastDispatch(Class<T> type) {
        super(type);
    }

    public static <T> BroadcastDispatch<T> empty(Class<T> type) {
        return new EmptyDispatch<T>(type);
    }

    public Class<T> getType() {
        return this.type;
    }

    public abstract boolean isEmpty();

    public abstract int size();

    public BroadcastDispatch<T> add(Dispatch<MethodInvocation> dispatch) {
        return this.add(dispatch, dispatch);
    }

    public BroadcastDispatch<T> add(T listener) {
        return this.add(listener, new ReflectionDispatch(listener));
    }

    public BroadcastDispatch<T> add(String methodName, Action<?> action) {
        this.assertIsMethod(methodName);
        return this.add(action, new ActionInvocationHandler(methodName, (Action<Object>)((Action)Cast.uncheckedNonnullCast(action))));
    }

    abstract BroadcastDispatch<T> add(Object var1, Dispatch<MethodInvocation> var2);

    private void assertIsMethod(String methodName) {
        for (Method method : this.type.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Method %s() not found for listener type %s.", methodName, this.type.getSimpleName()));
    }

    public abstract BroadcastDispatch<T> remove(Object var1);

    public abstract BroadcastDispatch<T> addAll(Collection<? extends T> var1);

    public abstract BroadcastDispatch<T> removeAll(Collection<?> var1);

    public abstract void visitListeners(Action<T> var1);

    public abstract void visitListenersUntyped(Action<Object> var1);

    private static boolean sameOrEquals(Object x, Object y) {
        return x == y || x.equals(y);
    }

    private static class CompositeDispatch<T>
    extends BroadcastDispatch<T> {
        private final List<SingletonDispatch<T>> dispatchers;

        CompositeDispatch(Class<T> type, List<SingletonDispatch<T>> dispatchers) {
            super(type);
            this.dispatchers = dispatchers;
        }

        public String toString() {
            return this.dispatchers.toString();
        }

        @Override
        BroadcastDispatch<T> add(Object handler, Dispatch<MethodInvocation> dispatch) {
            ArrayList<SingletonDispatch<T>> result = new ArrayList<SingletonDispatch<T>>();
            for (SingletonDispatch<T> listener : this.dispatchers) {
                if (BroadcastDispatch.sameOrEquals(((SingletonDispatch)listener).handler, handler)) {
                    return this;
                }
                result.add(listener);
            }
            result.add(new SingletonDispatch(this.type, handler, dispatch));
            return new CompositeDispatch<T>(this.type, result);
        }

        @Override
        public BroadcastDispatch<T> addAll(Collection<? extends T> listeners) {
            ArrayList<SingletonDispatch<T>> result = new ArrayList<SingletonDispatch<T>>(this.dispatchers);
            for (T listener : listeners) {
                SingletonDispatch dispatch = new SingletonDispatch(this.type, listener, new ReflectionDispatch(listener));
                if (result.contains(dispatch)) continue;
                result.add(dispatch);
            }
            if (result.equals(this.dispatchers)) {
                return this;
            }
            return new CompositeDispatch<T>(this.type, result);
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            ArrayList<SingletonDispatch<T>> result = new ArrayList<SingletonDispatch<T>>();
            boolean found = false;
            for (SingletonDispatch<T> dispatch : this.dispatchers) {
                if (BroadcastDispatch.sameOrEquals(((SingletonDispatch)dispatch).handler, listener)) {
                    found = true;
                    continue;
                }
                result.add(dispatch);
            }
            if (!found) {
                return this;
            }
            if (result.size() == 1) {
                return (BroadcastDispatch)result.get(0);
            }
            return new CompositeDispatch<T>(this.type, result);
        }

        @Override
        public BroadcastDispatch<T> removeAll(Collection<?> listeners) {
            Set listenerList = CollectionUtils.toSet(listeners);
            ArrayList<SingletonDispatch<T>> result = new ArrayList<SingletonDispatch<T>>();
            for (SingletonDispatch<T> dispatch : this.dispatchers) {
                if (listenerList.contains(((SingletonDispatch)dispatch).handler)) continue;
                result.add(dispatch);
            }
            if (result.isEmpty()) {
                return new EmptyDispatch(this.type);
            }
            if (result.size() == 1) {
                return (BroadcastDispatch)result.get(0);
            }
            if (result.equals(this.dispatchers)) {
                return this;
            }
            return new CompositeDispatch<T>(this.type, result);
        }

        @Override
        public void visitListeners(Action<T> visitor) {
            for (SingletonDispatch<T> dispatcher : this.dispatchers) {
                dispatcher.visitListeners(visitor);
            }
        }

        @Override
        public void visitListenersUntyped(Action<Object> visitor) {
            for (SingletonDispatch<T> dispatcher : this.dispatchers) {
                dispatcher.visitListenersUntyped(visitor);
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return this.dispatchers.size();
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.dispatch(message, this.dispatchers);
        }
    }

    private static class SingletonDispatch<T>
    extends BroadcastDispatch<T> {
        private final Object handler;
        private final Dispatch<MethodInvocation> dispatch;

        SingletonDispatch(Class<T> type, Object handler, Dispatch<MethodInvocation> dispatch) {
            super(type);
            this.handler = handler;
            this.dispatch = dispatch;
        }

        public String toString() {
            return this.handler.toString();
        }

        public boolean equals(Object obj) {
            SingletonDispatch other = (SingletonDispatch)Cast.uncheckedNonnullCast((Object)obj);
            return BroadcastDispatch.sameOrEquals(this.handler, other.handler);
        }

        public int hashCode() {
            return this.handler.hashCode();
        }

        @Override
        BroadcastDispatch<T> add(Object handler, Dispatch<MethodInvocation> dispatch) {
            if (BroadcastDispatch.sameOrEquals(this.handler, handler)) {
                return this;
            }
            ArrayList result = new ArrayList();
            result.add(this);
            result.add(new SingletonDispatch<T>(this.type, handler, dispatch));
            return new CompositeDispatch(this.type, result);
        }

        @Override
        public BroadcastDispatch<T> addAll(Collection<? extends T> listeners) {
            ArrayList result = new ArrayList();
            result.add(this);
            for (T listener : listeners) {
                SingletonDispatch<T> dispatch;
                if (BroadcastDispatch.sameOrEquals(this.handler, listener) || result.contains(dispatch = new SingletonDispatch<T>(this.type, listener, new ReflectionDispatch(listener)))) continue;
                result.add(dispatch);
            }
            if (result.size() == 1) {
                return this;
            }
            return new CompositeDispatch(this.type, result);
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            if (BroadcastDispatch.sameOrEquals(this.handler, listener)) {
                return new EmptyDispatch(this.type);
            }
            return this;
        }

        @Override
        public BroadcastDispatch<T> removeAll(Collection<?> listeners) {
            for (Object listener : listeners) {
                if (!BroadcastDispatch.sameOrEquals(this.handler, listener)) continue;
                return new EmptyDispatch(this.type);
            }
            return this;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public void visitListeners(Action<T> visitor) {
            if (this.getType().isInstance(this.handler)) {
                visitor.execute(this.getType().cast(this.handler));
            }
        }

        @Override
        public void visitListenersUntyped(Action<Object> visitor) {
            visitor.execute(this.handler);
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.dispatch(message, this.dispatch);
        }
    }

    private static class EmptyDispatch<T>
    extends BroadcastDispatch<T> {
        EmptyDispatch(Class<T> type) {
            super(type);
        }

        public String toString() {
            return "<empty>";
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public BroadcastDispatch<T> remove(Object listener) {
            return this;
        }

        @Override
        public BroadcastDispatch<T> removeAll(Collection<?> listeners) {
            return this;
        }

        @Override
        BroadcastDispatch<T> add(Object handler, Dispatch<MethodInvocation> dispatch) {
            return new SingletonDispatch(this.type, handler, dispatch);
        }

        @Override
        public void visitListeners(Action<T> visitor) {
        }

        @Override
        public void visitListenersUntyped(Action<Object> visitor) {
        }

        @Override
        public BroadcastDispatch<T> addAll(Collection<? extends T> listeners) {
            ArrayList result = new ArrayList();
            for (T listener : listeners) {
                SingletonDispatch dispatch = new SingletonDispatch(this.type, listener, new ReflectionDispatch(listener));
                if (result.contains(dispatch)) continue;
                result.add(dispatch);
            }
            if (result.isEmpty()) {
                return this;
            }
            if (result.size() == 1) {
                return (BroadcastDispatch)result.get(0);
            }
            return new CompositeDispatch(this.type, result);
        }

        @Override
        public void dispatch(MethodInvocation message) {
        }
    }

    private static class ActionInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Action<Object> action;

        ActionInvocationHandler(String methodName, Action<Object> action) {
            this.methodName = methodName;
            this.action = action;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (message.getMethodName().equals(this.methodName)) {
                this.action.execute(message.getArguments()[0]);
            }
        }
    }
}

