/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtClassElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ5\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u0011\u001a\u0002H\u000eH\u0016\u00a2\u0006\u0002\u0010\u0012J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001aJ\u0006\u0010\u001d\u001a\u00020\u001aJ\u0006\u0010\u001e\u001a\u00020\u001aJ\u0006\u0010\u001f\u001a\u00020\u001aJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0017H\u0016J\b\u0010\"\u001a\u0004\u0018\u00010#J\b\u0010$\u001a\u0004\u0018\u00010#J\b\u0010%\u001a\u0004\u0018\u00010#R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "stub", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;)V", "classInterfaceTokenSet", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "data", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "_stub", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "getProperties", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isInterface", "", "isEnum", "isSealed", "isInner", "isInline", "isValue", "getCompanionObjects", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "getClassOrInterfaceKeyword", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "getClassKeyword", "getFunKeyword", "psi"})
public class KtClass
extends KtClassOrObject {
    @NotNull
    private final TokenSet classInterfaceTokenSet;

    public KtClass(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    public KtClass(@NotNull KotlinClassStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub;
        KtClassElementType ktClassElementType = KtStubElementTypes.CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)ktClassElementType, (String)"CLASS");
        super(kotlinClassOrObjectStub, (IStubElementType)ktClassElementType);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitClass(this, data);
    }

    private final KotlinClassStub get_stub() {
        Object t = this.getStub();
        return t instanceof KotlinClassStub ? (KotlinClassStub)t : null;
    }

    @NotNull
    public final List<KtProperty> getProperties() {
        KtClassBody ktClassBody = this.getBody();
        List list = ktClassBody != null ? ktClassBody.getProperties() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.get_stub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(KtTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(KtTokens.ENUM_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(KtTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(KtTokens.INNER_KEYWORD);
    }

    public final boolean isInline() {
        return this.hasModifier(KtTokens.INLINE_KEYWORD);
    }

    public final boolean isValue() {
        return this.hasModifier(KtTokens.VALUE_KEYWORD);
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody ktClassBody = this.getBody();
        List list = ktClassBody != null ? ktClassBody.getAllCompanionObjects() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(this.classInterfaceTokenSet);
    }

    @Nullable
    public final PsiElement getClassKeyword() {
        return this.findChildByType(KtTokens.CLASS_KEYWORD);
    }

    @Nullable
    public final PsiElement getFunKeyword() {
        KtModifierList ktModifierList = this.getModifierList();
        return ktModifierList != null ? ktModifierList.getModifier(KtTokens.FUN_KEYWORD) : null;
    }
}

