/*
 * =======================================================================================
 *
 *      Filename:  perfmon_sapphirerapids_counters.h
 *
 *      Description:  Counter Header File of perfmon module for Intel Sapphire Rapids.
 *
 *      Version:   <VERSION>
 *      Released:  <DATE>
 *
 *      Author:   Thomas Gruber (tr), thomas.roehl@googlemail.com
 *      Project:  likwid
 *
 *      Copyright (C) 2015 RRZE, University Erlangen-Nuremberg
 *
 *      This program is free software: you can redistribute it and/or modify it under
 *      the terms of the GNU General Public License as published by the Free Software
 *      Foundation, either version 3 of the License, or (at your option) any later
 *      version.
 *
 *      This program is distributed in the hope that it will be useful, but WITHOUT ANY
 *      WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 *      PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along with
 *      this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * =======================================================================================
 */
#ifndef PERFMON_SAPPHIRERAPIDS_COUNTERS_H
#define PERFMON_SAPPHIRERAPIDS_COUNTERS_H

#include <intel_perfmon_uncore_discovery.h>

#define NUM_COUNTERS_SAPPHIRERAPIDS 823
#define NUM_COUNTERS_CORE_SAPPHIRERAPIDS 18
#define NUM_COUNTERS_UNCORE_SAPPHIRERAPIDS 5


#define SPR_VALID_OPTIONS_FIXED EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_COUNT_KERNEL_MASK
#define SPR_VALID_OPTIONS_PMC EVENT_OPTION_EDGE_MASK|EVENT_OPTION_COUNT_KERNEL_MASK|EVENT_OPTION_INVERT_MASK| \
            EVENT_OPTION_ANYTHREAD_MASK|EVENT_OPTION_IN_TRANS_MASK|EVENT_OPTION_THRESHOLD_MASK

#define SPR_VALID_OPTIONS_CBOX  EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|\
                                EVENT_OPTION_THRESHOLD_MASK|EVENT_OPTION_TID_MASK
#define SPR_VALID_OPTIONS_UNCORE EVENT_OPTION_EDGE_MASK|EVENT_OPTION_INVERT_MASK|\
                                 EVENT_OPTION_THRESHOLD_MASK

/*#define MSR_UNC_SPR_C0_PMON_BOX_CTL     0x2000*/
/*//#define MSR_UNC_SPR_C0_PMON_BOX_STATUS  0x2001*/
/*#define MSR_UNC_SPR_C0_PMON_CTL0        0x2002*/
/*#define MSR_UNC_SPR_C0_PMON_CTL1        0x2003*/
/*#define MSR_UNC_SPR_C0_PMON_CTL2        0x2004*/
/*#define MSR_UNC_SPR_C0_PMON_CTL3        0x2005*/
/*#define MSR_UNC_SPR_C0_PMON_CTR0        0x2008*/
/*#define MSR_UNC_SPR_C0_PMON_CTR1        0x2009*/
/*#define MSR_UNC_SPR_C0_PMON_CTR2        0x200A*/
/*#define MSR_UNC_SPR_C0_PMON_CTR3        0x200B*/
/*//#define MSR_UNC_SPR_C0_PMON_BOX_FILTER  0x200C*/



static RegisterMap sapphirerapids_counter_map[NUM_COUNTERS_SAPPHIRERAPIDS] = {
    /* Fixed Counters: instructions retired, cycles unhalted core */
    {"FIXC0", PMC0, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR0, 0, MSR_DEV, SPR_VALID_OPTIONS_FIXED},
    {"FIXC1", PMC1, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR1, 0, MSR_DEV, SPR_VALID_OPTIONS_FIXED},
    {"FIXC2", PMC2, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR2, 0, MSR_DEV, SPR_VALID_OPTIONS_FIXED},
    {"FIXC3", PMC3, FIXED, MSR_PERF_FIXED_CTR_CTRL, MSR_PERF_FIXED_CTR3, 0, MSR_DEV, SPR_VALID_OPTIONS_FIXED},
    /* PMC Counters: 4 48bit wide */
    {"PMC0", PMC4, PMC, MSR_PERFEVTSEL0, MSR_PMC0, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    {"PMC1", PMC5, PMC, MSR_PERFEVTSEL1, MSR_PMC1, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    {"PMC2", PMC6, PMC, MSR_PERFEVTSEL2, MSR_PMC2, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC3", PMC7, PMC, MSR_PERFEVTSEL3, MSR_PMC3, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    /* Additional PMC Counters if HyperThreading is not active: 4 48bit wide */
    {"PMC4", PMC8, PMC, MSR_PERFEVTSEL4, MSR_PMC4, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    {"PMC5", PMC9, PMC, MSR_PERFEVTSEL5, MSR_PMC5, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    {"PMC6", PMC10, PMC, MSR_PERFEVTSEL6, MSR_PMC6, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC|EVENT_OPTION_IN_TRANS_ABORT_MASK},
    {"PMC7", PMC11, PMC, MSR_PERFEVTSEL7, MSR_PMC7, 0, MSR_DEV, SPR_VALID_OPTIONS_PMC},
    /* Temperature Sensor*/
    {"TMP0", PMC12, THERMAL, 0, IA32_THERM_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Vcore Status*/
    {"VTG0", PMC13, VOLTAGE, 0, MSR_PERF_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Intel Performance Metrics */
    {"TMA0", PMC14, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA1", PMC15, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA2", PMC16, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA3", PMC17, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA4", PMC18, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA5", PMC19, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA6", PMC20, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    {"TMA7", PMC21, METRICS, 0, MSR_PERF_METRICS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK}, 
    /* RAPL counters */
    {"PWR0", PMC22, POWER, 0, MSR_PKG_ENERGY_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR1", PMC23, POWER, 0, MSR_PP0_ENERGY_STATUS, 0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR2", PMC24, POWER, 0, MSR_PP1_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR3", PMC25, POWER, 0, MSR_DRAM_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    {"PWR4", PMC26, POWER, 0, MSR_PLATFORM_ENERGY_STATUS,  0, MSR_DEV, EVENT_OPTION_NONE_MASK},
    /* Uncore counters */
    {"CBOX0C0", PMC27, CBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C0, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX0C1", PMC28, CBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C0, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX0C2", PMC29, CBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C0, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX0C3", PMC30, CBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C0, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX1C0", PMC31, CBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C1, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX1C1", PMC32, CBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C1, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX1C2", PMC33, CBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C1, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX1C3", PMC34, CBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C1, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX2C0", PMC35, CBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C2, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX2C1", PMC36, CBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C2, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX2C2", PMC37, CBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C2, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX2C3", PMC38, CBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C2, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX3C0", PMC39, CBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C3, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX3C1", PMC40, CBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C3, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX3C2", PMC41, CBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C3, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX3C3", PMC42, CBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C3, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX4C0", PMC43, CBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C4, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX4C1", PMC44, CBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C4, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX4C2", PMC45, CBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C4, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX4C3", PMC46, CBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C4, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX5C0", PMC47, CBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C5, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX5C1", PMC48, CBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C5, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX5C2", PMC49, CBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C5, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX5C3", PMC50, CBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C5, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX6C0", PMC51, CBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C6, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX6C1", PMC52, CBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C6, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX6C2", PMC53, CBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C6, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX6C3", PMC54, CBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C6, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX7C0", PMC55, CBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C7, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX7C1", PMC56, CBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C7, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX7C2", PMC57, CBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C7, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX7C3", PMC58, CBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C7, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX8C0", PMC59, CBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C8, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX8C1", PMC60, CBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C8, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX8C2", PMC61, CBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C8, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX8C3", PMC62, CBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C8, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX9C0", PMC63, CBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C9, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX9C1", PMC64, CBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C9, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX9C2", PMC65, CBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C9, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX9C3", PMC66, CBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C9, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX10C0", PMC67, CBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C10, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX10C1", PMC68, CBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C10, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX10C2", PMC69, CBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C10, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX10C3", PMC70, CBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C10, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX11C0", PMC71, CBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C11, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX11C1", PMC72, CBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C11, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX11C2", PMC73, CBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C11, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX11C3", PMC74, CBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C11, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX12C0", PMC75, CBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C12, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX12C1", PMC76, CBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C12, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX12C2", PMC77, CBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C12, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX12C3", PMC78, CBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C12, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX13C0", PMC79, CBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C13, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX13C1", PMC80, CBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C13, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX13C2", PMC81, CBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C13, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX13C3", PMC82, CBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C13, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX14C0", PMC83, CBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C14, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX14C1", PMC84, CBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C14, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX14C2", PMC85, CBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C14, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX14C3", PMC86, CBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C14, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX15C0", PMC87, CBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C15, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX15C1", PMC88, CBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C15, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX15C2", PMC89, CBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C15, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX15C3", PMC90, CBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C15, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX16C0", PMC91, CBOX16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C16, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX16C1", PMC92, CBOX16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C16, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX16C2", PMC93, CBOX16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C16, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX16C3", PMC94, CBOX16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C16, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX17C0", PMC95, CBOX17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C17, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX17C1", PMC96, CBOX17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C17, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX17C2", PMC97, CBOX17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C17, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX17C3", PMC98, CBOX17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C17, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX18C0", PMC99, CBOX18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C18, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX18C1", PMC100, CBOX18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C18, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX18C2", PMC101, CBOX18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C18, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX18C3", PMC102, CBOX18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C18, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX19C0", PMC103, CBOX19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C19, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX19C1", PMC104, CBOX19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C19, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX19C2", PMC105, CBOX19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C19, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX19C3", PMC106, CBOX19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C19, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX20C0", PMC107, CBOX20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C20, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX20C1", PMC108, CBOX20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C20, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX20C2", PMC109, CBOX20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C20, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX20C3", PMC110, CBOX20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C20, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX21C0", PMC111, CBOX21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C21, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX21C1", PMC112, CBOX21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C21, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX21C2", PMC113, CBOX21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C21, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX21C3", PMC114, CBOX21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C21, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX22C0", PMC115, CBOX22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C22, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX22C1", PMC116, CBOX22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C22, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX22C2", PMC117, CBOX22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C22, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX22C3", PMC118, CBOX22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C22, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX23C0", PMC119, CBOX23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C23, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX23C1", PMC120, CBOX23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C23, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX23C2", PMC121, CBOX23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C23, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX23C3", PMC122, CBOX23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C23, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX24C0", PMC123, CBOX24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C24, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX24C1", PMC124, CBOX24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C24, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX24C2", PMC125, CBOX24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C24, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX24C3", PMC126, CBOX24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C24, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX25C0", PMC127, CBOX25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C25, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX25C1", PMC128, CBOX25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C25, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX25C2", PMC129, CBOX25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C25, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX25C3", PMC130, CBOX25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C25, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX26C0", PMC131, CBOX26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C26, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX26C1", PMC132, CBOX26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C26, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX26C2", PMC133, CBOX26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C26, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX26C3", PMC134, CBOX26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C26, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX27C0", PMC135, CBOX27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C27, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX27C1", PMC136, CBOX27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C27, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX27C2", PMC137, CBOX27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C27, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX27C3", PMC138, CBOX27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C27, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX28C0", PMC139, CBOX28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C28, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX28C1", PMC140, CBOX28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C28, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX28C2", PMC141, CBOX28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C28, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX28C3", PMC142, CBOX28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C28, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX29C0", PMC143, CBOX29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C29, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX29C1", PMC144, CBOX29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C29, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX29C2", PMC145, CBOX29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C29, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX29C3", PMC146, CBOX29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C29, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX30C0", PMC147, CBOX30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C30, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX30C1", PMC148, CBOX30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C30, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX30C2", PMC149, CBOX30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C30, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX30C3", PMC150, CBOX30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C30, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX31C0", PMC151, CBOX31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C31, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX31C1", PMC152, CBOX31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C31, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX31C2", PMC153, CBOX31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C31, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX31C3", PMC154, CBOX31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C31, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX32C0", PMC155, CBOX32, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C32, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX32C1", PMC156, CBOX32, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C32, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX32C2", PMC157, CBOX32, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C32, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX32C3", PMC158, CBOX32, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C32, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX33C0", PMC159, CBOX33, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C33, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX33C1", PMC160, CBOX33, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C33, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX33C2", PMC161, CBOX33, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C33, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX33C3", PMC162, CBOX33, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C33, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX34C0", PMC163, CBOX34, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C34, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX34C1", PMC164, CBOX34, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C34, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX34C2", PMC165, CBOX34, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C34, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX34C3", PMC166, CBOX34, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C34, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX35C0", PMC167, CBOX35, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C35, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX35C1", PMC168, CBOX35, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C35, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX35C2", PMC169, CBOX35, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C35, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX35C3", PMC170, CBOX35, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C35, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX36C0", PMC171, CBOX36, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C36, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX36C1", PMC172, CBOX36, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C36, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX36C2", PMC173, CBOX36, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C36, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX36C3", PMC174, CBOX36, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C36, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX37C0", PMC175, CBOX37, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C37, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX37C1", PMC176, CBOX37, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C37, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX37C2", PMC177, CBOX37, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C37, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX37C3", PMC178, CBOX37, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C37, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX38C0", PMC179, CBOX38, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C38, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX38C1", PMC180, CBOX38, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C38, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX38C2", PMC181, CBOX38, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C38, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX38C3", PMC182, CBOX38, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C38, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX39C0", PMC183, CBOX39, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C39, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX39C1", PMC184, CBOX39, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C39, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX39C2", PMC185, CBOX39, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C39, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX39C3", PMC186, CBOX39, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C39, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX40C0", PMC187, CBOX40, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C40, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX40C1", PMC188, CBOX40, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C40, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX40C2", PMC189, CBOX40, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C40, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX40C3", PMC190, CBOX40, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C40, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX41C0", PMC191, CBOX41, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C41, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX41C1", PMC192, CBOX41, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C41, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX41C2", PMC193, CBOX41, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C41, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX41C3", PMC194, CBOX41, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C41, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX42C0", PMC195, CBOX42, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C42, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX42C1", PMC196, CBOX42, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C42, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX42C2", PMC197, CBOX42, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C42, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX42C3", PMC198, CBOX42, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C42, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX43C0", PMC199, CBOX43, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C43, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX43C1", PMC200, CBOX43, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C43, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX43C2", PMC201, CBOX43, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C43, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX43C3", PMC202, CBOX43, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C43, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX44C0", PMC203, CBOX44, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C44, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX44C1", PMC204, CBOX44, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C44, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX44C2", PMC205, CBOX44, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C44, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX44C3", PMC206, CBOX44, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C44, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX45C0", PMC207, CBOX45, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C45, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX45C1", PMC208, CBOX45, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C45, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX45C2", PMC209, CBOX45, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C45, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX45C3", PMC210, CBOX45, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C45, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX46C0", PMC211, CBOX46, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C46, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX46C1", PMC212, CBOX46, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C46, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX46C2", PMC213, CBOX46, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C46, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX46C3", PMC214, CBOX46, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C46, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX47C0", PMC215, CBOX47, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C47, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX47C1", PMC216, CBOX47, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C47, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX47C2", PMC217, CBOX47, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C47, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX47C3", PMC218, CBOX47, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C47, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX48C0", PMC219, CBOX48, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C48, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX48C1", PMC220, CBOX48, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C48, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX48C2", PMC221, CBOX48, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C48, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX48C3", PMC222, CBOX48, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C48, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX49C0", PMC223, CBOX49, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C49, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX49C1", PMC224, CBOX49, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C49, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX49C2", PMC225, CBOX49, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C49, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX49C3", PMC226, CBOX49, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C49, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX50C0", PMC227, CBOX50, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C50, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX50C1", PMC228, CBOX50, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C50, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX50C2", PMC229, CBOX50, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C50, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX50C3", PMC230, CBOX50, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C50, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX51C0", PMC231, CBOX51, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C51, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX51C1", PMC232, CBOX51, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C51, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX51C2", PMC233, CBOX51, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C51, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX51C3", PMC234, CBOX51, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C51, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX52C0", PMC235, CBOX52, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C52, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX52C1", PMC236, CBOX52, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C52, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX52C2", PMC237, CBOX52, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C52, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX52C3", PMC238, CBOX52, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C52, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX53C0", PMC239, CBOX53, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C53, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX53C1", PMC240, CBOX53, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C53, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX53C2", PMC241, CBOX53, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C53, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX53C3", PMC242, CBOX53, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C53, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX54C0", PMC243, CBOX54, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C54, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX54C1", PMC244, CBOX54, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C54, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX54C2", PMC245, CBOX54, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C54, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX54C3", PMC246, CBOX54, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C54, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX55C0", PMC247, CBOX55, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C55, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX55C1", PMC248, CBOX55, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C55, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX55C2", PMC249, CBOX55, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C55, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX55C3", PMC250, CBOX55, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C55, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX56C0", PMC251, CBOX56, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C56, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX56C1", PMC252, CBOX56, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C56, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX56C2", PMC253, CBOX56, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C56, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX56C3", PMC254, CBOX56, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C56, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX57C0", PMC255, CBOX57, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C57, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX57C1", PMC256, CBOX57, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C57, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX57C2", PMC257, CBOX57, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C57, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX57C3", PMC258, CBOX57, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C57, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX58C0", PMC259, CBOX58, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C58, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX58C1", PMC260, CBOX58, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C58, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX58C2", PMC261, CBOX58, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C58, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX58C3", PMC262, CBOX58, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C58, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX59C0", PMC263, CBOX59, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_CBOX_DEVICE_C59, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX59C1", PMC264, CBOX59, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_CBOX_DEVICE_C59, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX59C2", PMC265, CBOX59, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_CBOX_DEVICE_C59, SPR_VALID_OPTIONS_UNCORE},
    {"CBOX59C3", PMC266, CBOX59, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_CBOX_DEVICE_C59, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX0C0", PMC267, MBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX0C1", PMC268, MBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX0C2", PMC269, MBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX0C3", PMC270, MBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX1C0", PMC271, MBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX1C1", PMC272, MBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX1C2", PMC273, MBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX1C3", PMC274, MBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX2C0", PMC275, MBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX2C1", PMC276, MBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX2C2", PMC277, MBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX2C3", PMC278, MBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX3C0", PMC279, MBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX3C1", PMC280, MBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX3C2", PMC281, MBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX3C3", PMC282, MBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX4C0", PMC283, MBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX4C1", PMC284, MBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX4C2", PMC285, MBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX4C3", PMC286, MBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_4, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX5C0", PMC287, MBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX5C1", PMC288, MBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX5C2", PMC289, MBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX5C3", PMC290, MBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_5, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX6C0", PMC291, MBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX6C1", PMC292, MBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX6C2", PMC293, MBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX6C3", PMC294, MBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_6, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX7C0", PMC295, MBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_0_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX7C1", PMC296, MBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_0_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX7C2", PMC297, MBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_0_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX7C3", PMC298, MBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_0_CH_7, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX8C0", PMC299, MBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX8C1", PMC300, MBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX8C2", PMC301, MBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX8C3", PMC302, MBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_0, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX9C0", PMC303, MBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX9C1", PMC304, MBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX9C2", PMC305, MBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX9C3", PMC306, MBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_1, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX10C0", PMC307, MBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX10C1", PMC308, MBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX10C2", PMC309, MBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX10C3", PMC310, MBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_2, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX11C0", PMC311, MBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_IMC_DEVICE_1_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX11C1", PMC312, MBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_IMC_DEVICE_1_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX11C2", PMC313, MBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_IMC_DEVICE_1_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"MBOX11C3", PMC314, MBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_IMC_DEVICE_1_CH_3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX0C0", PMC315, PBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE0, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX0C1", PMC316, PBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE0, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX0C2", PMC317, PBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE0, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX0C3", PMC318, PBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE0, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX1C0", PMC319, PBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE1, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX1C1", PMC320, PBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE1, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX1C2", PMC321, PBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE1, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX1C3", PMC322, PBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE1, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX2C0", PMC323, PBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE2, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX2C1", PMC324, PBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE2, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX2C2", PMC325, PBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE2, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX2C3", PMC326, PBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE2, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX3C0", PMC327, PBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX3C1", PMC328, PBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX3C2", PMC329, PBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX3C3", PMC330, PBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE3, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX4C0", PMC331, PBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE4, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX4C1", PMC332, PBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE4, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX4C2", PMC333, PBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE4, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX4C3", PMC334, PBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE4, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX5C0", PMC335, PBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE5, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX5C1", PMC336, PBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE5, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX5C2", PMC337, PBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE5, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX5C3", PMC338, PBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE5, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX6C0", PMC339, PBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE6, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX6C1", PMC340, PBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE6, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX6C2", PMC341, PBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE6, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX6C3", PMC342, PBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE6, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX7C0", PMC343, PBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE7, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX7C1", PMC344, PBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE7, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX7C2", PMC345, PBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE7, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX7C3", PMC346, PBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE7, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX8C0", PMC347, PBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE8, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX8C1", PMC348, PBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE8, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX8C2", PMC349, PBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE8, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX8C3", PMC350, PBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE8, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX9C0", PMC351, PBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE9, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX9C1", PMC352, PBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE9, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX9C2", PMC353, PBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE9, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX9C3", PMC354, PBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE9, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX10C0", PMC355, PBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE10, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX10C1", PMC356, PBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE10, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX10C2", PMC357, PBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE10, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX10C3", PMC358, PBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE10, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX11C0", PMC359, PBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R2PCIE_DEVICE11, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX11C1", PMC360, PBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R2PCIE_DEVICE11, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX11C2", PMC361, PBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R2PCIE_DEVICE11, SPR_VALID_OPTIONS_UNCORE},
    {"PBOX11C3", PMC362, PBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R2PCIE_DEVICE11, SPR_VALID_OPTIONS_UNCORE},
    {"WBOX0C0", PMC363, WBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_PCU_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"WBOX0C1", PMC364, WBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_PCU_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"WBOX0C2", PMC365, WBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_PCU_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"WBOX0C3", PMC366, WBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_PCU_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI0C0", PMC367, QBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI0C1", PMC368, QBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI0C2", PMC369, QBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI0C3", PMC370, QBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_0, SPR_VALID_OPTIONS_UNCORE},
    {"UPI1C0", PMC371, QBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_1, SPR_VALID_OPTIONS_UNCORE},
    {"UPI1C1", PMC372, QBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_1, SPR_VALID_OPTIONS_UNCORE},
    {"UPI1C2", PMC373, QBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_1, SPR_VALID_OPTIONS_UNCORE},
    {"UPI1C3", PMC374, QBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_1, SPR_VALID_OPTIONS_UNCORE},
    {"UPI2C0", PMC375, QBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_2, SPR_VALID_OPTIONS_UNCORE},
    {"UPI2C1", PMC376, QBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_2, SPR_VALID_OPTIONS_UNCORE},
    {"UPI2C2", PMC377, QBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_2, SPR_VALID_OPTIONS_UNCORE},
    {"UPI2C3", PMC378, QBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_2, SPR_VALID_OPTIONS_UNCORE},
    {"UPI3C0", PMC379, QBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_QPI_DEVICE_PORT_3, SPR_VALID_OPTIONS_UNCORE},
    {"UPI3C1", PMC380, QBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_QPI_DEVICE_PORT_3, SPR_VALID_OPTIONS_UNCORE},
    {"UPI3C2", PMC381, QBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_QPI_DEVICE_PORT_3, SPR_VALID_OPTIONS_UNCORE},
    {"UPI3C3", PMC382, QBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_QPI_DEVICE_PORT_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF0C0", PMC383, MDF0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"MDF0C1", PMC384, MDF0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"MDF0C2", PMC385, MDF0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"MDF0C3", PMC386, MDF0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"MDF1C0", PMC387, MDF1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"MDF1C1", PMC388, MDF1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"MDF1C2", PMC389, MDF1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"MDF1C3", PMC390, MDF1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"MDF2C0", PMC391, MDF2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"MDF2C1", PMC392, MDF2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"MDF2C2", PMC393, MDF2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"MDF2C3", PMC394, MDF2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"MDF3C0", PMC395, MDF3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF3C1", PMC396, MDF3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF3C2", PMC397, MDF3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF3C3", PMC398, MDF3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"MDF4C0", PMC399, MDF4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"MDF4C1", PMC400, MDF4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"MDF4C2", PMC401, MDF4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"MDF4C3", PMC402, MDF4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"MDF5C0", PMC403, MDF5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"MDF5C1", PMC404, MDF5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"MDF5C2", PMC405, MDF5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"MDF5C3", PMC406, MDF5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"MDF6C0", PMC407, MDF6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"MDF6C1", PMC408, MDF6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"MDF6C2", PMC409, MDF6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"MDF6C3", PMC410, MDF6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"MDF7C0", PMC411, MDF7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"MDF7C1", PMC412, MDF7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"MDF7C2", PMC413, MDF7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"MDF7C3", PMC414, MDF7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"MDF8C0", PMC415, MDF8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"MDF8C1", PMC416, MDF8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"MDF8C2", PMC417, MDF8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"MDF8C3", PMC418, MDF8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"MDF9C0", PMC419, MDF9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"MDF9C1", PMC420, MDF9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"MDF9C2", PMC421, MDF9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"MDF9C3", PMC422, MDF9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"MDF10C0", PMC423, MDF10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"MDF10C1", PMC424, MDF10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"MDF10C2", PMC425, MDF10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"MDF10C3", PMC426, MDF10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"MDF11C0", PMC427, MDF11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"MDF11C1", PMC428, MDF11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"MDF11C2", PMC429, MDF11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"MDF11C3", PMC430, MDF11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"MDF12C0", PMC431, MDF12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"MDF12C1", PMC432, MDF12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"MDF12C2", PMC433, MDF12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"MDF12C3", PMC434, MDF12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"MDF13C0", PMC435, MDF13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"MDF13C1", PMC436, MDF13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"MDF13C2", PMC437, MDF13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"MDF13C3", PMC438, MDF13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"MDF14C0", PMC439, MDF14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"MDF14C1", PMC440, MDF14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"MDF14C2", PMC441, MDF14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"MDF14C3", PMC442, MDF14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"MDF15C0", PMC443, MDF15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"MDF15C1", PMC444, MDF15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"MDF15C2", PMC445, MDF15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"MDF15C3", PMC446, MDF15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"MDF16C0", PMC447, MDF16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"MDF16C1", PMC448, MDF16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"MDF16C2", PMC449, MDF16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"MDF16C3", PMC450, MDF16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"MDF17C0", PMC451, MDF17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"MDF17C1", PMC452, MDF17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"MDF17C2", PMC453, MDF17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"MDF17C3", PMC454, MDF17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"MDF18C0", PMC455, MDF18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"MDF18C1", PMC456, MDF18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"MDF18C2", PMC457, MDF18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"MDF18C3", PMC458, MDF18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"MDF19C0", PMC459, MDF19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"MDF19C1", PMC460, MDF19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"MDF19C2", PMC461, MDF19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"MDF19C3", PMC462, MDF19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"MDF20C0", PMC463, MDF20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"MDF20C1", PMC464, MDF20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"MDF20C2", PMC465, MDF20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"MDF20C3", PMC466, MDF20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"MDF21C0", PMC467, MDF21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"MDF21C1", PMC468, MDF21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"MDF21C2", PMC469, MDF21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"MDF21C3", PMC470, MDF21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"MDF22C0", PMC471, MDF22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"MDF22C1", PMC472, MDF22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"MDF22C2", PMC473, MDF22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"MDF22C3", PMC474, MDF22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"MDF23C0", PMC475, MDF23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"MDF23C1", PMC476, MDF23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"MDF23C2", PMC477, MDF23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"MDF23C3", PMC478, MDF23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"MDF24C0", PMC479, MDF24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"MDF24C1", PMC480, MDF24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"MDF24C2", PMC481, MDF24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"MDF24C3", PMC482, MDF24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"MDF25C0", PMC483, MDF25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"MDF25C1", PMC484, MDF25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"MDF25C2", PMC485, MDF25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"MDF25C3", PMC486, MDF25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"MDF26C0", PMC487, MDF26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"MDF26C1", PMC488, MDF26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"MDF26C2", PMC489, MDF26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"MDF26C3", PMC490, MDF26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"MDF27C0", PMC491, MDF27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"MDF27C1", PMC492, MDF27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"MDF27C2", PMC493, MDF27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"MDF27C3", PMC494, MDF27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"MDF28C0", PMC495, MDF28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"MDF28C1", PMC496, MDF28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"MDF28C2", PMC497, MDF28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"MDF28C3", PMC498, MDF28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"MDF29C0", PMC499, MDF29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"MDF29C1", PMC500, MDF29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"MDF29C2", PMC501, MDF29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"MDF29C3", PMC502, MDF29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"MDF30C0", PMC503, MDF30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"MDF30C1", PMC504, MDF30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"MDF30C2", PMC505, MDF30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"MDF30C3", PMC506, MDF30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"MDF31C0", PMC507, MDF31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"MDF31C1", PMC508, MDF31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"MDF31C2", PMC509, MDF31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"MDF31C3", PMC510, MDF31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"MDF32C0", PMC511, MDF32, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_32, SPR_VALID_OPTIONS_UNCORE},
    {"MDF32C1", PMC512, MDF32, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_32, SPR_VALID_OPTIONS_UNCORE},
    {"MDF32C2", PMC513, MDF32, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_32, SPR_VALID_OPTIONS_UNCORE},
    {"MDF32C3", PMC514, MDF32, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_32, SPR_VALID_OPTIONS_UNCORE},
    {"MDF33C0", PMC515, MDF33, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_33, SPR_VALID_OPTIONS_UNCORE},
    {"MDF33C1", PMC516, MDF33, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_33, SPR_VALID_OPTIONS_UNCORE},
    {"MDF33C2", PMC517, MDF33, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_33, SPR_VALID_OPTIONS_UNCORE},
    {"MDF33C3", PMC518, MDF33, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_33, SPR_VALID_OPTIONS_UNCORE},
    {"MDF34C0", PMC519, MDF34, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_34, SPR_VALID_OPTIONS_UNCORE},
    {"MDF34C1", PMC520, MDF34, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_34, SPR_VALID_OPTIONS_UNCORE},
    {"MDF34C2", PMC521, MDF34, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_34, SPR_VALID_OPTIONS_UNCORE},
    {"MDF34C3", PMC522, MDF34, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_34, SPR_VALID_OPTIONS_UNCORE},
    {"MDF35C0", PMC523, MDF35, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_35, SPR_VALID_OPTIONS_UNCORE},
    {"MDF35C1", PMC524, MDF35, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_35, SPR_VALID_OPTIONS_UNCORE},
    {"MDF35C2", PMC525, MDF35, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_35, SPR_VALID_OPTIONS_UNCORE},
    {"MDF35C3", PMC526, MDF35, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_35, SPR_VALID_OPTIONS_UNCORE},
    {"MDF36C0", PMC527, MDF36, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_36, SPR_VALID_OPTIONS_UNCORE},
    {"MDF36C1", PMC528, MDF36, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_36, SPR_VALID_OPTIONS_UNCORE},
    {"MDF36C2", PMC529, MDF36, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_36, SPR_VALID_OPTIONS_UNCORE},
    {"MDF36C3", PMC530, MDF36, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_36, SPR_VALID_OPTIONS_UNCORE},
    {"MDF37C0", PMC531, MDF37, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_37, SPR_VALID_OPTIONS_UNCORE},
    {"MDF37C1", PMC532, MDF37, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_37, SPR_VALID_OPTIONS_UNCORE},
    {"MDF37C2", PMC533, MDF37, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_37, SPR_VALID_OPTIONS_UNCORE},
    {"MDF37C3", PMC534, MDF37, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_37, SPR_VALID_OPTIONS_UNCORE},
    {"MDF38C0", PMC535, MDF38, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_38, SPR_VALID_OPTIONS_UNCORE},
    {"MDF38C1", PMC536, MDF38, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_38, SPR_VALID_OPTIONS_UNCORE},
    {"MDF38C2", PMC537, MDF38, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_38, SPR_VALID_OPTIONS_UNCORE},
    {"MDF38C3", PMC538, MDF38, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_38, SPR_VALID_OPTIONS_UNCORE},
    {"MDF39C0", PMC539, MDF39, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_MDF_DEVICE_39, SPR_VALID_OPTIONS_UNCORE},
    {"MDF39C1", PMC540, MDF39, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_MDF_DEVICE_39, SPR_VALID_OPTIONS_UNCORE},
    {"MDF39C2", PMC541, MDF39, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_MDF_DEVICE_39, SPR_VALID_OPTIONS_UNCORE},
    {"MDF39C3", PMC542, MDF39, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_MDF_DEVICE_39, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX0C0", PMC543, BBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX0C1", PMC544, BBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX0C2", PMC545, BBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX0C3", PMC546, BBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX1C0", PMC547, BBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX1C1", PMC548, BBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX1C2", PMC549, BBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX1C3", PMC550, BBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX2C0", PMC551, BBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX2C1", PMC552, BBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX2C2", PMC553, BBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX2C3", PMC554, BBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX3C0", PMC555, BBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX3C1", PMC556, BBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX3C2", PMC557, BBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX3C3", PMC558, BBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX4C0", PMC559, BBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX4C1", PMC560, BBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX4C2", PMC561, BBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX4C3", PMC562, BBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX5C0", PMC563, BBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX5C1", PMC564, BBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX5C2", PMC565, BBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX5C3", PMC566, BBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX6C0", PMC567, BBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX6C1", PMC568, BBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX6C2", PMC569, BBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX6C3", PMC570, BBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX7C0", PMC571, BBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX7C1", PMC572, BBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX7C2", PMC573, BBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX7C3", PMC574, BBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX8C0", PMC575, BBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX8C1", PMC576, BBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX8C2", PMC577, BBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX8C3", PMC578, BBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX9C0", PMC579, BBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX9C1", PMC580, BBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX9C2", PMC581, BBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX9C3", PMC582, BBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX10C0", PMC583, BBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX10C1", PMC584, BBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX10C2", PMC585, BBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX10C3", PMC586, BBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX11C0", PMC587, BBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX11C1", PMC588, BBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX11C2", PMC589, BBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX11C3", PMC590, BBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX12C0", PMC591, BBOX12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX12C1", PMC592, BBOX12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX12C2", PMC593, BBOX12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX12C3", PMC594, BBOX12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX13C0", PMC595, BBOX13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX13C1", PMC596, BBOX13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX13C2", PMC597, BBOX13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX13C3", PMC598, BBOX13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX14C0", PMC599, BBOX14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX14C1", PMC600, BBOX14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX14C2", PMC601, BBOX14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX14C3", PMC602, BBOX14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX15C0", PMC603, BBOX15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX15C1", PMC604, BBOX15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX15C2", PMC605, BBOX15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX15C3", PMC606, BBOX15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX16C0", PMC607, BBOX16, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX16C1", PMC608, BBOX16, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX16C2", PMC609, BBOX16, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX16C3", PMC610, BBOX16, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_16, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX17C0", PMC611, BBOX17, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX17C1", PMC612, BBOX17, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX17C2", PMC613, BBOX17, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX17C3", PMC614, BBOX17, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_17, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX18C0", PMC615, BBOX18, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX18C1", PMC616, BBOX18, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX18C2", PMC617, BBOX18, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX18C3", PMC618, BBOX18, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_18, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX19C0", PMC619, BBOX19, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX19C1", PMC620, BBOX19, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX19C2", PMC621, BBOX19, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX19C3", PMC622, BBOX19, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_19, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX20C0", PMC623, BBOX20, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX20C1", PMC624, BBOX20, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX20C2", PMC625, BBOX20, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX20C3", PMC626, BBOX20, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_20, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX21C0", PMC627, BBOX21, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX21C1", PMC628, BBOX21, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX21C2", PMC629, BBOX21, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX21C3", PMC630, BBOX21, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_21, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX22C0", PMC631, BBOX22, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX22C1", PMC632, BBOX22, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX22C2", PMC633, BBOX22, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX22C3", PMC634, BBOX22, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_22, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX23C0", PMC635, BBOX23, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX23C1", PMC636, BBOX23, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX23C2", PMC637, BBOX23, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX23C3", PMC638, BBOX23, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_23, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX24C0", PMC639, BBOX24, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX24C1", PMC640, BBOX24, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX24C2", PMC641, BBOX24, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX24C3", PMC642, BBOX24, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_24, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX25C0", PMC643, BBOX25, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX25C1", PMC644, BBOX25, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX25C2", PMC645, BBOX25, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX25C3", PMC646, BBOX25, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_25, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX26C0", PMC647, BBOX26, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX26C1", PMC648, BBOX26, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX26C2", PMC649, BBOX26, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX26C3", PMC650, BBOX26, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_26, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX27C0", PMC651, BBOX27, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX27C1", PMC652, BBOX27, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX27C2", PMC653, BBOX27, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX27C3", PMC654, BBOX27, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_27, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX28C0", PMC655, BBOX28, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX28C1", PMC656, BBOX28, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX28C2", PMC657, BBOX28, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX28C3", PMC658, BBOX28, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_28, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX29C0", PMC659, BBOX29, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX29C1", PMC660, BBOX29, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX29C2", PMC661, BBOX29, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX29C3", PMC662, BBOX29, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_29, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX30C0", PMC663, BBOX30, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX30C1", PMC664, BBOX30, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX30C2", PMC665, BBOX30, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX30C3", PMC666, BBOX30, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_30, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX31C0", PMC667, BBOX31, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_HA_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX31C1", PMC668, BBOX31, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_HA_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX31C2", PMC669, BBOX31, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_HA_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"BBOX31C3", PMC670, BBOX31, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_HA_DEVICE_31, SPR_VALID_OPTIONS_UNCORE},
    {"IRP0C0", PMC671, IRP0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IRP0C1", PMC672, IRP0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IRP1C0", PMC673, IRP1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IRP1C1", PMC674, IRP1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IRP2C0", PMC675, IRP2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IRP2C1", PMC676, IRP2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IRP3C0", PMC677, IRP3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IRP3C1", PMC678, IRP3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IRP4C0", PMC679, IRP4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IRP4C1", PMC680, IRP4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IRP5C0", PMC681, IRP5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IRP5C1", PMC682, IRP5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IRP6C0", PMC683, IRP6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IRP6C1", PMC684, IRP6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IRP7C0", PMC685, IRP7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IRP7C1", PMC686, IRP7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IRP8C0", PMC687, IRP8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IRP8C1", PMC688, IRP8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IRP9C0", PMC689, IRP9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IRP9C1", PMC690, IRP9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IRP10C0", PMC691, IRP10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IRP10C1", PMC692, IRP10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IRP11C0", PMC693, IRP11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IRP_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IRP11C1", PMC694, IRP11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IRP_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IIO0C0", PMC695, IBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IIO0C1", PMC696, IBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IIO0C2", PMC697, IBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IIO0C3", PMC698, IBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"IIO1C0", PMC699, IBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IIO1C1", PMC700, IBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IIO1C2", PMC701, IBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IIO1C3", PMC702, IBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"IIO2C0", PMC703, IBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IIO2C1", PMC704, IBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IIO2C2", PMC705, IBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IIO2C3", PMC706, IBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"IIO3C0", PMC707, IBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IIO3C1", PMC708, IBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IIO3C2", PMC709, IBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IIO3C3", PMC710, IBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"IIO4C0", PMC711, IBOX4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IIO4C1", PMC712, IBOX4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IIO4C2", PMC713, IBOX4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IIO4C3", PMC714, IBOX4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"IIO5C0", PMC715, IBOX5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IIO5C1", PMC716, IBOX5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IIO5C2", PMC717, IBOX5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IIO5C3", PMC718, IBOX5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"IIO6C0", PMC719, IBOX6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IIO6C1", PMC720, IBOX6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IIO6C2", PMC721, IBOX6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IIO6C3", PMC722, IBOX6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"IIO7C0", PMC723, IBOX7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IIO7C1", PMC724, IBOX7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IIO7C2", PMC725, IBOX7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IIO7C3", PMC726, IBOX7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"IIO8C0", PMC727, IBOX8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IIO8C1", PMC728, IBOX8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IIO8C2", PMC729, IBOX8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IIO8C3", PMC730, IBOX8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"IIO9C0", PMC731, IBOX9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IIO9C1", PMC732, IBOX9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IIO9C2", PMC733, IBOX9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IIO9C3", PMC734, IBOX9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"IIO10C0", PMC735, IBOX10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IIO10C1", PMC736, IBOX10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IIO10C2", PMC737, IBOX10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IIO10C3", PMC738, IBOX10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"IIO11C0", PMC739, IBOX11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MSR_IIO_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IIO11C1", PMC740, IBOX11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MSR_IIO_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IIO11C2", PMC741, IBOX11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MSR_IIO_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"IIO11C3", PMC742, IBOX11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MSR_IIO_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0C0", PMC743, HBM0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0C1", PMC744, HBM0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0C2", PMC745, HBM0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"HBM0C3", PMC746, HBM0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_0, SPR_VALID_OPTIONS_UNCORE},
    {"HBM1C0", PMC747, HBM1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"HBM1C1", PMC748, HBM1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"HBM1C2", PMC749, HBM1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"HBM1C3", PMC750, HBM1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_1, SPR_VALID_OPTIONS_UNCORE},
    {"HBM2C0", PMC751, HBM2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"HBM2C1", PMC752, HBM2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"HBM2C2", PMC753, HBM2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"HBM2C3", PMC754, HBM2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_2, SPR_VALID_OPTIONS_UNCORE},
    {"HBM3C0", PMC755, HBM3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"HBM3C1", PMC756, HBM3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"HBM3C2", PMC757, HBM3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"HBM3C3", PMC758, HBM3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_3, SPR_VALID_OPTIONS_UNCORE},
    {"HBM4C0", PMC759, HBM4, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"HBM4C1", PMC760, HBM4, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"HBM4C2", PMC761, HBM4, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"HBM4C3", PMC762, HBM4, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_4, SPR_VALID_OPTIONS_UNCORE},
    {"HBM5C0", PMC763, HBM5, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"HBM5C1", PMC764, HBM5, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"HBM5C2", PMC765, HBM5, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"HBM5C3", PMC766, HBM5, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_5, SPR_VALID_OPTIONS_UNCORE},
    {"HBM6C0", PMC767, HBM6, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"HBM6C1", PMC768, HBM6, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"HBM6C2", PMC769, HBM6, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"HBM6C3", PMC770, HBM6, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_6, SPR_VALID_OPTIONS_UNCORE},
    {"HBM7C0", PMC771, HBM7, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"HBM7C1", PMC772, HBM7, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"HBM7C2", PMC773, HBM7, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"HBM7C3", PMC774, HBM7, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_7, SPR_VALID_OPTIONS_UNCORE},
    {"HBM8C0", PMC775, HBM8, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"HBM8C1", PMC776, HBM8, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"HBM8C2", PMC777, HBM8, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"HBM8C3", PMC778, HBM8, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_8, SPR_VALID_OPTIONS_UNCORE},
    {"HBM9C0", PMC779, HBM9, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"HBM9C1", PMC780, HBM9, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"HBM9C2", PMC781, HBM9, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"HBM9C3", PMC782, HBM9, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_9, SPR_VALID_OPTIONS_UNCORE},
    {"HBM10C0", PMC783, HBM10, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"HBM10C1", PMC784, HBM10, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"HBM10C2", PMC785, HBM10, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"HBM10C3", PMC786, HBM10, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_10, SPR_VALID_OPTIONS_UNCORE},
    {"HBM11C0", PMC787, HBM11, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM11C1", PMC788, HBM11, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM11C2", PMC789, HBM11, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM11C3", PMC790, HBM11, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_11, SPR_VALID_OPTIONS_UNCORE},
    {"HBM12C0", PMC791, HBM12, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"HBM12C1", PMC792, HBM12, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"HBM12C2", PMC793, HBM12, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"HBM12C3", PMC794, HBM12, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_12, SPR_VALID_OPTIONS_UNCORE},
    {"HBM13C0", PMC795, HBM13, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"HBM13C1", PMC796, HBM13, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"HBM13C2", PMC797, HBM13, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"HBM13C3", PMC798, HBM13, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_13, SPR_VALID_OPTIONS_UNCORE},
    {"HBM14C0", PMC799, HBM14, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"HBM14C1", PMC800, HBM14, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"HBM14C2", PMC801, HBM14, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"HBM14C3", PMC802, HBM14, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_14, SPR_VALID_OPTIONS_UNCORE},
    {"HBM15C0", PMC803, HBM15, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, MMIO_HBM_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"HBM15C1", PMC804, HBM15, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, MMIO_HBM_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"HBM15C2", PMC805, HBM15, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, MMIO_HBM_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"HBM15C3", PMC806, HBM15, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, MMIO_HBM_DEVICE_15, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX0C0", PMC807, RBOX0, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_0, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX0C1", PMC808, RBOX0, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_0, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX0C2", PMC809, RBOX0, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_0, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX0C3", PMC810, RBOX0, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_0, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX1C0", PMC811, RBOX1, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_1, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX1C1", PMC812, RBOX1, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_1, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX1C2", PMC813, RBOX1, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_1, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX1C3", PMC814, RBOX1, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_1, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX2C0", PMC815, RBOX2, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_2, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX2C1", PMC816, RBOX2, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_2, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX2C2", PMC817, RBOX2, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_2, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX2C3", PMC818, RBOX2, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_2, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX3C0", PMC819, RBOX3, FAKE_UNC_CTRL0, FAKE_UNC_CTR0, 0, PCI_R3QPI_DEVICE_LINK_3, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX3C1", PMC820, RBOX3, FAKE_UNC_CTRL1, FAKE_UNC_CTR1, 0, PCI_R3QPI_DEVICE_LINK_3, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX3C2", PMC821, RBOX3, FAKE_UNC_CTRL2, FAKE_UNC_CTR2, 0, PCI_R3QPI_DEVICE_LINK_3, SPR_VALID_OPTIONS_UNCORE},
    {"RBOX3C3", PMC822, RBOX3, FAKE_UNC_CTRL3, FAKE_UNC_CTR3, 0, PCI_R3QPI_DEVICE_LINK_3, SPR_VALID_OPTIONS_UNCORE},

};

static BoxMap sapphirerapids_box_map[NUM_UNITS] = {
    [FIXED] =  {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48, 0, 0},
    [PMC] = {MSR_PERF_GLOBAL_CTRL, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS_RESET, 0, 0, 0, 48, 0, 0},
    [THERMAL] = {0, 0, 0, 0, 0, 0, 8, 0, 0},
    [POWER] = {0, 0, 0, 0, 0, 0, 32, 0, 0},
    [VOLTAGE] = {0, 0, 0, 0, 0, 0, 16, 0, 0},
    [METRICS] = {0, MSR_V4_PERF_GLOBAL_STATUS, MSR_V4_PERF_GLOBAL_STATUS, 48, 0, 0, 8, 0, 0},
    [CBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C0, 48, 0, 0},
    [CBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C1, 48, 0, 0},
    [CBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C2, 48, 0, 0},
    [CBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C3, 48, 0, 0},
    [CBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C4, 48, 0, 0},
    [CBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C5, 48, 0, 0},
    [CBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C6, 48, 0, 0},
    [CBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C7, 48, 0, 0},
    [CBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C8, 48, 0, 0},
    [CBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C9, 48, 0, 0},
    [CBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C10, 48, 0, 0},
    [CBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C11, 48, 0, 0},
    [CBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C12, 48, 0, 0},
    [CBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C13, 48, 0, 0},
    [CBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C14, 48, 0, 0},
    [CBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C15, 48, 0, 0},
    [CBOX16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C16, 48, 0, 0},
    [CBOX17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C17, 48, 0, 0},
    [CBOX18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C18, 48, 0, 0},
    [CBOX19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C19, 48, 0, 0},
    [CBOX20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C20, 48, 0, 0},
    [CBOX21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C21, 48, 0, 0},
    [CBOX22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C22, 48, 0, 0},
    [CBOX23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C23, 48, 0, 0},
    [CBOX24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C24, 48, 0, 0},
    [CBOX25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C25, 48, 0, 0},
    [CBOX26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C26, 48, 0, 0},
    [CBOX27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C27, 48, 0, 0},
    [CBOX28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C28, 48, 0, 0},
    [CBOX29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C29, 48, 0, 0},
    [CBOX30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C30, 48, 0, 0},
    [CBOX31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C31, 48, 0, 0},
    [CBOX32] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C32, 48, 0, 0},
    [CBOX33] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C33, 48, 0, 0},
    [CBOX34] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C34, 48, 0, 0},
    [CBOX35] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C35, 48, 0, 0},
    [CBOX36] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C36, 48, 0, 0},
    [CBOX37] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C37, 48, 0, 0},
    [CBOX38] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C38, 48, 0, 0},
    [CBOX39] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C39, 48, 0, 0},
    [CBOX40] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C40, 48, 0, 0},
    [CBOX41] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C41, 48, 0, 0},
    [CBOX42] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C42, 48, 0, 0},
    [CBOX43] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C43, 48, 0, 0},
    [CBOX44] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C44, 48, 0, 0},
    [CBOX45] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C45, 48, 0, 0},
    [CBOX46] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C46, 48, 0, 0},
    [CBOX47] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C47, 48, 0, 0},
    [CBOX48] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C48, 48, 0, 0},
    [CBOX49] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C49, 48, 0, 0},
    [CBOX50] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C50, 48, 0, 0},
    [CBOX51] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C51, 48, 0, 0},
    [CBOX52] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C52, 48, 0, 0},
    [CBOX53] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C53, 48, 0, 0},
    [CBOX54] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C54, 48, 0, 0},
    [CBOX55] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C55, 48, 0, 0},
    [CBOX56] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C56, 48, 0, 0},
    [CBOX57] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C57, 48, 0, 0},
    [CBOX58] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C58, 48, 0, 0},
    [CBOX59] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_CBOX_DEVICE_C59, 48, 0, 0},
    [MBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_0, 48, 0, 0},
    [MBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_1, 48, 0, 0},
    [MBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_2, 48, 0, 0},
    [MBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_3, 48, 0, 0},
    [MBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_4, 48, 0, 0},
    [MBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_5, 48, 0, 0},
    [MBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_6, 48, 0, 0},
    [MBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_0_CH_7, 48, 0, 0},
    [MBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_0, 48, 0, 0},
    [MBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_1, 48, 0, 0},
    [MBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_2, 48, 0, 0},
    [MBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_IMC_DEVICE_1_CH_3, 48, 0, 0},
    [PBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE0, 48, 0, 0},
    [PBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE1, 48, 0, 0},
    [PBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE2, 48, 0, 0},
    [PBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE3, 48, 0, 0},
    [PBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE4, 48, 0, 0},
    [PBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE5, 48, 0, 0},
    [PBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE6, 48, 0, 0},
    [PBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE7, 48, 0, 0},
    [PBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE8, 48, 0, 0},
    [PBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE9, 48, 0, 0},
    [PBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE10, 48, 0, 0},
    [PBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R2PCIE_DEVICE11, 48, 0, 0},
    [WBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_PCU_DEVICE_0, 48, 0, 0},
    [QBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_0, 48, 0, 0},
    [QBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_1, 48, 0, 0},
    [QBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_2, 48, 0, 0},
    [QBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_QPI_DEVICE_PORT_3, 48, 0, 0},
    [MDF0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_0, 48, 0, 0},
    [MDF1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_1, 48, 0, 0},
    [MDF2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_2, 48, 0, 0},
    [MDF3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_3, 48, 0, 0},
    [MDF4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_4, 48, 0, 0},
    [MDF5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_5, 48, 0, 0},
    [MDF6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_6, 48, 0, 0},
    [MDF7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_7, 48, 0, 0},
    [MDF8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_8, 48, 0, 0},
    [MDF9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_9, 48, 0, 0},
    [MDF10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_10, 48, 0, 0},
    [MDF11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_11, 48, 0, 0},
    [MDF12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_12, 48, 0, 0},
    [MDF13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_13, 48, 0, 0},
    [MDF14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_14, 48, 0, 0},
    [MDF15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_15, 48, 0, 0},
    [MDF16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_16, 48, 0, 0},
    [MDF17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_17, 48, 0, 0},
    [MDF18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_18, 48, 0, 0},
    [MDF19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_19, 48, 0, 0},
    [MDF20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_20, 48, 0, 0},
    [MDF21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_21, 48, 0, 0},
    [MDF22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_22, 48, 0, 0},
    [MDF23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_23, 48, 0, 0},
    [MDF24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_24, 48, 0, 0},
    [MDF25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_25, 48, 0, 0},
    [MDF26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_26, 48, 0, 0},
    [MDF27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_27, 48, 0, 0},
    [MDF28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_28, 48, 0, 0},
    [MDF29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_29, 48, 0, 0},
    [MDF30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_30, 48, 0, 0},
    [MDF31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_31, 48, 0, 0},
    [MDF32] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_32, 48, 0, 0},
    [MDF33] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_33, 48, 0, 0},
    [MDF34] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_34, 48, 0, 0},
    [MDF35] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_35, 48, 0, 0},
    [MDF36] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_36, 48, 0, 0},
    [MDF37] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_37, 48, 0, 0},
    [MDF38] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_38, 48, 0, 0},
    [MDF39] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_MDF_DEVICE_39, 48, 0, 0},
    [BBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_0, 48, 0, 0},
    [BBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_1, 48, 0, 0},
    [BBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_2, 48, 0, 0},
    [BBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_3, 48, 0, 0},
    [BBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_4, 48, 0, 0},
    [BBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_5, 48, 0, 0},
    [BBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_6, 48, 0, 0},
    [BBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_7, 48, 0, 0},
    [BBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_8, 48, 0, 0},
    [BBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_9, 48, 0, 0},
    [BBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_10, 48, 0, 0},
    [BBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_11, 48, 0, 0},
    [BBOX12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_12, 48, 0, 0},
    [BBOX13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_13, 48, 0, 0},
    [BBOX14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_14, 48, 0, 0},
    [BBOX15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_15, 48, 0, 0},
    [BBOX16] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_16, 48, 0, 0},
    [BBOX17] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_17, 48, 0, 0},
    [BBOX18] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_18, 48, 0, 0},
    [BBOX19] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_19, 48, 0, 0},
    [BBOX20] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_20, 48, 0, 0},
    [BBOX21] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_21, 48, 0, 0},
    [BBOX22] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_22, 48, 0, 0},
    [BBOX23] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_23, 48, 0, 0},
    [BBOX24] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_24, 48, 0, 0},
    [BBOX25] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_25, 48, 0, 0},
    [BBOX26] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_26, 48, 0, 0},
    [BBOX27] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_27, 48, 0, 0},
    [BBOX28] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_28, 48, 0, 0},
    [BBOX29] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_29, 48, 0, 0},
    [BBOX30] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_30, 48, 0, 0},
    [BBOX31] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_HA_DEVICE_31, 48, 0, 0},
    [IRP0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_0, 48, 0, 0},
    [IRP1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_1, 48, 0, 0},
    [IRP2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_2, 48, 0, 0},
    [IRP3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_3, 48, 0, 0},
    [IRP4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_4, 48, 0, 0},
    [IRP5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_5, 48, 0, 0},
    [IRP6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_6, 48, 0, 0},
    [IRP7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_7, 48, 0, 0},
    [IRP8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_8, 48, 0, 0},
    [IRP9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_9, 48, 0, 0},
    [IRP10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_10, 48, 0, 0},
    [IRP11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IRP_DEVICE_11, 48, 0, 0},
    [IBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_0, 48, 0, 0},
    [IBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_1, 48, 0, 0},
    [IBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_2, 48, 0, 0},
    [IBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_3, 48, 0, 0},
    [IBOX4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_4, 48, 0, 0},
    [IBOX5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_5, 48, 0, 0},
    [IBOX6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_6, 48, 0, 0},
    [IBOX7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_7, 48, 0, 0},
    [IBOX8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_8, 48, 0, 0},
    [IBOX9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_9, 48, 0, 0},
    [IBOX10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_10, 48, 0, 0},
    [IBOX11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MSR_IIO_DEVICE_11, 48, 0, 0},
    [HBM0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_0, 48, 0, 0},
    [HBM1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_1, 48, 0, 0},
    [HBM2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_2, 48, 0, 0},
    [HBM3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_3, 48, 0, 0},
    [HBM4] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_4, 48, 0, 0},
    [HBM5] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_5, 48, 0, 0},
    [HBM6] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_6, 48, 0, 0},
    [HBM7] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_7, 48, 0, 0},
    [HBM8] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_8, 48, 0, 0},
    [HBM9] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_9, 48, 0, 0},
    [HBM10] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_10, 48, 0, 0},
    [HBM11] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_11, 48, 0, 0},
    [HBM12] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_12, 48, 0, 0},
    [HBM13] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_13, 48, 0, 0},
    [HBM14] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_14, 48, 0, 0},
    [HBM15] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, MMIO_HBM_DEVICE_15, 48, 0, 0},
    [RBOX0] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_0, 48, 0, 0},
    [RBOX1] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_1, 48, 0, 0},
    [RBOX2] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_2, 48, 0, 0},
    [RBOX3] = {FAKE_UNC_UNIT_CTRL, FAKE_UNC_UNIT_STATUS, FAKE_UNC_UNIT_STATUS, 0, 0, PCI_R3QPI_DEVICE_LINK_3, 48, 0, 0},
};

static PciDevice sapphirerapids_pci_devices[MAX_NUM_PCI_DEVICES] = {
    [MSR_DEV] = {NODEVTYPE, "", "MSR", "", 0, 0},
    [MMIO_IMC_DEVICE_0_CH_0] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX0", 0x3451, 0},
    [MMIO_IMC_DEVICE_0_CH_1] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX1", 0x3451, 0},
    [MMIO_IMC_DEVICE_0_CH_2] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX2", 0x3451, 0},
    [MMIO_IMC_DEVICE_0_CH_3] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX3", 0x3451, 0},
    [MMIO_IMC_DEVICE_0_CH_4] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX4", 0x3451, 0},
    [MMIO_IMC_DEVICE_0_CH_5] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX5", 0x3451, 0},
    [MMIO_IMC_DEVICE_0_CH_6] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX6", 0x3451, 0},
    [MMIO_IMC_DEVICE_0_CH_7] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX7", 0x3451, 0},
    [MMIO_IMC_DEVICE_1_CH_0] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX8", 0x3451, 0},
    [MMIO_IMC_DEVICE_1_CH_1] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX9", 0x3451, 0},
    [MMIO_IMC_DEVICE_1_CH_2] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX10", 0x3451, 0},
    [MMIO_IMC_DEVICE_1_CH_3] = {IMC, NULL, "MMAP_IMC_DEVICE", "MBOX11", 0x3451, 0},
    [MMIO_IMC_DEVICE_0_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV0", 0x3451, 0},
    [MMIO_IMC_DEVICE_1_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV1", 0x3451, 0},
    [MMIO_IMC_DEVICE_2_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV2", 0x3451, 0},
    [MMIO_IMC_DEVICE_3_FREERUN]= {IMC, NULL, "MMAP_IMC_FREERUN_DEVICE", "MDEV3", 0x3451, 0},
    [PCI_HA_DEVICE_0] = {HA, NULL, "PCI_HA_DEVICE_0", "M2M0", 0x0, 0},
    [PCI_HA_DEVICE_1] = {HA, NULL, "PCI_HA_DEVICE_1", "M2M1", 0x0, 0},
    [PCI_HA_DEVICE_2] = {HA, NULL, "PCI_HA_DEVICE_2", "M2M2", 0x0, 0},
    [PCI_HA_DEVICE_3] = {HA, NULL, "PCI_HA_DEVICE_3", "M2M3", 0x0, 0},
    [PCI_HA_DEVICE_4] = {HA, NULL, "PCI_HA_DEVICE_4", "M2M4", 0x0, 0},
    [PCI_HA_DEVICE_5] = {HA, NULL, "PCI_HA_DEVICE_5", "M2M5", 0x0, 0},
    [PCI_HA_DEVICE_6] = {HA, NULL, "PCI_HA_DEVICE_6", "M2M6", 0x0, 0},
    [PCI_HA_DEVICE_7] = {HA, NULL, "PCI_HA_DEVICE_7", "M2M7", 0x0, 0},
    [PCI_HA_DEVICE_8] = {HA, NULL, "PCI_HA_DEVICE_8", "M2M8", 0x0, 0},
    [PCI_HA_DEVICE_9] = {HA, NULL, "PCI_HA_DEVICE_9", "M2M9", 0x0, 0},
    [PCI_HA_DEVICE_10] = {HA, NULL, "PCI_HA_DEVICE_10", "M2M10", 0x0, 0},
    [PCI_HA_DEVICE_11] = {HA, NULL, "PCI_HA_DEVICE_11", "M2M11", 0x0, 0},
    [PCI_HA_DEVICE_12] = {HA, NULL, "PCI_HA_DEVICE_12", "M2M12", 0x0, 0},
    [PCI_HA_DEVICE_13] = {HA, NULL, "PCI_HA_DEVICE_13", "M2M13", 0x0, 0},
    [PCI_HA_DEVICE_14] = {HA, NULL, "PCI_HA_DEVICE_14", "M2M14", 0x0, 0},
    [PCI_HA_DEVICE_15] = {HA, NULL, "PCI_HA_DEVICE_15", "M2M15", 0x0, 0},
    [PCI_HA_DEVICE_16] = {HA, NULL, "PCI_HA_DEVICE_16", "M2M16", 0x0, 0},
    [PCI_HA_DEVICE_17] = {HA, NULL, "PCI_HA_DEVICE_17", "M2M17", 0x0, 0},
    [PCI_HA_DEVICE_18] = {HA, NULL, "PCI_HA_DEVICE_18", "M2M18", 0x0, 0},
    [PCI_HA_DEVICE_19] = {HA, NULL, "PCI_HA_DEVICE_19", "M2M19", 0x0, 0},
    [PCI_HA_DEVICE_20] = {HA, NULL, "PCI_HA_DEVICE_20", "M2M20", 0x0, 0},
    [PCI_HA_DEVICE_21] = {HA, NULL, "PCI_HA_DEVICE_21", "M2M21", 0x0, 0},
    [PCI_HA_DEVICE_22] = {HA, NULL, "PCI_HA_DEVICE_22", "M2M22", 0x0, 0},
    [PCI_HA_DEVICE_23] = {HA, NULL, "PCI_HA_DEVICE_23", "M2M23", 0x0, 0},
    [PCI_HA_DEVICE_24] = {HA, NULL, "PCI_HA_DEVICE_24", "M2M24", 0x0, 0},
    [PCI_HA_DEVICE_25] = {HA, NULL, "PCI_HA_DEVICE_25", "M2M25", 0x0, 0},
    [PCI_HA_DEVICE_26] = {HA, NULL, "PCI_HA_DEVICE_26", "M2M26", 0x0, 0},
    [PCI_HA_DEVICE_27] = {HA, NULL, "PCI_HA_DEVICE_27", "M2M27", 0x0, 0},
    [PCI_HA_DEVICE_28] = {HA, NULL, "PCI_HA_DEVICE_28", "M2M28", 0x0, 0},
    [PCI_HA_DEVICE_29] = {HA, NULL, "PCI_HA_DEVICE_29", "M2M29", 0x0, 0},
    [PCI_HA_DEVICE_30] = {HA, NULL, "PCI_HA_DEVICE_30", "M2M30", 0x0, 0},
    [PCI_HA_DEVICE_31] = {HA, NULL, "PCI_HA_DEVICE_31", "M2M31", 0x0, 0},
    [PCI_QPI_DEVICE_PORT_0] = {QPI, NULL, "PCI_QPI_DEVICE_PORT_0", "QBOX0", 0x0, 0},
    [PCI_QPI_DEVICE_PORT_1] = {QPI, NULL, "PCI_QPI_DEVICE_PORT_1", "QBOX1", 0x0, 0},
    [PCI_QPI_DEVICE_PORT_2] = {QPI, NULL, "PCI_QPI_DEVICE_PORT_2", "QBOX2", 0x0, 0},
    [PCI_QPI_DEVICE_PORT_3] = {QPI, NULL, "PCI_QPI_DEVICE_PORT_3", "QBOX3", 0x0, 0},
    [PCI_R3QPI_DEVICE_LINK_0] = {R3QPI, NULL, "PCI_R3QPI_DEVICE_LINK_0", "RBOX0", 0x0, 0},
    [PCI_R3QPI_DEVICE_LINK_1] = {R3QPI, NULL, "PCI_R3QPI_DEVICE_LINK_1", "RBOX1", 0x0, 0},
    [PCI_R3QPI_DEVICE_LINK_2] = {R3QPI, NULL, "PCI_R3QPI_DEVICE_LINK_2", "RBOX2", 0x0, 0},
    [PCI_R3QPI_DEVICE_LINK_3] = {R3QPI, NULL, "PCI_R3QPI_DEVICE_LINK_3", "RBOX3", 0x0, 0},
    [MSR_PCU_DEVICE] = {PCU, NULL, "MSR_PCU_DEVICE", "PCU", 0x0, 0},
    [MSR_IIO_DEVICE_0] = {IIO, NULL, "MSR_IIO_DEVICE_0", "IIO0", 0x0, 0},
    [MSR_IIO_DEVICE_1] = {IIO, NULL, "MSR_IIO_DEVICE_1", "IIO1", 0x0, 0},
    [MSR_IIO_DEVICE_2] = {IIO, NULL, "MSR_IIO_DEVICE_2", "IIO2", 0x0, 0},
    [MSR_IIO_DEVICE_3] = {IIO, NULL, "MSR_IIO_DEVICE_3", "IIO3", 0x0, 0},
    [MSR_IIO_DEVICE_4] = {IIO, NULL, "MSR_IIO_DEVICE_4", "IIO4", 0x0, 0},
    [MSR_IIO_DEVICE_5] = {IIO, NULL, "MSR_IIO_DEVICE_5", "IIO5", 0x0, 0},
    [MSR_IIO_DEVICE_6] = {IIO, NULL, "MSR_IIO_DEVICE_6", "IIO6", 0x0, 0},
    [MSR_IIO_DEVICE_7] = {IIO, NULL, "MSR_IIO_DEVICE_7", "IIO7", 0x0, 0},
    [MSR_IIO_DEVICE_8] = {IIO, NULL, "MSR_IIO_DEVICE_8", "IIO8", 0x0, 0},
    [MSR_IIO_DEVICE_9] = {IIO, NULL, "MSR_IIO_DEVICE_9", "IIO9", 0x0, 0},
    [MSR_IIO_DEVICE_10] = {IIO, NULL, "MSR_IIO_DEVICE_10", "IIO10", 0x0, 0},
    [MSR_IIO_DEVICE_11] = {IIO, NULL, "MSR_IIO_DEVICE_11", "IIO11", 0x0, 0},
    [MSR_IIO_DEVICE_12] = {IIO, NULL, "MSR_IIO_DEVICE_12", "IIO12", 0x0, 0},
    [MSR_IIO_DEVICE_13] = {IIO, NULL, "MSR_IIO_DEVICE_13", "IIO13", 0x0, 0},
    [MSR_IIO_DEVICE_14] = {IIO, NULL, "MSR_IIO_DEVICE_14", "IIO14", 0x0, 0},
    [MSR_IIO_DEVICE_15] = {IIO, NULL, "MSR_IIO_DEVICE_15", "IIO15", 0x0, 0},
    [MSR_IRP_DEVICE_0] = {IRP, NULL, "MSR_IRP_DEVICE_0", "IRP0", 0x0, 0},
    [MSR_IRP_DEVICE_1] = {IRP, NULL, "MSR_IRP_DEVICE_1", "IRP1", 0x0, 0},
    [MSR_IRP_DEVICE_2] = {IRP, NULL, "MSR_IRP_DEVICE_2", "IRP2", 0x0, 0},
    [MSR_IRP_DEVICE_3] = {IRP, NULL, "MSR_IRP_DEVICE_3", "IRP3", 0x0, 0},
    [MSR_IRP_DEVICE_4] = {IRP, NULL, "MSR_IRP_DEVICE_4", "IRP4", 0x0, 0},
    [MSR_IRP_DEVICE_5] = {IRP, NULL, "MSR_IRP_DEVICE_5", "IRP5", 0x0, 0},
    [MSR_IRP_DEVICE_6] = {IRP, NULL, "MSR_IRP_DEVICE_6", "IRP6", 0x0, 0},
    [MSR_IRP_DEVICE_7] = {IRP, NULL, "MSR_IRP_DEVICE_7", "IRP7", 0x0, 0},
    [MSR_IRP_DEVICE_8] = {IRP, NULL, "MSR_IRP_DEVICE_8", "IRP8", 0x0, 0},
    [MSR_IRP_DEVICE_9] = {IRP, NULL, "MSR_IRP_DEVICE_9", "IRP9", 0x0, 0},
    [MSR_IRP_DEVICE_10] = {IRP, NULL, "MSR_IRP_DEVICE_10", "IRP10", 0x0, 0},
    [MSR_IRP_DEVICE_11] = {IRP, NULL, "MSR_IRP_DEVICE_11", "IRP11", 0x0, 0},
    [MSR_IRP_DEVICE_12] = {IRP, NULL, "MSR_IRP_DEVICE_12", "IRP12", 0x0, 0},
    [MSR_IRP_DEVICE_13] = {IRP, NULL, "MSR_IRP_DEVICE_13", "IRP13", 0x0, 0},
    [MSR_IRP_DEVICE_14] = {IRP, NULL, "MSR_IRP_DEVICE_14", "IRP14", 0x0, 0},
    [MSR_IRP_DEVICE_15] = {IRP, NULL, "MSR_IRP_DEVICE_15", "IRP15", 0x0, 0},
    [PCI_R2PCIE_DEVICE0] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE0", "PBOX0", 0x0, 0},
    [PCI_R2PCIE_DEVICE1] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE1", "PBOX1", 0x0, 0},
    [PCI_R2PCIE_DEVICE2] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE2", "PBOX2", 0x0, 0},
    [PCI_R2PCIE_DEVICE3] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE3", "PBOX3", 0x0, 0},
    [PCI_R2PCIE_DEVICE4] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE4", "PBOX4", 0x0, 0},
    [PCI_R2PCIE_DEVICE5] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE5", "PBOX5", 0x0, 0},
    [PCI_R2PCIE_DEVICE6] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE6", "PBOX6", 0x0, 0},
    [PCI_R2PCIE_DEVICE7] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE7", "PBOX7", 0x0, 0},
    [PCI_R2PCIE_DEVICE8] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE8", "PBOX8", 0x0, 0},
    [PCI_R2PCIE_DEVICE9] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE9", "PBOX9", 0x0, 0},
    [PCI_R2PCIE_DEVICE10] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE10", "PBOX10", 0x0, 0},
    [PCI_R2PCIE_DEVICE11] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE11", "PBOX11", 0x0, 0},
    [PCI_R2PCIE_DEVICE12] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE12", "PBOX12", 0x0, 0},
    [PCI_R2PCIE_DEVICE13] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE13", "PBOX13", 0x0, 0},
    [PCI_R2PCIE_DEVICE14] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE14", "PBOX14", 0x0, 0},
    [PCI_R2PCIE_DEVICE15] = {R2PCIE, NULL, "PCI_R2PCIE_DEVICE15", "PBOX15", 0x0, 0},
};

static char* sapphirerapids_translate_types[NUM_UNITS] = {
    [FIXED] = "/sys/bus/event_source/devices/cpu",
    [PMC] = "/sys/bus/event_source/devices/cpu",
    // I don't get it to work, so no TMA metrics with perf_event at the moment
    [METRICS] = "/sys/bus/event_source/devices/cpu",
    [POWER] = "/sys/bus/event_source/devices/power",
    [CBOX0] = "/sys/bus/event_source/devices/uncore_cha_0",
    [CBOX1] = "/sys/bus/event_source/devices/uncore_cha_1",
    [CBOX2] = "/sys/bus/event_source/devices/uncore_cha_2",
    [CBOX3] = "/sys/bus/event_source/devices/uncore_cha_3",
    [CBOX4] = "/sys/bus/event_source/devices/uncore_cha_4",
    [CBOX5] = "/sys/bus/event_source/devices/uncore_cha_5",
    [CBOX6] = "/sys/bus/event_source/devices/uncore_cha_6",
    [CBOX7] = "/sys/bus/event_source/devices/uncore_cha_7",
    [CBOX8] = "/sys/bus/event_source/devices/uncore_cha_8",
    [CBOX9] = "/sys/bus/event_source/devices/uncore_cha_9",
    [CBOX10] = "/sys/bus/event_source/devices/uncore_cha_10",
    [CBOX11] = "/sys/bus/event_source/devices/uncore_cha_11",
    [CBOX12] = "/sys/bus/event_source/devices/uncore_cha_12",
    [CBOX13] = "/sys/bus/event_source/devices/uncore_cha_13",
    [CBOX14] = "/sys/bus/event_source/devices/uncore_cha_14",
    [CBOX15] = "/sys/bus/event_source/devices/uncore_cha_15",
    [CBOX16] = "/sys/bus/event_source/devices/uncore_cha_16",
    [CBOX17] = "/sys/bus/event_source/devices/uncore_cha_17",
    [CBOX18] = "/sys/bus/event_source/devices/uncore_cha_18",
    [CBOX19] = "/sys/bus/event_source/devices/uncore_cha_19",
    [CBOX20] = "/sys/bus/event_source/devices/uncore_cha_20",
    [CBOX21] = "/sys/bus/event_source/devices/uncore_cha_21",
    [CBOX22] = "/sys/bus/event_source/devices/uncore_cha_22",
    [CBOX23] = "/sys/bus/event_source/devices/uncore_cha_23",
    [CBOX24] = "/sys/bus/event_source/devices/uncore_cha_24",
    [CBOX25] = "/sys/bus/event_source/devices/uncore_cha_25",
    [CBOX26] = "/sys/bus/event_source/devices/uncore_cha_26",
    [CBOX27] = "/sys/bus/event_source/devices/uncore_cha_27",
    [CBOX28] = "/sys/bus/event_source/devices/uncore_cha_28",
    [CBOX29] = "/sys/bus/event_source/devices/uncore_cha_29",
    [CBOX30] = "/sys/bus/event_source/devices/uncore_cha_30",
    [CBOX31] = "/sys/bus/event_source/devices/uncore_cha_31",
    [CBOX32] = "/sys/bus/event_source/devices/uncore_cha_32",
    [CBOX33] = "/sys/bus/event_source/devices/uncore_cha_33",
    [CBOX34] = "/sys/bus/event_source/devices/uncore_cha_34",
    [CBOX35] = "/sys/bus/event_source/devices/uncore_cha_35",
    [CBOX36] = "/sys/bus/event_source/devices/uncore_cha_36",
    [CBOX37] = "/sys/bus/event_source/devices/uncore_cha_37",
    [CBOX38] = "/sys/bus/event_source/devices/uncore_cha_38",
    [CBOX39] = "/sys/bus/event_source/devices/uncore_cha_39",
    [CBOX40] = "/sys/bus/event_source/devices/uncore_cha_40",
    [CBOX41] = "/sys/bus/event_source/devices/uncore_cha_41",
    [CBOX42] = "/sys/bus/event_source/devices/uncore_cha_42",
    [CBOX43] = "/sys/bus/event_source/devices/uncore_cha_43",
    [CBOX44] = "/sys/bus/event_source/devices/uncore_cha_44",
    [CBOX45] = "/sys/bus/event_source/devices/uncore_cha_45",
    [CBOX46] = "/sys/bus/event_source/devices/uncore_cha_46",
    [CBOX47] = "/sys/bus/event_source/devices/uncore_cha_47",
    [CBOX48] = "/sys/bus/event_source/devices/uncore_cha_48",
    [CBOX49] = "/sys/bus/event_source/devices/uncore_cha_49",
    [CBOX50] = "/sys/bus/event_source/devices/uncore_cha_50",
    [CBOX51] = "/sys/bus/event_source/devices/uncore_cha_51",
    [CBOX52] = "/sys/bus/event_source/devices/uncore_cha_52",
    [CBOX53] = "/sys/bus/event_source/devices/uncore_cha_53",
    [CBOX54] = "/sys/bus/event_source/devices/uncore_cha_54",
    [CBOX55] = "/sys/bus/event_source/devices/uncore_cha_55",
    [CBOX56] = "/sys/bus/event_source/devices/uncore_cha_56",
    [CBOX57] = "/sys/bus/event_source/devices/uncore_cha_57",
    [CBOX58] = "/sys/bus/event_source/devices/uncore_cha_58",
    [CBOX59] = "/sys/bus/event_source/devices/uncore_cha_59",
    [MBOX0] = "/sys/bus/event_source/devices/uncore_imc_0",
    [MBOX1] = "/sys/bus/event_source/devices/uncore_imc_1",
    [MBOX2] = "/sys/bus/event_source/devices/uncore_imc_2",
    [MBOX3] = "/sys/bus/event_source/devices/uncore_imc_3",
    [MBOX4] = "/sys/bus/event_source/devices/uncore_imc_4",
    [MBOX5] = "/sys/bus/event_source/devices/uncore_imc_5",
    [MBOX6] = "/sys/bus/event_source/devices/uncore_imc_6",
    [MBOX7] = "/sys/bus/event_source/devices/uncore_imc_7",
    [MBOX8] = "/sys/bus/event_source/devices/uncore_imc_8",
    [MBOX9] = "/sys/bus/event_source/devices/uncore_imc_9",
    [MBOX10] = "/sys/bus/event_source/devices/uncore_imc_10",
    [MBOX11] = "/sys/bus/event_source/devices/uncore_imc_11",
    [PBOX0] = "/sys/bus/event_source/devices/uncore_m2pcie_0",
    [PBOX1] = "/sys/bus/event_source/devices/uncore_m2pcie_1",
    [PBOX2] = "/sys/bus/event_source/devices/uncore_m2pcie_2",
    [PBOX3] = "/sys/bus/event_source/devices/uncore_m2pcie_3",
    [PBOX4] = "/sys/bus/event_source/devices/uncore_m2pcie_4",
    [PBOX5] = "/sys/bus/event_source/devices/uncore_m2pcie_5",
    [PBOX6] = "/sys/bus/event_source/devices/uncore_m2pcie_6",
    [PBOX7] = "/sys/bus/event_source/devices/uncore_m2pcie_7",
    [PBOX8] = "/sys/bus/event_source/devices/uncore_m2pcie_8",
    [PBOX9] = "/sys/bus/event_source/devices/uncore_m2pcie_9",
    [PBOX10] = "/sys/bus/event_source/devices/uncore_m2pcie_10",
    [PBOX11] = "/sys/bus/event_source/devices/uncore_m2pcie_11",
    [WBOX0] = "/sys/bus/event_source/devices/uncore_pcu_0",
    [QBOX0] = "/sys/bus/event_source/devices/uncore_upi_0",
    [QBOX1] = "/sys/bus/event_source/devices/uncore_upi_1",
    [QBOX2] = "/sys/bus/event_source/devices/uncore_upi_2",
    [QBOX3] = "/sys/bus/event_source/devices/uncore_upi_3",
    [MDF0] = "/sys/bus/event_source/devices/uncore_mdf_0",
    [MDF1] = "/sys/bus/event_source/devices/uncore_mdf_1",
    [MDF2] = "/sys/bus/event_source/devices/uncore_mdf_2",
    [MDF3] = "/sys/bus/event_source/devices/uncore_mdf_3",
    [MDF4] = "/sys/bus/event_source/devices/uncore_mdf_4",
    [MDF5] = "/sys/bus/event_source/devices/uncore_mdf_5",
    [MDF6] = "/sys/bus/event_source/devices/uncore_mdf_6",
    [MDF7] = "/sys/bus/event_source/devices/uncore_mdf_7",
    [MDF8] = "/sys/bus/event_source/devices/uncore_mdf_8",
    [MDF9] = "/sys/bus/event_source/devices/uncore_mdf_9",
    [MDF10] = "/sys/bus/event_source/devices/uncore_mdf_10",
    [MDF11] = "/sys/bus/event_source/devices/uncore_mdf_11",
    [MDF12] = "/sys/bus/event_source/devices/uncore_mdf_12",
    [MDF13] = "/sys/bus/event_source/devices/uncore_mdf_13",
    [MDF14] = "/sys/bus/event_source/devices/uncore_mdf_14",
    [MDF15] = "/sys/bus/event_source/devices/uncore_mdf_15",
    [MDF16] = "/sys/bus/event_source/devices/uncore_mdf_16",
    [MDF17] = "/sys/bus/event_source/devices/uncore_mdf_17",
    [MDF18] = "/sys/bus/event_source/devices/uncore_mdf_18",
    [MDF19] = "/sys/bus/event_source/devices/uncore_mdf_19",
    [MDF20] = "/sys/bus/event_source/devices/uncore_mdf_20",
    [MDF21] = "/sys/bus/event_source/devices/uncore_mdf_21",
    [MDF22] = "/sys/bus/event_source/devices/uncore_mdf_22",
    [MDF23] = "/sys/bus/event_source/devices/uncore_mdf_23",
    [MDF24] = "/sys/bus/event_source/devices/uncore_mdf_24",
    [MDF25] = "/sys/bus/event_source/devices/uncore_mdf_25",
    [MDF26] = "/sys/bus/event_source/devices/uncore_mdf_26",
    [MDF27] = "/sys/bus/event_source/devices/uncore_mdf_27",
    [MDF28] = "/sys/bus/event_source/devices/uncore_mdf_28",
    [MDF29] = "/sys/bus/event_source/devices/uncore_mdf_29",
    [MDF30] = "/sys/bus/event_source/devices/uncore_mdf_30",
    [MDF31] = "/sys/bus/event_source/devices/uncore_mdf_31",
    [MDF32] = "/sys/bus/event_source/devices/uncore_mdf_32",
    [MDF33] = "/sys/bus/event_source/devices/uncore_mdf_33",
    [MDF34] = "/sys/bus/event_source/devices/uncore_mdf_34",
    [MDF35] = "/sys/bus/event_source/devices/uncore_mdf_35",
    [MDF36] = "/sys/bus/event_source/devices/uncore_mdf_36",
    [MDF37] = "/sys/bus/event_source/devices/uncore_mdf_37",
    [MDF38] = "/sys/bus/event_source/devices/uncore_mdf_38",
    [MDF39] = "/sys/bus/event_source/devices/uncore_mdf_39",
    [BBOX0] = "/sys/bus/event_source/devices/uncore_m2m_0",
    [BBOX1] = "/sys/bus/event_source/devices/uncore_m2m_1",
    [BBOX2] = "/sys/bus/event_source/devices/uncore_m2m_2",
    [BBOX3] = "/sys/bus/event_source/devices/uncore_m2m_3",
    [BBOX4] = "/sys/bus/event_source/devices/uncore_m2m_4",
    [BBOX5] = "/sys/bus/event_source/devices/uncore_m2m_5",
    [BBOX6] = "/sys/bus/event_source/devices/uncore_m2m_6",
    [BBOX7] = "/sys/bus/event_source/devices/uncore_m2m_7",
    [BBOX8] = "/sys/bus/event_source/devices/uncore_m2m_8",
    [BBOX9] = "/sys/bus/event_source/devices/uncore_m2m_9",
    [BBOX10] = "/sys/bus/event_source/devices/uncore_m2m_10",
    [BBOX11] = "/sys/bus/event_source/devices/uncore_m2m_11",
    [BBOX12] = "/sys/bus/event_source/devices/uncore_m2m_12",
    [BBOX13] = "/sys/bus/event_source/devices/uncore_m2m_13",
    [BBOX14] = "/sys/bus/event_source/devices/uncore_m2m_14",
    [BBOX15] = "/sys/bus/event_source/devices/uncore_m2m_15",
    [BBOX16] = "/sys/bus/event_source/devices/uncore_m2m_16",
    [BBOX17] = "/sys/bus/event_source/devices/uncore_m2m_17",
    [BBOX18] = "/sys/bus/event_source/devices/uncore_m2m_18",
    [BBOX19] = "/sys/bus/event_source/devices/uncore_m2m_19",
    [BBOX20] = "/sys/bus/event_source/devices/uncore_m2m_20",
    [BBOX21] = "/sys/bus/event_source/devices/uncore_m2m_21",
    [BBOX22] = "/sys/bus/event_source/devices/uncore_m2m_22",
    [BBOX23] = "/sys/bus/event_source/devices/uncore_m2m_23",
    [BBOX24] = "/sys/bus/event_source/devices/uncore_m2m_24",
    [BBOX25] = "/sys/bus/event_source/devices/uncore_m2m_25",
    [BBOX26] = "/sys/bus/event_source/devices/uncore_m2m_26",
    [BBOX27] = "/sys/bus/event_source/devices/uncore_m2m_27",
    [BBOX28] = "/sys/bus/event_source/devices/uncore_m2m_28",
    [BBOX29] = "/sys/bus/event_source/devices/uncore_m2m_29",
    [BBOX30] = "/sys/bus/event_source/devices/uncore_m2m_30",
    [BBOX31] = "/sys/bus/event_source/devices/uncore_m2m_31",
    [IRP0] = "/sys/bus/event_source/devices/uncore_irp_0",
    [IRP1] = "/sys/bus/event_source/devices/uncore_irp_1",
    [IRP2] = "/sys/bus/event_source/devices/uncore_irp_2",
    [IRP3] = "/sys/bus/event_source/devices/uncore_irp_3",
    [IRP4] = "/sys/bus/event_source/devices/uncore_irp_4",
    [IRP5] = "/sys/bus/event_source/devices/uncore_irp_5",
    [IRP6] = "/sys/bus/event_source/devices/uncore_irp_6",
    [IRP7] = "/sys/bus/event_source/devices/uncore_irp_7",
    [IRP8] = "/sys/bus/event_source/devices/uncore_irp_8",
    [IRP9] = "/sys/bus/event_source/devices/uncore_irp_9",
    [IRP10] = "/sys/bus/event_source/devices/uncore_irp_10",
    [IRP11] = "/sys/bus/event_source/devices/uncore_irp_11",
    [IBOX0] = "/sys/bus/event_source/devices/uncore_iio_0",
    [IBOX1] = "/sys/bus/event_source/devices/uncore_iio_1",
    [IBOX2] = "/sys/bus/event_source/devices/uncore_iio_2",
    [IBOX3] = "/sys/bus/event_source/devices/uncore_iio_3",
    [IBOX4] = "/sys/bus/event_source/devices/uncore_iio_4",
    [IBOX5] = "/sys/bus/event_source/devices/uncore_iio_5",
    [IBOX6] = "/sys/bus/event_source/devices/uncore_iio_6",
    [IBOX7] = "/sys/bus/event_source/devices/uncore_iio_7",
    [IBOX8] = "/sys/bus/event_source/devices/uncore_iio_8",
    [IBOX9] = "/sys/bus/event_source/devices/uncore_iio_9",
    [IBOX10] = "/sys/bus/event_source/devices/uncore_iio_10",
    [IBOX11] = "/sys/bus/event_source/devices/uncore_iio_11",
    [HBM0] = "/sys/bus/event_source/devices/uncore_hbm_0 /sys/bus/event_source/devices/uncore_type_14_0",
    [HBM1] = "/sys/bus/event_source/devices/uncore_hbm_1 /sys/bus/event_source/devices/uncore_type_14_1",
    [HBM2] = "/sys/bus/event_source/devices/uncore_hbm_2 /sys/bus/event_source/devices/uncore_type_14_2",
    [HBM3] = "/sys/bus/event_source/devices/uncore_hbm_3 /sys/bus/event_source/devices/uncore_type_14_3",
    [HBM4] = "/sys/bus/event_source/devices/uncore_hbm_4 /sys/bus/event_source/devices/uncore_type_14_4",
    [HBM5] = "/sys/bus/event_source/devices/uncore_hbm_5 /sys/bus/event_source/devices/uncore_type_14_5",
    [HBM6] = "/sys/bus/event_source/devices/uncore_hbm_6 /sys/bus/event_source/devices/uncore_type_14_6",
    [HBM7] = "/sys/bus/event_source/devices/uncore_hbm_7 /sys/bus/event_source/devices/uncore_type_14_7",
    [HBM8] = "/sys/bus/event_source/devices/uncore_hbm_8 /sys/bus/event_source/devices/uncore_type_14_8",
    [HBM9] = "/sys/bus/event_source/devices/uncore_hbm_9 /sys/bus/event_source/devices/uncore_type_14_9",
    [HBM10] = "/sys/bus/event_source/devices/uncore_hbm_10 /sys/bus/event_source/devices/uncore_type_14_10",
    [HBM11] = "/sys/bus/event_source/devices/uncore_hbm_11 /sys/bus/event_source/devices/uncore_type_14_11",
    [HBM12] = "/sys/bus/event_source/devices/uncore_hbm_12 /sys/bus/event_source/devices/uncore_type_14_12",
    [HBM13] = "/sys/bus/event_source/devices/uncore_hbm_13 /sys/bus/event_source/devices/uncore_type_14_13",
    [HBM14] = "/sys/bus/event_source/devices/uncore_hbm_14 /sys/bus/event_source/devices/uncore_type_14_14",
    [HBM15] = "/sys/bus/event_source/devices/uncore_hbm_15 /sys/bus/event_source/devices/uncore_type_14_15",
    [RBOX0] = "/sys/bus/event_source/devices/uncore_m3upi_0",
    [RBOX1] = "/sys/bus/event_source/devices/uncore_m3upi_1",
    [RBOX2] = "/sys/bus/event_source/devices/uncore_m3upi_2",
    [RBOX3] = "/sys/bus/event_source/devices/uncore_m3upi_3",
};

static char* registerTypeNamesSapphireRapids[MAX_UNITS] = {
    [CBOX0] = "Caching home agent 0",
    [CBOX1] = "Caching home agent 1",
    [CBOX2] = "Caching home agent 2",
    [CBOX3] = "Caching home agent 3",
    [CBOX4] = "Caching home agent 4",
    [CBOX5] = "Caching home agent 5",
    [CBOX6] = "Caching home agent 6",
    [CBOX7] = "Caching home agent 7",
    [CBOX8] = "Caching home agent 8",
    [CBOX9] = "Caching home agent 9",
    [CBOX10] = "Caching home agent 10",
    [CBOX11] = "Caching home agent 11",
    [CBOX12] = "Caching home agent 12",
    [CBOX13] = "Caching home agent 13",
    [CBOX14] = "Caching home agent 14",
    [CBOX15] = "Caching home agent 15",
    [CBOX16] = "Caching home agent 16",
    [CBOX17] = "Caching home agent 17",
    [CBOX18] = "Caching home agent 18",
    [CBOX19] = "Caching home agent 19",
    [CBOX20] = "Caching home agent 20",
    [CBOX21] = "Caching home agent 21",
    [CBOX22] = "Caching home agent 22",
    [CBOX23] = "Caching home agent 23",
    [CBOX24] = "Caching home agent 24",
    [CBOX25] = "Caching home agent 25",
    [CBOX26] = "Caching home agent 26",
    [CBOX27] = "Caching home agent 27",
    [CBOX28] = "Caching home agent 28",
    [CBOX29] = "Caching home agent 29",
    [CBOX30] = "Caching home agent 30",
    [CBOX31] = "Caching home agent 31",
    [CBOX32] = "Caching home agent 32",
    [CBOX33] = "Caching home agent 33",
    [CBOX34] = "Caching home agent 34",
    [CBOX35] = "Caching home agent 35",
    [CBOX36] = "Caching home agent 36",
    [CBOX37] = "Caching home agent 37",
    [CBOX38] = "Caching home agent 38",
    [CBOX39] = "Caching home agent 39",
    [CBOX40] = "Caching home agent 40",
    [CBOX41] = "Caching home agent 41",
    [CBOX42] = "Caching home agent 42",
    [CBOX43] = "Caching home agent 43",
    [CBOX44] = "Caching home agent 44",
    [CBOX45] = "Caching home agent 45",
    [CBOX46] = "Caching home agent 46",
    [CBOX47] = "Caching home agent 47",
    [CBOX48] = "Caching home agent 48",
    [CBOX49] = "Caching home agent 49",
    [CBOX50] = "Caching home agent 50",
    [CBOX51] = "Caching home agent 51",
    [CBOX52] = "Caching home agent 52",
    [CBOX53] = "Caching home agent 53",
    [CBOX54] = "Caching home agent 54",
    [CBOX55] = "Caching home agent 55",
    [CBOX56] = "Caching home agent 56",
    [CBOX57] = "Caching home agent 57",
    [CBOX58] = "Caching home agent 58",
    [CBOX59] = "Caching home agent 59",
    [MBOX0] = "Memory Controller Unit 0",
    [MBOX1] = "Memory Controller Unit 1",
    [MBOX2] = "Memory Controller Unit 2",
    [MBOX3] = "Memory Controller Unit 3",
    [MBOX4] = "Memory Controller Unit 4",
    [MBOX5] = "Memory Controller Unit 5",
    [MBOX6] = "Memory Controller Unit 6",
    [MBOX7] = "Memory Controller Unit 7",
    [MBOX8] = "Memory Controller Unit 8",
    [MBOX9] = "Memory Controller Unit 9",
    [MBOX10] = "Memory Controller Unit 10",
    [MBOX11] = "Memory Controller Unit 11",
    [PBOX0] = "Interface between mesh and IIO stacks 0",
    [PBOX1] = "Interface between mesh and IIO stacks 1",
    [PBOX2] = "Interface between mesh and IIO stacks 2",
    [PBOX3] = "Interface between mesh and IIO stacks 3",
    [PBOX4] = "Interface between mesh and IIO stacks 4",
    [PBOX5] = "Interface between mesh and IIO stacks 5",
    [PBOX6] = "Interface between mesh and IIO stacks 6",
    [PBOX7] = "Interface between mesh and IIO stacks 7",
    [PBOX8] = "Interface between mesh and IIO stacks 8",
    [PBOX9] = "Interface between mesh and IIO stacks 9",
    [PBOX10] = "Interface between mesh and IIO stacks 10",
    [PBOX11] = "Interface between mesh and IIO stacks 11",
    [WBOX0] = "Power Control Unit 0",
    [QBOX0] = "UPI interconnect unit 0",
    [QBOX1] = "UPI interconnect unit 1",
    [QBOX2] = "UPI interconnect unit 2",
    [QBOX3] = "UPI interconnect unit 3",
    [MDF0] = "Embedded Multi-die Interconnect Bridge Interface 0",
    [MDF1] = "Embedded Multi-die Interconnect Bridge Interface 1",
    [MDF2] = "Embedded Multi-die Interconnect Bridge Interface 2",
    [MDF3] = "Embedded Multi-die Interconnect Bridge Interface 3",
    [MDF4] = "Embedded Multi-die Interconnect Bridge Interface 4",
    [MDF5] = "Embedded Multi-die Interconnect Bridge Interface 5",
    [MDF6] = "Embedded Multi-die Interconnect Bridge Interface 6",
    [MDF7] = "Embedded Multi-die Interconnect Bridge Interface 7",
    [MDF8] = "Embedded Multi-die Interconnect Bridge Interface 8",
    [MDF9] = "Embedded Multi-die Interconnect Bridge Interface 9",
    [MDF10] = "Embedded Multi-die Interconnect Bridge Interface 10",
    [MDF11] = "Embedded Multi-die Interconnect Bridge Interface 11",
    [MDF12] = "Embedded Multi-die Interconnect Bridge Interface 12",
    [MDF13] = "Embedded Multi-die Interconnect Bridge Interface 13",
    [MDF14] = "Embedded Multi-die Interconnect Bridge Interface 14",
    [MDF15] = "Embedded Multi-die Interconnect Bridge Interface 15",
    [MDF16] = "Embedded Multi-die Interconnect Bridge Interface 16",
    [MDF17] = "Embedded Multi-die Interconnect Bridge Interface 17",
    [MDF18] = "Embedded Multi-die Interconnect Bridge Interface 18",
    [MDF19] = "Embedded Multi-die Interconnect Bridge Interface 19",
    [MDF20] = "Embedded Multi-die Interconnect Bridge Interface 20",
    [MDF21] = "Embedded Multi-die Interconnect Bridge Interface 21",
    [MDF22] = "Embedded Multi-die Interconnect Bridge Interface 22",
    [MDF23] = "Embedded Multi-die Interconnect Bridge Interface 23",
    [MDF24] = "Embedded Multi-die Interconnect Bridge Interface 24",
    [MDF25] = "Embedded Multi-die Interconnect Bridge Interface 25",
    [MDF26] = "Embedded Multi-die Interconnect Bridge Interface 26",
    [MDF27] = "Embedded Multi-die Interconnect Bridge Interface 27",
    [MDF28] = "Embedded Multi-die Interconnect Bridge Interface 28",
    [MDF29] = "Embedded Multi-die Interconnect Bridge Interface 29",
    [MDF30] = "Embedded Multi-die Interconnect Bridge Interface 30",
    [MDF31] = "Embedded Multi-die Interconnect Bridge Interface 31",
    [MDF32] = "Embedded Multi-die Interconnect Bridge Interface 32",
    [MDF33] = "Embedded Multi-die Interconnect Bridge Interface 33",
    [MDF34] = "Embedded Multi-die Interconnect Bridge Interface 34",
    [MDF35] = "Embedded Multi-die Interconnect Bridge Interface 35",
    [MDF36] = "Embedded Multi-die Interconnect Bridge Interface 36",
    [MDF37] = "Embedded Multi-die Interconnect Bridge Interface 37",
    [MDF38] = "Embedded Multi-die Interconnect Bridge Interface 38",
    [MDF39] = "Embedded Multi-die Interconnect Bridge Interface 39",
    [BBOX0] = "Mesh to memory controller interface 0",
    [BBOX1] = "Mesh to memory controller interface 1",
    [BBOX2] = "Mesh to memory controller interface 2",
    [BBOX3] = "Mesh to memory controller interface 3",
    [BBOX4] = "Mesh to memory controller interface 4",
    [BBOX5] = "Mesh to memory controller interface 5",
    [BBOX6] = "Mesh to memory controller interface 6",
    [BBOX7] = "Mesh to memory controller interface 7",
    [BBOX8] = "Mesh to memory controller interface 8",
    [BBOX9] = "Mesh to memory controller interface 9",
    [BBOX10] = "Mesh to memory controller interface 10",
    [BBOX11] = "Mesh to memory controller interface 11",
    [BBOX12] = "Mesh to memory controller interface 12",
    [BBOX13] = "Mesh to memory controller interface 13",
    [BBOX14] = "Mesh to memory controller interface 14",
    [BBOX15] = "Mesh to memory controller interface 15",
    [BBOX16] = "Mesh to memory controller interface 16",
    [BBOX17] = "Mesh to memory controller interface 17",
    [BBOX18] = "Mesh to memory controller interface 18",
    [BBOX19] = "Mesh to memory controller interface 19",
    [BBOX20] = "Mesh to memory controller interface 20",
    [BBOX21] = "Mesh to memory controller interface 21",
    [BBOX22] = "Mesh to memory controller interface 22",
    [BBOX23] = "Mesh to memory controller interface 23",
    [BBOX24] = "Mesh to memory controller interface 24",
    [BBOX25] = "Mesh to memory controller interface 25",
    [BBOX26] = "Mesh to memory controller interface 26",
    [BBOX27] = "Mesh to memory controller interface 27",
    [BBOX28] = "Mesh to memory controller interface 28",
    [BBOX29] = "Mesh to memory controller interface 29",
    [BBOX30] = "Mesh to memory controller interface 30",
    [BBOX31] = "Mesh to memory controller interface 31",
    [IRP0] = "IIO Ring Port 0",
    [IRP1] = "IIO Ring Port 1",
    [IRP2] = "IIO Ring Port 2",
    [IRP3] = "IIO Ring Port 3",
    [IRP4] = "IIO Ring Port 4",
    [IRP5] = "IIO Ring Port 5",
    [IRP6] = "IIO Ring Port 6",
    [IRP7] = "IIO Ring Port 7",
    [IRP8] = "IIO Ring Port 8",
    [IRP9] = "IIO Ring Port 9",
    [IRP10] = "IIO Ring Port 10",
    [IRP11] = "IIO Ring Port 11",
    [IBOX0] = "IIO stack 0",
    [IBOX1] = "IIO stack 1",
    [IBOX2] = "IIO stack 2",
    [IBOX3] = "IIO stack 3",
    [IBOX4] = "IIO stack 4",
    [IBOX5] = "IIO stack 5",
    [IBOX6] = "IIO stack 6",
    [IBOX7] = "IIO stack 7",
    [IBOX8] = "IIO stack 8",
    [IBOX9] = "IIO stack 9",
    [IBOX10] = "IIO stack 10",
    [IBOX11] = "IIO stack 11",
    [HBM0] = "High bandwidth memory interface 0",
    [HBM1] = "High bandwidth memory interface 1",
    [HBM2] = "High bandwidth memory interface 2",
    [HBM3] = "High bandwidth memory interface 3",
    [HBM4] = "High bandwidth memory interface 4",
    [HBM5] = "High bandwidth memory interface 5",
    [HBM6] = "High bandwidth memory interface 6",
    [HBM7] = "High bandwidth memory interface 7",
    [HBM8] = "High bandwidth memory interface 8",
    [HBM9] = "High bandwidth memory interface 9",
    [HBM10] = "High bandwidth memory interface 10",
    [HBM11] = "High bandwidth memory interface 11",
    [HBM12] = "High bandwidth memory interface 12",
    [HBM13] = "High bandwidth memory interface 13",
    [HBM14] = "High bandwidth memory interface 14",
    [HBM15] = "High bandwidth memory interface 15",
    [RBOX0] = "Mesh to UPI interface 0",
    [RBOX1] = "Mesh to UPI interface 1",
    [RBOX2] = "Mesh to UPI interface 2",
    [RBOX3] = "Mesh to UPI interface 3",


};

#define     SPR_DEVICE_ID_CHA 0
#define     SPR_DEVICE_ID_IIO 1
#define     SPR_DEVICE_ID_IRP 2
#define     SPR_DEVICE_ID_M2PCIe 3
#define     SPR_DEVICE_ID_PCU 4
#define     SPR_DEVICE_ID_iMC 6
#define     SPR_DEVICE_ID_M2M 7
#define     SPR_DEVICE_ID_UPI 8
#define     SPR_DEVICE_ID_M3UPI 9
#define     SPR_DEVICE_ID_MDF 11
#define     SPR_DEVICE_ID_HBM 14

static PerfmonUncoreDiscovery sapphirerapids_uncore_discovery_map[] = {
    {"CBOX", SPR_DEVICE_ID_CHA, 60, MSR_CBOX_DEVICE_C0},
    {"MBOX", SPR_DEVICE_ID_iMC, 12, MMIO_IMC_DEVICE_0_CH_0},
    {"PBOX", SPR_DEVICE_ID_M2PCIe, 16, PCI_R2PCIE_DEVICE0},
    {"WBOX", SPR_DEVICE_ID_PCU, 1, MSR_PCU_DEVICE},
    {"IRP", SPR_DEVICE_ID_IRP, 12, MSR_IRP_DEVICE_0},
    {"IIO", SPR_DEVICE_ID_IIO, 12, MSR_IIO_DEVICE_0},
    {"QBOX", SPR_DEVICE_ID_UPI, 4, PCI_QPI_DEVICE_PORT_0},
    {"MDF", SPR_DEVICE_ID_MDF, 40, MSR_MDF_DEVICE_0},
    {"M2M", SPR_DEVICE_ID_M2M, 32, PCI_HA_DEVICE_0},
    {"RBOX", SPR_DEVICE_ID_M3UPI, 4, PCI_R3QPI_DEVICE_LINK_0},
    {"HBM", SPR_DEVICE_ID_HBM, 32, MMIO_HBM_DEVICE_0},
    {"INVALID", -1, 0, MSR_DEV}
};

#endif //PERFMON_SAPPHIRERAPIDS_COUNTERS_H
