package org.checkerframework.checker.nonempty.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.checkerframework.framework.qual.PolymorphicQualifier;

/**
 * A polymorphic qualifier for the Non-Empty type system.
 *
 * @checker_framework.manual #qualifier-polymorphism Qualifier polymorphism
 */
// Reinstate when the Non-Empty Checker is publicized.
//  * @checker_framework.manual #non-empty-checker Non-Empty Checker
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@PolymorphicQualifier(UnknownNonEmpty.class)
public @interface PolyNonEmpty {}
