/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.util;

import java.util.Comparator;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Group;

public class CatalogItemComparator
implements Comparator<CatalogItem> {
    private int computeGroupIndex(CatalogCategory category, String groupId) {
        if (groupId != null) {
            int index = -1;
            for (Group group : category.getGroup()) {
                ++index;
                if (!group.getId().equals(groupId)) continue;
                return index;
            }
        }
        return -1;
    }

    @Override
    public int compare(CatalogItem o1, CatalogItem o2) {
        int i;
        int g2;
        if (o1.getCategory() != o2.getCategory()) {
            throw new IllegalArgumentException();
        }
        if (o1 == o2) {
            return 0;
        }
        int g1 = this.computeGroupIndex(o1.getCategory(), o1.getGroupId());
        if (g1 != (g2 = this.computeGroupIndex(o2.getCategory(), o2.getGroupId()))) {
            i = g1 == -1 ? 1 : (g2 == -1 ? -1 : g1 - g2);
        } else {
            i = o1.getName().compareToIgnoreCase(o2.getName());
            if (i == 0) {
                i = o1.getId().compareTo(o2.getId());
            }
        }
        return i;
    }
}

