//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfusernotification?language=objc)
#[doc(alias = "CFUserNotificationRef")]
#[repr(C)]
pub struct CFUserNotification {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFUserNotification {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFUserNotification"> for CFUserNotification {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfusernotificationcallback?language=objc)
pub type CFUserNotificationCallBack =
    Option<unsafe extern "C-unwind" fn(*mut CFUserNotification, CFOptionFlags)>;

unsafe impl ConcreteType for CFUserNotification {
    #[doc(alias = "CFUserNotificationGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFUserNotificationGetTypeID() -> CFTypeID;
        }
        unsafe { CFUserNotificationGetTypeID() }
    }
}

impl CFUserNotification {
    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `error` must be a valid pointer.
    /// - `dictionary` generics must be of the correct type.
    /// - `dictionary` might not allow `None`.
    #[doc(alias = "CFUserNotificationCreate")]
    #[cfg(all(feature = "CFDate", feature = "CFDictionary"))]
    #[inline]
    pub unsafe fn new(
        allocator: Option<&CFAllocator>,
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        error: *mut i32,
        dictionary: Option<&CFDictionary>,
    ) -> Option<CFRetained<CFUserNotification>> {
        extern "C-unwind" {
            fn CFUserNotificationCreate(
                allocator: Option<&CFAllocator>,
                timeout: CFTimeInterval,
                flags: CFOptionFlags,
                error: *mut i32,
                dictionary: Option<&CFDictionary>,
            ) -> Option<NonNull<CFUserNotification>>;
        }
        let ret = unsafe { CFUserNotificationCreate(allocator, timeout, flags, error, dictionary) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `response_flags` must be a valid pointer.
    #[doc(alias = "CFUserNotificationReceiveResponse")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub unsafe fn receive_response(
        &self,
        timeout: CFTimeInterval,
        response_flags: *mut CFOptionFlags,
    ) -> i32 {
        extern "C-unwind" {
            fn CFUserNotificationReceiveResponse(
                user_notification: &CFUserNotification,
                timeout: CFTimeInterval,
                response_flags: *mut CFOptionFlags,
            ) -> i32;
        }
        unsafe { CFUserNotificationReceiveResponse(self, timeout, response_flags) }
    }

    /// # Safety
    ///
    /// `key` might not allow `None`.
    #[doc(alias = "CFUserNotificationGetResponseValue")]
    #[inline]
    pub unsafe fn response_value(
        &self,
        key: Option<&CFString>,
        idx: CFIndex,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFUserNotificationGetResponseValue(
                user_notification: &CFUserNotification,
                key: Option<&CFString>,
                idx: CFIndex,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFUserNotificationGetResponseValue(self, key, idx) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFUserNotificationGetResponseDictionary")]
    #[cfg(feature = "CFDictionary")]
    #[inline]
    pub fn response_dictionary(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CFUserNotificationGetResponseDictionary(
                user_notification: &CFUserNotification,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CFUserNotificationGetResponseDictionary(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// # Safety
    ///
    /// - `dictionary` generics must be of the correct type.
    /// - `dictionary` might not allow `None`.
    #[doc(alias = "CFUserNotificationUpdate")]
    #[cfg(all(feature = "CFDate", feature = "CFDictionary"))]
    #[inline]
    pub unsafe fn update(
        &self,
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        dictionary: Option<&CFDictionary>,
    ) -> i32 {
        extern "C-unwind" {
            fn CFUserNotificationUpdate(
                user_notification: &CFUserNotification,
                timeout: CFTimeInterval,
                flags: CFOptionFlags,
                dictionary: Option<&CFDictionary>,
            ) -> i32;
        }
        unsafe { CFUserNotificationUpdate(self, timeout, flags, dictionary) }
    }

    #[doc(alias = "CFUserNotificationCancel")]
    #[inline]
    pub fn cancel(&self) -> i32 {
        extern "C-unwind" {
            fn CFUserNotificationCancel(user_notification: &CFUserNotification) -> i32;
        }
        unsafe { CFUserNotificationCancel(self) }
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `user_notification` might not allow `None`.
    /// - `callout` must be implemented correctly.
    #[doc(alias = "CFUserNotificationCreateRunLoopSource")]
    #[cfg(feature = "CFRunLoop")]
    #[inline]
    pub unsafe fn new_run_loop_source(
        allocator: Option<&CFAllocator>,
        user_notification: Option<&CFUserNotification>,
        callout: CFUserNotificationCallBack,
        order: CFIndex,
    ) -> Option<CFRetained<CFRunLoopSource>> {
        extern "C-unwind" {
            fn CFUserNotificationCreateRunLoopSource(
                allocator: Option<&CFAllocator>,
                user_notification: Option<&CFUserNotification>,
                callout: CFUserNotificationCallBack,
                order: CFIndex,
            ) -> Option<NonNull<CFRunLoopSource>>;
        }
        let ret = unsafe {
            CFUserNotificationCreateRunLoopSource(allocator, user_notification, callout, order)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFUserNotificationDisplayNotice")]
    #[cfg(all(feature = "CFDate", feature = "CFURL"))]
    #[inline]
    pub fn display_notice(
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        icon_url: Option<&CFURL>,
        sound_url: Option<&CFURL>,
        localization_url: Option<&CFURL>,
        alert_header: Option<&CFString>,
        alert_message: Option<&CFString>,
        default_button_title: Option<&CFString>,
    ) -> i32 {
        extern "C-unwind" {
            fn CFUserNotificationDisplayNotice(
                timeout: CFTimeInterval,
                flags: CFOptionFlags,
                icon_url: Option<&CFURL>,
                sound_url: Option<&CFURL>,
                localization_url: Option<&CFURL>,
                alert_header: Option<&CFString>,
                alert_message: Option<&CFString>,
                default_button_title: Option<&CFString>,
            ) -> i32;
        }
        unsafe {
            CFUserNotificationDisplayNotice(
                timeout,
                flags,
                icon_url,
                sound_url,
                localization_url,
                alert_header,
                alert_message,
                default_button_title,
            )
        }
    }

    /// # Safety
    ///
    /// - `icon_url` might not allow `None`.
    /// - `sound_url` might not allow `None`.
    /// - `localization_url` might not allow `None`.
    /// - `alert_header` might not allow `None`.
    /// - `alert_message` might not allow `None`.
    /// - `default_button_title` might not allow `None`.
    /// - `alternate_button_title` might not allow `None`.
    /// - `other_button_title` might not allow `None`.
    /// - `response_flags` must be a valid pointer.
    #[doc(alias = "CFUserNotificationDisplayAlert")]
    #[cfg(all(feature = "CFDate", feature = "CFURL"))]
    #[inline]
    pub unsafe fn display_alert(
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        icon_url: Option<&CFURL>,
        sound_url: Option<&CFURL>,
        localization_url: Option<&CFURL>,
        alert_header: Option<&CFString>,
        alert_message: Option<&CFString>,
        default_button_title: Option<&CFString>,
        alternate_button_title: Option<&CFString>,
        other_button_title: Option<&CFString>,
        response_flags: *mut CFOptionFlags,
    ) -> i32 {
        extern "C-unwind" {
            fn CFUserNotificationDisplayAlert(
                timeout: CFTimeInterval,
                flags: CFOptionFlags,
                icon_url: Option<&CFURL>,
                sound_url: Option<&CFURL>,
                localization_url: Option<&CFURL>,
                alert_header: Option<&CFString>,
                alert_message: Option<&CFString>,
                default_button_title: Option<&CFString>,
                alternate_button_title: Option<&CFString>,
                other_button_title: Option<&CFString>,
                response_flags: *mut CFOptionFlags,
            ) -> i32;
        }
        unsafe {
            CFUserNotificationDisplayAlert(
                timeout,
                flags,
                icon_url,
                sound_url,
                localization_url,
                alert_header,
                alert_message,
                default_button_title,
                alternate_button_title,
                other_button_title,
                response_flags,
            )
        }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationstopalertlevel?language=objc)
pub const kCFUserNotificationStopAlertLevel: CFOptionFlags = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationnotealertlevel?language=objc)
pub const kCFUserNotificationNoteAlertLevel: CFOptionFlags = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationcautionalertlevel?language=objc)
pub const kCFUserNotificationCautionAlertLevel: CFOptionFlags = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationplainalertlevel?language=objc)
pub const kCFUserNotificationPlainAlertLevel: CFOptionFlags = 3;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationdefaultresponse?language=objc)
pub const kCFUserNotificationDefaultResponse: CFOptionFlags = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalternateresponse?language=objc)
pub const kCFUserNotificationAlternateResponse: CFOptionFlags = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationotherresponse?language=objc)
pub const kCFUserNotificationOtherResponse: CFOptionFlags = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationcancelresponse?language=objc)
pub const kCFUserNotificationCancelResponse: CFOptionFlags = 3;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationnodefaultbuttonflag?language=objc)
pub const kCFUserNotificationNoDefaultButtonFlag: CFOptionFlags = 1 << 5;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationuseradiobuttonsflag?language=objc)
pub const kCFUserNotificationUseRadioButtonsFlag: CFOptionFlags = 1 << 6;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationiconurlkey?language=objc)
    pub static kCFUserNotificationIconURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationsoundurlkey?language=objc)
    pub static kCFUserNotificationSoundURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationlocalizationurlkey?language=objc)
    pub static kCFUserNotificationLocalizationURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalertheaderkey?language=objc)
    pub static kCFUserNotificationAlertHeaderKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalertmessagekey?language=objc)
    pub static kCFUserNotificationAlertMessageKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationdefaultbuttontitlekey?language=objc)
    pub static kCFUserNotificationDefaultButtonTitleKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalternatebuttontitlekey?language=objc)
    pub static kCFUserNotificationAlternateButtonTitleKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationotherbuttontitlekey?language=objc)
    pub static kCFUserNotificationOtherButtonTitleKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationprogressindicatorvaluekey?language=objc)
    pub static kCFUserNotificationProgressIndicatorValueKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationpopuptitleskey?language=objc)
    pub static kCFUserNotificationPopUpTitlesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationtextfieldtitleskey?language=objc)
    pub static kCFUserNotificationTextFieldTitlesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationcheckboxtitleskey?language=objc)
    pub static kCFUserNotificationCheckBoxTitlesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationtextfieldvalueskey?language=objc)
    pub static kCFUserNotificationTextFieldValuesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationpopupselectionkey?language=objc)
    pub static kCFUserNotificationPopUpSelectionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationalerttopmostkey?language=objc)
    pub static kCFUserNotificationAlertTopMostKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfusernotificationkeyboardtypeskey?language=objc)
    pub static kCFUserNotificationKeyboardTypesKey: Option<&'static CFString>;
}

#[cfg(all(feature = "CFDate", feature = "CFDictionary"))]
#[deprecated = "renamed to `CFUserNotification::new`"]
#[inline]
pub unsafe extern "C-unwind" fn CFUserNotificationCreate(
    allocator: Option<&CFAllocator>,
    timeout: CFTimeInterval,
    flags: CFOptionFlags,
    error: *mut i32,
    dictionary: Option<&CFDictionary>,
) -> Option<CFRetained<CFUserNotification>> {
    extern "C-unwind" {
        fn CFUserNotificationCreate(
            allocator: Option<&CFAllocator>,
            timeout: CFTimeInterval,
            flags: CFOptionFlags,
            error: *mut i32,
            dictionary: Option<&CFDictionary>,
        ) -> Option<NonNull<CFUserNotification>>;
    }
    let ret = unsafe { CFUserNotificationCreate(allocator, timeout, flags, error, dictionary) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFDate")]
    #[deprecated = "renamed to `CFUserNotification::receive_response`"]
    pub fn CFUserNotificationReceiveResponse(
        user_notification: &CFUserNotification,
        timeout: CFTimeInterval,
        response_flags: *mut CFOptionFlags,
    ) -> i32;
}

#[deprecated = "renamed to `CFUserNotification::response_value`"]
#[inline]
pub unsafe extern "C-unwind" fn CFUserNotificationGetResponseValue(
    user_notification: &CFUserNotification,
    key: Option<&CFString>,
    idx: CFIndex,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFUserNotificationGetResponseValue(
            user_notification: &CFUserNotification,
            key: Option<&CFString>,
            idx: CFIndex,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFUserNotificationGetResponseValue(user_notification, key, idx) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFDictionary")]
#[deprecated = "renamed to `CFUserNotification::response_dictionary`"]
#[inline]
pub extern "C-unwind" fn CFUserNotificationGetResponseDictionary(
    user_notification: &CFUserNotification,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFUserNotificationGetResponseDictionary(
            user_notification: &CFUserNotification,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFUserNotificationGetResponseDictionary(user_notification) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

extern "C-unwind" {
    #[cfg(all(feature = "CFDate", feature = "CFDictionary"))]
    #[deprecated = "renamed to `CFUserNotification::update`"]
    pub fn CFUserNotificationUpdate(
        user_notification: &CFUserNotification,
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        dictionary: Option<&CFDictionary>,
    ) -> i32;
}

#[deprecated = "renamed to `CFUserNotification::cancel`"]
#[inline]
pub extern "C-unwind" fn CFUserNotificationCancel(user_notification: &CFUserNotification) -> i32 {
    extern "C-unwind" {
        fn CFUserNotificationCancel(user_notification: &CFUserNotification) -> i32;
    }
    unsafe { CFUserNotificationCancel(user_notification) }
}

#[cfg(feature = "CFRunLoop")]
#[deprecated = "renamed to `CFUserNotification::new_run_loop_source`"]
#[inline]
pub unsafe extern "C-unwind" fn CFUserNotificationCreateRunLoopSource(
    allocator: Option<&CFAllocator>,
    user_notification: Option<&CFUserNotification>,
    callout: CFUserNotificationCallBack,
    order: CFIndex,
) -> Option<CFRetained<CFRunLoopSource>> {
    extern "C-unwind" {
        fn CFUserNotificationCreateRunLoopSource(
            allocator: Option<&CFAllocator>,
            user_notification: Option<&CFUserNotification>,
            callout: CFUserNotificationCallBack,
            order: CFIndex,
        ) -> Option<NonNull<CFRunLoopSource>>;
    }
    let ret = unsafe {
        CFUserNotificationCreateRunLoopSource(allocator, user_notification, callout, order)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFDate", feature = "CFURL"))]
#[deprecated = "renamed to `CFUserNotification::display_notice`"]
#[inline]
pub extern "C-unwind" fn CFUserNotificationDisplayNotice(
    timeout: CFTimeInterval,
    flags: CFOptionFlags,
    icon_url: Option<&CFURL>,
    sound_url: Option<&CFURL>,
    localization_url: Option<&CFURL>,
    alert_header: Option<&CFString>,
    alert_message: Option<&CFString>,
    default_button_title: Option<&CFString>,
) -> i32 {
    extern "C-unwind" {
        fn CFUserNotificationDisplayNotice(
            timeout: CFTimeInterval,
            flags: CFOptionFlags,
            icon_url: Option<&CFURL>,
            sound_url: Option<&CFURL>,
            localization_url: Option<&CFURL>,
            alert_header: Option<&CFString>,
            alert_message: Option<&CFString>,
            default_button_title: Option<&CFString>,
        ) -> i32;
    }
    unsafe {
        CFUserNotificationDisplayNotice(
            timeout,
            flags,
            icon_url,
            sound_url,
            localization_url,
            alert_header,
            alert_message,
            default_button_title,
        )
    }
}

extern "C-unwind" {
    #[cfg(all(feature = "CFDate", feature = "CFURL"))]
    #[deprecated = "renamed to `CFUserNotification::display_alert`"]
    pub fn CFUserNotificationDisplayAlert(
        timeout: CFTimeInterval,
        flags: CFOptionFlags,
        icon_url: Option<&CFURL>,
        sound_url: Option<&CFURL>,
        localization_url: Option<&CFURL>,
        alert_header: Option<&CFString>,
        alert_message: Option<&CFString>,
        default_button_title: Option<&CFString>,
        alternate_button_title: Option<&CFString>,
        other_button_title: Option<&CFString>,
        response_flags: *mut CFOptionFlags,
    ) -> i32;
}
