/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    static final int MIN_ARROW_WIDTH = 6;
    int lastEventTime = 0;
    long imContext;
    long gdkEventKey = 0L;
    long entryHandle;
    int fixStart = -1;
    int fixEnd = -1;
    double climbRate = 1.0;
    public static final int LIMIT = 65535;
    GdkRGBA background;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        GTK.gtk_widget_realize(this.handle);
        long layout = GTK.gtk_entry_get_layout(GTK.GTK4 ? this.entryHandle : this.handle);
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        double upper = GTK.gtk_adjustment_get_upper(hAdjustment);
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < digits; ++i) {
            upper *= 10.0;
        }
        String string = String.valueOf((int)upper);
        if (digits > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(string);
            buffer.append(this.getDecimalSeparator());
            for (int count = digits - string.length(); count >= 0; --count) {
                buffer.append("0");
            }
            string = buffer.toString();
        }
        byte[] buffer1 = Converter.wcsToMbcs(string, false);
        long ptr = OS.pango_layout_get_text(layout);
        int length = C.strlen(ptr);
        byte[] buffer2 = new byte[length];
        C.memmove(buffer2, ptr, (long)length);
        OS.pango_layout_set_text(layout, buffer1, buffer1.length);
        int height = 0;
        GTK.gtk_widget_realize(this.handle);
        GTK.gtk_widget_set_size_request(this.handle, wHint, hHint);
        GtkRequisition requisition = new GtkRequisition();
        GTK.gtk_widget_get_preferred_size(this.handle, requisition, null);
        int width = wHint == -1 ? requisition.width : Math.max(wHint, requisition.width);
        height = hHint == -1 ? requisition.height : hHint;
        OS.pango_layout_set_text(layout, buffer2, buffer2.length);
        Rectangle trim = this.computeTrimInPixels(0, 0, width, height);
        return new Point(trim.width, trim.height);
    }

    @Override
    Rectangle computeTrimInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        int xborder = 0;
        int yborder = 0;
        Rectangle trim = super.computeTrimInPixels(x, y, width, height);
        GtkBorder tmp = new GtkBorder();
        long context = GTK.gtk_widget_get_style_context(this.handle);
        int state_flag = GTK.gtk_widget_get_state_flags(this.handle);
        this.gtk_style_context_get_padding(context, state_flag, tmp);
        if ((this.style & 0x800) != 0) {
            int state = GTK.gtk_widget_get_state_flags(this.handle);
            this.gtk_style_context_get_border(context, state, tmp);
            trim.x -= tmp.left;
            trim.y -= tmp.top;
            trim.width += tmp.left + tmp.right;
            trim.height += tmp.top + tmp.bottom;
        }
        if (!GTK.GTK4) {
            int[] property = new int[1];
            GTK.gtk_widget_style_get(this.handle, OS.interior_focus, property, 0L);
            if (property[0] == 0) {
                GTK.gtk_widget_style_get(this.handle, OS.focus_line_width, property, 0L);
                xborder += property[0];
                yborder += property[0];
            }
        }
        trim.x -= xborder;
        trim.y -= yborder;
        trim.width += 2 * xborder;
        trim.height += 2 * yborder;
        return new Rectangle(trim.x, trim.y, trim.width, trim.height);
    }

    public void copy() {
        this.checkWidget();
        GTK.gtk_editable_copy_clipboard(GTK.GTK4 ? this.entryHandle : this.handle);
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        this.gtk_widget_set_has_surface_or_window(this.fixedHandle, true);
        long adjustment = GTK.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 0.0);
        if (adjustment == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_spin_button_new(adjustment, this.climbRate, 0);
        if (this.handle == 0L) {
            this.error(2);
        }
        GTK.gtk_container_add(this.fixedHandle, this.handle);
        if (GTK.GTK4) {
            long textHandle;
            long boxHandle = GTK.gtk_widget_get_first_child(this.handle);
            this.entryHandle = textHandle = GTK.gtk_widget_get_first_child(boxHandle);
        }
        GTK.gtk_editable_set_editable(GTK.GTK4 ? this.entryHandle : this.handle, (this.style & 8) == 0);
        GTK.gtk_spin_button_set_wrap(this.handle, (this.style & 0x40) != 0);
        this.imContext = OS.imContextLast();
        this.setFontDescription(this.defaultFont().handle);
    }

    public void cut() {
        this.checkWidget();
        GTK.gtk_editable_cut_clipboard(GTK.GTK4 ? this.entryHandle : this.handle);
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        long imContext = this.imContext();
        if (imContext != 0L) {
            this.display.removeWidget(imContext);
        }
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    @Override
    long eventSurface() {
        return this.paintSurface();
    }

    @Override
    long enterExitHandle() {
        return this.fixedHandle;
    }

    @Override
    boolean filterKey(int keyval, long event) {
        int time = GDK.gdk_event_get_time(event);
        if (time != this.lastEventTime) {
            this.lastEventTime = time;
            long imContext = this.imContext();
            if (imContext != 0L) {
                return GTK.gtk_im_context_filter_keypress(imContext, event);
            }
        }
        this.gdkEventKey = event;
        return false;
    }

    void fixIM() {
        long imContext;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (imContext = this.imContext()) != 0L) {
            GTK.gtk_im_context_filter_keypress(imContext, this.gdkEventKey);
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    @Override
    int getBorderWidthInPixels() {
        this.checkWidget();
        if ((this.style & 0x800) != 0) {
            return this.getThickness((long)this.handle).x;
        }
        return 0;
    }

    public int getIncrement() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        double value = GTK.gtk_adjustment_get_step_increment(hAdjustment);
        for (int i = 0; i < digits; ++i) {
            value *= 10.0;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public int getMaximum() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        double value = GTK.gtk_adjustment_get_upper(hAdjustment);
        for (int i = 0; i < digits; ++i) {
            value *= 10.0;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public int getMinimum() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        double value = GTK.gtk_adjustment_get_lower(hAdjustment);
        for (int i = 0; i < digits; ++i) {
            value *= 10.0;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public int getPageIncrement() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        double value = GTK.gtk_adjustment_get_page_increment(hAdjustment);
        for (int i = 0; i < digits; ++i) {
            value *= 10.0;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public int getSelection() {
        this.checkWidget();
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        double value = GTK.gtk_adjustment_get_value(hAdjustment);
        for (int i = 0; i < digits; ++i) {
            value *= 10.0;
        }
        return (int)(value > 0.0 ? value + 0.5 : value - 0.5);
    }

    public String getText() {
        this.checkWidget();
        long str = GTK.gtk_entry_get_text(GTK.GTK4 ? this.entryHandle : this.handle);
        if (str == 0L) {
            return "";
        }
        int length = C.strlen(str);
        byte[] buffer = new byte[length];
        C.memmove(buffer, str, (long)length);
        return new String(Converter.mbcsToWcs(buffer));
    }

    public int getTextLimit() {
        this.checkWidget();
        int limit = GTK.gtk_entry_get_max_length(GTK.GTK4 ? this.entryHandle : this.handle);
        return limit == 0 ? LIMIT : limit;
    }

    public int getDigits() {
        this.checkWidget();
        return GTK.gtk_spin_button_get_digits(this.handle);
    }

    String getDecimalSeparator() {
        long ptr = OS.localeconv_decimal_point();
        int length = C.strlen(ptr);
        byte[] buffer = new byte[length];
        C.memmove(buffer, ptr, (long)length);
        return new String(Converter.mbcsToWcs(buffer));
    }

    @Override
    long gtk_activate(long widget) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_changed(long widget) {
        long str = GTK.gtk_entry_get_text(GTK.GTK4 ? this.entryHandle : this.handle);
        int length = C.strlen(str);
        if (length > 0) {
            int valueLength;
            long[] endptr = new long[1];
            double value = OS.g_strtod(str, endptr);
            int n = valueLength = this.getDigits() == 0 ? String.valueOf((int)value).length() : String.valueOf(value).length();
            if (endptr[0] == str + (long)length && valueLength == length) {
                long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
                GtkAdjustment adjustment = new GtkAdjustment();
                this.gtk_adjustment_get(hAdjustment, adjustment);
                if (value != adjustment.value && adjustment.lower <= value && value <= adjustment.upper) {
                    GTK.gtk_spin_button_update(this.handle);
                }
            }
        }
        boolean keyPress = false;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            int eventType = GDK.gdk_event_get_event_type(eventPtr);
            eventType = Spinner.fixGdkEventTypeValues(eventType);
            switch (eventType) {
                case 8: {
                    keyPress = true;
                }
            }
            this.gdk_event_free(eventPtr);
        }
        if (keyPress) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long imContext, long text) {
        if (text == 0L) {
            return 0L;
        }
        if (!GTK.gtk_editable_get_editable(GTK.GTK4 ? this.entryHandle : this.handle)) {
            return 0L;
        }
        int length = C.strlen(text);
        if (length == 0) {
            return 0L;
        }
        byte[] buffer = new byte[length];
        C.memmove(buffer, text, (long)length);
        char[] chars = Converter.mbcsToWcs(buffer);
        char[] newChars = this.sendIMKeyEvent(1, 0L, chars);
        if (newChars == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        int id = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int mask = 17;
        OS.g_signal_handlers_unblock_matched(imContext, mask, id, 0, 0L, 0L, this.handle);
        if (newChars == chars) {
            OS.g_signal_emit_by_name(imContext, OS.commit, text);
        } else {
            buffer = Converter.wcsToMbcs(newChars, true);
            OS.g_signal_emit_by_name(imContext, OS.commit, buffer);
        }
        OS.g_signal_handlers_unblock_matched(imContext, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0L, 0L, this.handle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position(GTK.GTK4 ? this.entryHandle : this.handle, this.fixStart);
            GTK.gtk_editable_select_region(GTK.GTK4 ? this.entryHandle : this.handle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    @Override
    long gtk_delete_text(long widget, long start_pos, long end_pos) {
        int end;
        int start;
        String newText;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        long ptr = GTK.gtk_entry_get_text(GTK.GTK4 ? this.entryHandle : this.handle);
        if (end_pos == -1L) {
            end_pos = OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText("", start = (int)OS.g_utf8_offset_to_utf16_offset(ptr, start_pos), end = (int)OS.g_utf8_offset_to_utf16_offset(ptr, end_pos))) == null) {
            OS.g_signal_stop_emission_by_name(this.handle, OS.delete_text);
        } else if (newText.length() > 0) {
            int[] pos = new int[]{(int)end_pos};
            byte[] buffer = Converter.wcsToMbcs(newText, false);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text(GTK.GTK4 ? this.entryHandle : this.handle, buffer, buffer.length, pos);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position(GTK.GTK4 ? this.entryHandle : this.handle, pos[0]);
        }
        return 0L;
    }

    @Override
    long gtk_event_after(long widget, long gdkEvent) {
        if (this.cursor != null) {
            this.setCursor(this.cursor.handle);
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    @Override
    long gtk_focus_out_event(long widget, long event) {
        this.fixIM();
        return super.gtk_focus_out_event(widget, event);
    }

    @Override
    long gtk_insert_text(long widget, long new_text, long new_text_length, long position) {
        int start;
        String newText;
        if (new_text == 0L || new_text_length == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[(int)new_text_length];
        C.memmove(buffer, new_text, (long)buffer.length);
        String oldText = new String(Converter.mbcsToWcs(buffer));
        int[] pos = new int[1];
        C.memmove(pos, position, 4L);
        long ptr = GTK.gtk_entry_get_text(GTK.GTK4 ? this.entryHandle : this.handle);
        if (pos[0] == -1) {
            pos[0] = (int)OS.g_utf8_strlen(ptr, -1L);
        }
        if ((newText = this.verifyText(oldText, start = (int)OS.g_utf16_pointer_to_offset(ptr, pos[0]), start)) != oldText) {
            int[] newStart = new int[1];
            int[] newEnd = new int[1];
            GTK.gtk_editable_get_selection_bounds(GTK.GTK4 ? this.entryHandle : this.handle, newStart, newEnd);
            if (newText != null) {
                if (newStart[0] != newEnd[0]) {
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection(GTK.GTK4 ? this.entryHandle : this.handle);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] buffer3 = Converter.wcsToMbcs(newText, false);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text(GTK.GTK4 ? this.entryHandle : this.handle, buffer3, buffer3.length, pos);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 26L);
                newStart[0] = newEnd[0] = pos[0];
            }
            pos[0] = newEnd[0];
            if (newStart[0] != newEnd[0]) {
                this.fixStart = newStart[0];
                this.fixEnd = newEnd[0];
            }
            C.memmove(position, pos, 4L);
            OS.g_signal_stop_emission_by_name(this.handle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        long result = super.gtk_key_press_event(widget, event);
        if (result != 0L) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1L) {
            result = 1L;
        }
        this.gdkEventKey = 0L;
        return result;
    }

    @Override
    long gtk_populate_popup(long widget, long menu) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction(menu, 2);
            GTK.gtk_container_forall(menu, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    @Override
    long gtk_value_changed(long widget) {
        this.sendSelectionEvent(13);
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        OS.g_signal_connect_closure(this.handle, OS.insert_text, this.display.getClosure(26), false);
        OS.g_signal_connect_closure(this.handle, OS.delete_text, this.display.getClosure(13), false);
        OS.g_signal_connect_closure(this.handle, OS.value_changed, this.display.getClosure(57), false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.populate_popup, this.display.getClosure(37), false);
        long imContext = this.imContext();
        if (imContext != 0L) {
            OS.g_signal_connect_closure(imContext, OS.commit, this.display.getClosure(9), false);
            int id = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int mask = 17;
            OS.g_signal_handlers_block_matched(imContext, mask, id, 0, 0L, 0L, this.handle);
        }
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return 0L;
    }

    @Override
    long paintWindow() {
        long window = super.paintWindow();
        long children = GDK.gdk_window_get_children(window);
        if (children != 0L) {
            window = OS.g_list_data(children);
        }
        OS.g_list_free(children);
        return window;
    }

    @Override
    long paintSurface() {
        long surface = super.paintSurface();
        long children = GDK.gdk_surface_get_children(surface);
        if (children != 0L) {
            surface = OS.g_list_data(children);
        }
        OS.g_list_free(children);
        return surface;
    }

    public void paste() {
        this.checkWidget();
        GTK.gtk_editable_paste_clipboard(GTK.GTK4 ? this.entryHandle : this.handle);
    }

    @Override
    void register() {
        super.register();
        long imContext = this.imContext();
        if (imContext != 0L) {
            this.display.addWidget(imContext, this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.fixIM();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        this.background = rgba == null ? this.defaultBackground() : rgba;
        if (GTK.GTK4) {
            super.setBackgroundGdkRGBA(context, handle, rgba);
        } else {
            String css;
            String color = this.display.gtk_rgba_to_css_string(this.background);
            this.cssBackground = css = "spinbutton {background-image: -gtk-gradient (linear, 0 0, 0 1, color-stop(0, " + color + "), color-stop(1, " + color + "));}";
            String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
            this.gtk_css_provider_load_from_css(context, finalCss);
        }
    }

    @Override
    void setCursor(long cursor) {
        long defaultCursor = 0L;
        if (cursor == 0L) {
            defaultCursor = GTK.GTK4 ? GDK.gdk_cursor_new_from_name("xterm", 0L) : GDK.gdk_cursor_new_from_name(GDK.gdk_display_get_default(), "xterm");
        }
        super.setCursor(cursor != 0L ? cursor : defaultCursor);
        if (cursor == 0L) {
            OS.g_object_unref(defaultCursor);
        }
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        double page_increment = GTK.gtk_adjustment_get_page_increment(hAdjustment);
        double newValue = value;
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < digits; ++i) {
            newValue /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_increments(this.handle, newValue, page_increment);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        double lower = GTK.gtk_adjustment_get_lower(hAdjustment);
        double newValue = value;
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < digits; ++i) {
            newValue /= 10.0;
        }
        if (newValue < lower) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_range(this.handle, lower, newValue);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        double upper = GTK.gtk_adjustment_get_upper(hAdjustment);
        double newValue = value;
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < digits; ++i) {
            newValue /= 10.0;
        }
        if (newValue > upper) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_range(this.handle, newValue, upper);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        double step_increment = GTK.gtk_adjustment_get_step_increment(hAdjustment);
        double newValue = value;
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < digits; ++i) {
            newValue /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_increments(this.handle, step_increment, newValue);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setSelection(int value) {
        this.checkWidget();
        double newValue = value;
        int digits = GTK.gtk_spin_button_get_digits(this.handle);
        for (int i = 0; i < digits; ++i) {
            newValue /= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_set_value(this.handle, newValue);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        GTK.gtk_entry_set_max_length(GTK.GTK4 ? this.entryHandle : this.handle, limit);
    }

    public void setDigits(int value) {
        int digits;
        this.checkWidget();
        if (value < 0) {
            this.error(5);
        }
        if (value == (digits = GTK.gtk_spin_button_get_digits(this.handle))) {
            return;
        }
        long hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        GtkAdjustment adjustment = new GtkAdjustment();
        this.gtk_adjustment_get(hAdjustment, adjustment);
        int diff = Math.abs(value - digits);
        int factor = 1;
        for (int i = 0; i < diff; ++i) {
            factor *= 10;
        }
        if (digits > value) {
            adjustment.value *= (double)factor;
            adjustment.upper *= (double)factor;
            adjustment.lower *= (double)factor;
            adjustment.step_increment *= (double)factor;
            adjustment.page_increment *= (double)factor;
            this.climbRate *= (double)factor;
        } else {
            adjustment.value /= (double)factor;
            adjustment.upper /= (double)factor;
            adjustment.lower /= (double)factor;
            adjustment.step_increment /= (double)factor;
            adjustment.page_increment /= (double)factor;
            this.climbRate /= (double)factor;
        }
        GTK.gtk_adjustment_configure(hAdjustment, adjustment.value, adjustment.lower, adjustment.upper, adjustment.step_increment, adjustment.page_increment, adjustment.page_size);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        GTK.gtk_spin_button_configure(this.handle, hAdjustment, this.climbRate, value);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.checkWidget();
        if (maximum < minimum) {
            return;
        }
        if (digits < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        selection = Math.min(Math.max(minimum, selection), maximum);
        double factor = 1.0;
        for (int i = 0; i < digits; ++i) {
            factor *= 10.0;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
        this.climbRate = 1.0 / factor;
        long adjustment = GTK.gtk_spin_button_get_adjustment(this.handle);
        GTK.gtk_spin_button_configure(this.handle, adjustment, this.climbRate, digits);
        GTK.gtk_spin_button_set_range(this.handle, (double)minimum / factor, (double)maximum / factor);
        GTK.gtk_spin_button_set_increments(this.handle, (double)increment / factor, (double)pageIncrement / factor);
        GTK.gtk_spin_button_set_value(this.handle, (double)selection / factor);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 57L);
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    boolean translateTraversal(long event) {
        int[] key = new int[1];
        GDK.gdk_event_get_keyval(event, key);
        switch (key[0]) {
            case 65293: 
            case 65421: {
                long imContext = this.imContext();
                if (imContext == 0L) break;
                long[] preeditString = new long[1];
                GTK.gtk_im_context_get_preedit_string(imContext, preeditString, null, null);
                if (preeditString[0] == 0L) break;
                int length = C.strlen(preeditString[0]);
                OS.g_free(preeditString[0]);
                if (length == 0) break;
                return false;
            }
        }
        return super.translateTraversal(event);
    }

    String verifyText(String string, int start, int end) {
        long hAdjustment;
        double lower;
        if (string.length() == 0 && start == end) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = start;
        event.end = end;
        long eventPtr = GTK.gtk_get_current_event();
        if (eventPtr != 0L) {
            int type = GDK.gdk_event_get_event_type(eventPtr);
            type = Spinner.fixGdkEventTypeValues(type);
            switch (type) {
                case 8: {
                    this.setKeyState(event, eventPtr);
                }
            }
            this.gdk_event_free(eventPtr);
        }
        int index = 0;
        if (GTK.gtk_spin_button_get_digits(this.handle) > 0) {
            String decimalSeparator = this.getDecimalSeparator();
            index = string.indexOf(decimalSeparator);
            if (index != -1) {
                string = string.substring(0, index) + string.substring(index + 1);
            }
            index = 0;
        }
        if (string.length() > 0 && (lower = GTK.gtk_adjustment_get_lower(hAdjustment = GTK.gtk_spin_button_get_adjustment(this.handle))) < 0.0 && string.charAt(0) == '-') {
            ++index;
        }
        while (index < string.length() && Character.isDigit(string.charAt(index))) {
            ++index;
        }
        event.doit = index == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

