/**
 * Several extensions for working with {@code ParameterizedTest}s.
 *
 * Disable {@code @ParameterizedTest} executions based on conditions.
 * <p>Check out the following types for details:
 * <ul>
 *     <li>{@link org.junitpioneer.jupiter.params.DisableIfDisplayName}</li>
 *     <li>{@link org.junitpioneer.jupiter.params.DisableIfAllArguments}</li>
 *     <li>{@link org.junitpioneer.jupiter.params.DisableIfAnyArgument}</li>
 *     <li>{@link org.junitpioneer.jupiter.params.DisableIfArgument}</li>
 * </ul>
 *
 * Argument providers for a range of numbers.
 * <p>Check out the following types for details on providing values for parameterized tests:
 * <ul>
 *     <li>{@link org.junitpioneer.jupiter.params.ByteRangeSource}</li>
 *     <li>{@link org.junitpioneer.jupiter.params.ShortRangeSource}</li>
 *     <li>{@link org.junitpioneer.jupiter.params.IntRangeSource}</li>
 *     <li>{@link org.junitpioneer.jupiter.params.LongRangeSource}</li>
 *     <li>{@link org.junitpioneer.jupiter.params.FloatRangeSource}</li>
 *     <li>{@link org.junitpioneer.jupiter.params.DoubleRangeSource}</li>
 * </ul>
 */

package org.junitpioneer.jupiter.params;
