//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cflocaleidentifier?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "CFBase")]
pub type CFLocaleIdentifier = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cflocalekey?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "CFBase")]
pub type CFLocaleKey = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cflocale?language=objc)
#[repr(C)]
pub struct CFLocale {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFLocale"]
    unsafe impl CFLocale {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFLocale {
    #[doc(alias = "CFLocaleGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFLocaleGetTypeID() -> CFTypeID;
        }
        unsafe { CFLocaleGetTypeID() }
    }
}

#[inline]
pub unsafe extern "C-unwind" fn CFLocaleGetSystem() -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFLocaleGetSystem() -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFLocaleGetSystem() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCopyCurrent() -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFLocaleCopyCurrent() -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFLocaleCopyCurrent() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCopyAvailableLocaleIdentifiers(
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyAvailableLocaleIdentifiers() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyAvailableLocaleIdentifiers() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCopyISOLanguageCodes() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyISOLanguageCodes() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyISOLanguageCodes() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCopyISOCountryCodes() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyISOCountryCodes() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyISOCountryCodes() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCopyISOCurrencyCodes() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyISOCurrencyCodes() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyISOCurrencyCodes() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCopyCommonISOCurrencyCodes() -> Option<CFRetained<CFArray>>
{
    extern "C-unwind" {
        fn CFLocaleCopyCommonISOCurrencyCodes() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyCommonISOCurrencyCodes() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCopyPreferredLanguages() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyPreferredLanguages() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyPreferredLanguages() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreateCanonicalLanguageIdentifierFromString(
    allocator: Option<&CFAllocator>,
    locale_identifier: Option<&CFString>,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateCanonicalLanguageIdentifierFromString(
            allocator: Option<&CFAllocator>,
            locale_identifier: Option<&CFString>,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe {
        CFLocaleCreateCanonicalLanguageIdentifierFromString(allocator, locale_identifier)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreateCanonicalLocaleIdentifierFromString(
    allocator: Option<&CFAllocator>,
    locale_identifier: Option<&CFString>,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateCanonicalLocaleIdentifierFromString(
            allocator: Option<&CFAllocator>,
            locale_identifier: Option<&CFString>,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret =
        unsafe { CFLocaleCreateCanonicalLocaleIdentifierFromString(allocator, locale_identifier) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes(
    allocator: Option<&CFAllocator>,
    lcode: LangCode,
    rcode: RegionCode,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes(
            allocator: Option<&CFAllocator>,
            lcode: LangCode,
            rcode: RegionCode,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe {
        CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes(allocator, lcode, rcode)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode(
    allocator: Option<&CFAllocator>,
    lcid: u32,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode(
            allocator: Option<&CFAllocator>,
            lcid: u32,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe { CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode(allocator, lcid) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFLocaleGetWindowsLocaleCodeFromLocaleIdentifier(
        locale_identifier: Option<&CFLocaleIdentifier>,
    ) -> u32;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cflocalelanguagedirection?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFLocaleLanguageDirection(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFLocaleLanguageDirection {
    #[doc(alias = "kCFLocaleLanguageDirectionUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "kCFLocaleLanguageDirectionLeftToRight")]
    pub const LeftToRight: Self = Self(1);
    #[doc(alias = "kCFLocaleLanguageDirectionRightToLeft")]
    pub const RightToLeft: Self = Self(2);
    #[doc(alias = "kCFLocaleLanguageDirectionTopToBottom")]
    pub const TopToBottom: Self = Self(3);
    #[doc(alias = "kCFLocaleLanguageDirectionBottomToTop")]
    pub const BottomToTop: Self = Self(4);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFLocaleLanguageDirection {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFLocaleLanguageDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFLocaleGetLanguageCharacterDirection(
        iso_lang_code: Option<&CFString>,
    ) -> CFLocaleLanguageDirection;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFLocaleGetLanguageLineDirection(
        iso_lang_code: Option<&CFString>,
    ) -> CFLocaleLanguageDirection;
}

#[cfg(all(feature = "CFBase", feature = "CFDictionary"))]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreateComponentsFromLocaleIdentifier(
    allocator: Option<&CFAllocator>,
    locale_id: Option<&CFLocaleIdentifier>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFLocaleCreateComponentsFromLocaleIdentifier(
            allocator: Option<&CFAllocator>,
            locale_id: Option<&CFLocaleIdentifier>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFLocaleCreateComponentsFromLocaleIdentifier(allocator, locale_id) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFDictionary"))]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreateLocaleIdentifierFromComponents(
    allocator: Option<&CFAllocator>,
    dictionary: Option<&CFDictionary>,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateLocaleIdentifierFromComponents(
            allocator: Option<&CFAllocator>,
            dictionary: Option<&CFDictionary>,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe { CFLocaleCreateLocaleIdentifierFromComponents(allocator, dictionary) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreate(
    allocator: Option<&CFAllocator>,
    locale_identifier: Option<&CFLocaleIdentifier>,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFLocaleCreate(
            allocator: Option<&CFAllocator>,
            locale_identifier: Option<&CFLocaleIdentifier>,
        ) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFLocaleCreate(allocator, locale_identifier) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreateCopy(
    allocator: Option<&CFAllocator>,
    locale: Option<&CFLocale>,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFLocaleCreateCopy(
            allocator: Option<&CFAllocator>,
            locale: Option<&CFLocale>,
        ) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFLocaleCreateCopy(allocator, locale) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleGetIdentifier(
    locale: &CFLocale,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleGetIdentifier(locale: &CFLocale) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe { CFLocaleGetIdentifier(locale) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleGetValue(
    locale: &CFLocale,
    key: Option<&CFLocaleKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFLocaleGetValue(
            locale: &CFLocale,
            key: Option<&CFLocaleKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFLocaleGetValue(locale, key) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCopyDisplayNameForPropertyValue(
    display_locale: &CFLocale,
    key: Option<&CFLocaleKey>,
    value: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFLocaleCopyDisplayNameForPropertyValue(
            display_locale: &CFLocale,
            key: Option<&CFLocaleKey>,
            value: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFLocaleCopyDisplayNameForPropertyValue(display_locale, key, value) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecurrentlocaledidchangenotification?language=objc)
    #[cfg(all(feature = "CFBase", feature = "CFNotificationCenter"))]
    pub static kCFLocaleCurrentLocaleDidChangeNotification: Option<&'static CFNotificationName>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocaleidentifier?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleIdentifier: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalelanguagecode?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleLanguageCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecountrycode?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleCountryCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalescriptcode?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleScriptCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalevariantcode?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleVariantCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocaleexemplarcharacterset?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleExemplarCharacterSet: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecalendaridentifier?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleCalendarIdentifier: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleCalendar: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecollationidentifier?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleCollationIdentifier: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocaleusesmetricsystem?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleUsesMetricSystem: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalemeasurementsystem?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleMeasurementSystem: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocaledecimalseparator?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleDecimalSeparator: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalegroupingseparator?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleGroupingSeparator: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecurrencysymbol?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleCurrencySymbol: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecurrencycode?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleCurrencyCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecollatoridentifier?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleCollatorIdentifier: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalequotationbegindelimiterkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleQuotationBeginDelimiterKey: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalequotationenddelimiterkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleQuotationEndDelimiterKey: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalealternatequotationbegindelimiterkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleAlternateQuotationBeginDelimiterKey: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalealternatequotationenddelimiterkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFLocaleAlternateQuotationEndDelimiterKey: Option<&'static CFLocaleKey>;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfcalendaridentifier?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "CFBase")]
pub type CFCalendarIdentifier = CFString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfgregoriancalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFGregorianCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbuddhistcalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFBuddhistCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfchinesecalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFChineseCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfhebrewcalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFHebrewCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfislamiccalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFIslamicCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfislamiccivilcalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFIslamicCivilCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfjapanesecalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFJapaneseCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfrepublicofchinacalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFRepublicOfChinaCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfpersiancalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFPersianCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfindiancalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFIndianCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfiso8601calendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFISO8601Calendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfislamictabularcalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFIslamicTabularCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfislamicummalquracalendar?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFIslamicUmmAlQuraCalendar: Option<&'static CFCalendarIdentifier>;
}
