/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.targets.DynamicValueCompiler;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.indy.ArrayBootstrap;
import org.jruby.ir.targets.indy.HashBootstrap;
import org.jruby.ir.targets.simple.NormalDynamicValueCompiler;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.CodegenUtils;
import org.jruby.util.RegexpOptions;

public class IndyDynamicValueCompiler
implements DynamicValueCompiler {
    private final IRBytecodeAdapter compiler;
    private final DynamicValueCompiler normalCompiler;

    public IndyDynamicValueCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
        this.normalCompiler = new NormalDynamicValueCompiler(compiler);
    }

    @Override
    public void pushDRegexp(Runnable callback, RegexpOptions options2, int arity2) {
        this.normalCompiler.pushDRegexp(callback, options2, arity2);
    }

    @Override
    public void array(int length2) {
        if (length2 > 250) {
            throw new NotCompilableException("literal array has more than 250 elements");
        }
        if (length2 <= 2) {
            this.normalCompiler.array(length2);
            return;
        }
        this.compiler.adapter.invokedynamic("array", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2)), ArrayBootstrap.ARRAY_H, new Object[0]);
    }

    @Override
    public void hash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("literal hash has more than 125 pairs");
        }
        this.compiler.adapter.invokedynamic("hash", CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, JVM.OBJECT, length2 * 2)), HashBootstrap.HASH_H, new Object[0]);
    }
}

