/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.similarity.LevenshteinDetailedDistance;
import org.apache.commons.text.similarity.LevenshteinResults;
import org.apache.commons.text.similarity.SimilarityInput;
import org.apache.commons.text.similarity.SimilarityInputTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class LevenshteinDetailedDistanceTest {
    private static final LevenshteinDetailedDistance UNLIMITED_DISTANCE = LevenshteinDetailedDistance.getDefaultInstance();

    @Test
    public void testApplyThrowsIllegalArgumentExceptionAndCreatesLevenshteinDetailedDistanceTakingInteger() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            LevenshteinDetailedDistance levenshteinDetailedDistance = new LevenshteinDetailedDistance(Integer.valueOf(0));
            TextStringBuilder charSequence = new TextStringBuilder();
            levenshteinDetailedDistance.apply((CharSequence)charSequence, null);
        });
    }

    @Test
    public void testApplyWithNullSimilarityInput() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((SimilarityInput)null, (SimilarityInput)null));
    }

    @Test
    public void testApplyWithNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)null, (CharSequence)null));
    }

    @Test
    public void testConstructorWithNegativeThreshold() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new LevenshteinDetailedDistance(Integer.valueOf(-1)));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    public void testCreatesLevenshteinDetailedDistanceTakingInteger6(Class<?> cls) {
        LevenshteinDetailedDistance levenshteinDetailedDistance = new LevenshteinDetailedDistance(Integer.valueOf(0));
        LevenshteinResults levenshteinResults = levenshteinDetailedDistance.apply((CharSequence)"", (CharSequence)"Distance: 38, Insert: 0, Delete: 0, Substitute: 0");
        Assertions.assertEquals((int)0, (Integer)levenshteinResults.getSubstituteCount());
        Assertions.assertEquals((int)0, (Integer)levenshteinResults.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)levenshteinResults.getInsertCount());
        Assertions.assertEquals((int)-1, (Integer)levenshteinResults.getDistance());
        Assertions.assertEquals((Object)levenshteinResults, (Object)levenshteinDetailedDistance.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "Distance: 38, Insert: 0, Delete: 0, Substitute: 0")));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    public void testEquals(Class<?> cls) {
        LevenshteinDetailedDistance classBeingTested = LevenshteinDetailedDistance.getDefaultInstance();
        LevenshteinResults actualResult = classBeingTested.apply(SimilarityInputTest.build(cls, "hello"), SimilarityInputTest.build(cls, "hallo"));
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1));
        Assertions.assertEquals((Object)expectedResult, (Object)actualResult);
        Assertions.assertEquals((Object)classBeingTested.apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo"), (Object)classBeingTested.apply(SimilarityInputTest.build(cls, "zzzzzzzz"), SimilarityInputTest.build(cls, "hippo")));
        actualResult = classBeingTested.apply(SimilarityInputTest.build(cls, "zzzzzzzz"), SimilarityInputTest.build(cls, "hippo"));
        expectedResult = new LevenshteinResults(Integer.valueOf(8), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(5));
        Assertions.assertEquals((Object)expectedResult, (Object)actualResult);
        Assertions.assertEquals((Object)actualResult, (Object)actualResult);
        actualResult = classBeingTested.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, ""));
        expectedResult = new LevenshteinResults(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        Assertions.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    public void testGetDefaultInstanceOne(Class<?> cls) {
        LevenshteinDetailedDistance levenshteinDetailedDistance = LevenshteinDetailedDistance.getDefaultInstance();
        LevenshteinResults levenshteinResults = levenshteinDetailedDistance.apply(SimilarityInputTest.build(cls, "Distance: -2147483643, Insert: 0, Delete: 0, Substitute: 0"), SimilarityInputTest.build(cls, "Distance: 0, Insert: 2147483536, Delete: 0, Substitute: 0"));
        Assertions.assertEquals((int)21, (Integer)levenshteinResults.getDistance());
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    public void testGetDefaultInstanceTwo(Class<?> cls) {
        LevenshteinDetailedDistance levenshteinDetailedDistance = LevenshteinDetailedDistance.getDefaultInstance();
        LevenshteinResults levenshteinResults = levenshteinDetailedDistance.apply((CharSequence)"Distance: 2147483647, Insert: 0, Delete: 0, Substitute: 0", (CharSequence)"Distance: 0, Insert: 2147483647, Delete: 0, Substitute: 0");
        Assertions.assertEquals((int)20, (Integer)levenshteinResults.getDistance());
        Assertions.assertEquals((Object)levenshteinResults, (Object)levenshteinDetailedDistance.apply(SimilarityInputTest.build(cls, "Distance: 2147483647, Insert: 0, Delete: 0, Substitute: 0"), SimilarityInputTest.build(cls, "Distance: 0, Insert: 2147483647, Delete: 0, Substitute: 0")));
    }

    @Test
    public void testGetLevenshteinDetailedDistance_NullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UNLIMITED_DISTANCE.apply((CharSequence)"a", null));
    }

    @Test
    public void testGetLevenshteinDetailedDistance_NullStringInt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UNLIMITED_DISTANCE.apply(null, (CharSequence)"a"));
    }

    @Test
    public void testGetLevenshteinDetailedDistance_StringNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UNLIMITED_DISTANCE.apply(null, (CharSequence)"a"));
    }

    @Test
    public void testGetLevenshteinDetailedDistance_StringNullInt() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> UNLIMITED_DISTANCE.apply((CharSequence)"a", null));
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.commons.text.similarity.SimilarityInputTest#similarityInputs()"})
    public void testGetLevenshteinDetailedDistance_StringString(Class<?> cls) {
        LevenshteinResults result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, ""));
        Assertions.assertEquals((int)0, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, ""), SimilarityInputTest.build(cls, "a"));
        Assertions.assertEquals((int)1, (Integer)result.getDistance());
        Assertions.assertEquals((int)1, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "aaapppp"), SimilarityInputTest.build(cls, ""));
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)7, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "frog"), SimilarityInputTest.build(cls, "fog"));
        Assertions.assertEquals((int)1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)1, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "fly"), SimilarityInputTest.build(cls, "ant"));
        Assertions.assertEquals((int)3, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)3, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "elephant"), SimilarityInputTest.build(cls, "hippo"));
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)3, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)4, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "elephant"));
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)3, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)4, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hippo"), SimilarityInputTest.build(cls, "zzzzzzzz"));
        Assertions.assertEquals((int)8, (Integer)result.getDistance());
        Assertions.assertEquals((int)3, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)5, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "zzzzzzzz"), SimilarityInputTest.build(cls, "hippo"));
        Assertions.assertEquals((int)8, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)3, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)5, (Integer)result.getSubstituteCount());
        result = UNLIMITED_DISTANCE.apply(SimilarityInputTest.build(cls, "hello"), SimilarityInputTest.build(cls, "hallo"));
        Assertions.assertEquals((int)1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)1, (Integer)result.getSubstituteCount());
    }

    @Test
    public void testGetLevenshteinDetailedDistance_StringStringInt() {
        LevenshteinResults result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"", (CharSequence)"");
        Assertions.assertEquals((int)0, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)7, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)7, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"b", (CharSequence)"a");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"a", (CharSequence)"b");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"aa", (CharSequence)"aa");
        Assertions.assertEquals((int)0, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"aa", (CharSequence)"aa");
        Assertions.assertEquals((int)0, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"aaa", (CharSequence)"bbb");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"aaa", (CharSequence)"bbb");
        Assertions.assertEquals((int)3, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)3, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(10)).apply((CharSequence)"aaaaaa", (CharSequence)"b");
        Assertions.assertEquals((int)6, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)5, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)1, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)6, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)1, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(4)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assertions.assertEquals((int)3, (Integer)result.getDistance());
        Assertions.assertEquals((int)2, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)1, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)6, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)1, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assertions.assertEquals((int)3, (Integer)result.getDistance());
        Assertions.assertEquals((int)2, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)1, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"bbb", (CharSequence)"a");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"bbb", (CharSequence)"a");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"12345", (CharSequence)"1234567");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"1234567", (CharSequence)"12345");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"frog", (CharSequence)"fog");
        Assertions.assertEquals((int)1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)1, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"fly", (CharSequence)"ant");
        Assertions.assertEquals((int)3, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)3, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)3, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)4, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)3, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)4, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)3, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)4, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertEquals((int)-1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz");
        Assertions.assertEquals((int)8, (Integer)result.getDistance());
        Assertions.assertEquals((int)3, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)5, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        Assertions.assertEquals((int)8, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)3, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)5, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"hello", (CharSequence)"hallo");
        Assertions.assertEquals((int)1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)1, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"frog", (CharSequence)"fog");
        Assertions.assertEquals((int)1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)1, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)0, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"fly", (CharSequence)"ant");
        Assertions.assertEquals((int)3, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)3, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)3, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)4, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertEquals((int)7, (Integer)result.getDistance());
        Assertions.assertEquals((int)3, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)4, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz");
        Assertions.assertEquals((int)8, (Integer)result.getDistance());
        Assertions.assertEquals((int)3, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)5, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        Assertions.assertEquals((int)8, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)3, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)5, (Integer)result.getSubstituteCount());
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hello", (CharSequence)"hallo");
        Assertions.assertEquals((int)1, (Integer)result.getDistance());
        Assertions.assertEquals((int)0, (Integer)result.getInsertCount());
        Assertions.assertEquals((int)0, (Integer)result.getDeleteCount());
        Assertions.assertEquals((int)1, (Integer)result.getSubstituteCount());
    }

    @Test
    public void testGetThreshold() {
        LevenshteinDetailedDistance levenshteinDetailedDistance = new LevenshteinDetailedDistance(Integer.valueOf(0));
        Assertions.assertEquals((int)0, (Integer)levenshteinDetailedDistance.getThreshold());
    }

    @Test
    public void testHashCode() {
        LevenshteinDetailedDistance classBeingTested = LevenshteinDetailedDistance.getDefaultInstance();
        LevenshteinResults actualResult = classBeingTested.apply((CharSequence)"aaapppp", (CharSequence)"");
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(7), Integer.valueOf(0));
        Assertions.assertEquals((int)expectedResult.hashCode(), (int)actualResult.hashCode());
        actualResult = classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog");
        expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0));
        Assertions.assertEquals((int)expectedResult.hashCode(), (int)actualResult.hashCode());
        actualResult = classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo");
        expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertEquals((int)expectedResult.hashCode(), (int)actualResult.hashCode());
    }

    @Test
    public void testToString() {
        LevenshteinDetailedDistance classBeingTested = LevenshteinDetailedDistance.getDefaultInstance();
        LevenshteinResults actualResult = classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant");
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(3));
        Assertions.assertEquals((Object)expectedResult.toString(), (Object)actualResult.toString());
        actualResult = classBeingTested.apply((CharSequence)"hippo", (CharSequence)"elephant");
        expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(4));
        Assertions.assertEquals((Object)expectedResult.toString(), (Object)actualResult.toString());
        actualResult = classBeingTested.apply((CharSequence)"", (CharSequence)"a");
        expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0));
        Assertions.assertEquals((Object)expectedResult.toString(), (Object)actualResult.toString());
    }
}

