/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.java.project;

import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.uml.java.project.ModuleItem;
import com.intellij.uml.java.project.UmlModulesUtils;
import com.intellij.uml.utils.DiagramBundle;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class ModuleDependenciesProvider
implements DiagramElementsProvider<ModuleItem> {
    private static final Comparator<ModuleItem> COMPARATOR = (o1, o2) -> {
        if (o1.isLibrary() && o2.isModule()) {
            return 1;
        }
        if (o1.isModule() && o2.isLibrary()) {
            return -1;
        }
        return o1.getName().compareTo(o2.getName());
    };

    public ModuleItem @NotNull [] getElements(ModuleItem element, @NotNull Project project) {
        if (project == null) {
            ModuleDependenciesProvider.$$$reportNull$$$0(0);
        }
        Module module = element.getModule();
        ArrayList<ModuleItem> items = new ArrayList<ModuleItem>();
        for (Module m : ModuleRootManager.getInstance((Module)module).getDependencies()) {
            items.add(new ModuleItem(m));
        }
        for (Library library : UmlModulesUtils.getModuleLibraries(module)) {
            items.add(new ModuleItem(library, project));
        }
        ModuleItem[] moduleItemArray = items.toArray(ModuleItem.EMPTY_ARRAY);
        if (moduleItemArray == null) {
            ModuleDependenciesProvider.$$$reportNull$$$0(1);
        }
        return moduleItemArray;
    }

    @NotNull
    public String getName() {
        String string = DiagramBundle.message((String)"show.modules.dependencies", (Object[])new Object[0]);
        if (string == null) {
            ModuleDependenciesProvider.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getHeaderName(ModuleItem element, @NotNull Project project) {
        if (project == null) {
            ModuleDependenciesProvider.$$$reportNull$$$0(3);
        }
        String string = DiagramBundle.message((String)"dependencies.for.module", (Object[])new Object[]{element.getName()});
        if (string == null) {
            ModuleDependenciesProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public ShortcutSet getShortcutSet() {
        return new CustomShortcutSet(KeyStroke.getKeyStroke(10, 0));
    }

    @NotNull
    public Comparator<? super ModuleItem> getComparator() {
        Comparator<ModuleItem> comparator = COMPARATOR;
        if (comparator == null) {
            ModuleDependenciesProvider.$$$reportNull$$$0(5);
        }
        return comparator;
    }

    public boolean showProgress() {
        return true;
    }

    @NotNull
    public String getProgressMessage() {
        String string = DiagramBundle.message((String)"looking.for.dependencies", (Object[])new Object[0]);
        if (string == null) {
            ModuleDependenciesProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isEnabledOn(ModuleItem element) {
        return element.isModule();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/java/project/ModuleDependenciesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/java/project/ModuleDependenciesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComparator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

