/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.projectView.node;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteVirtualFile;
import com.intellij.notebooks.core.remote.JupyterRemotePath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000f\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0011\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000eH\u0096\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0014J\u0010\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0004\u0019\u001a\u001b\u001c\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteNode;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "", "project", "Lcom/intellij/openapi/project/Project;", "remotePath", "Lcom/intellij/notebooks/core/remote/JupyterRemotePath;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/notebooks/core/remote/JupyterRemotePath;Lcom/intellij/ide/projectView/ViewSettings;)V", "getRemotePath", "()Lcom/intellij/notebooks/core/remote/JupyterRemotePath;", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "canRepresent", "", "element", "", "contains", "file", "getCacheableFile", "getTypeSortKey", "", "", "Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteDirectoryNode;", "Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteFileNode;", "Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteLoadingNode;", "Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteNotLoadedNode;", "intellij.jupyter.core"})
public abstract class JupyterRemoteNode
extends ProjectViewNode<String> {
    @NotNull
    private final JupyterRemotePath remotePath;

    private JupyterRemoteNode(Project project, JupyterRemotePath remotePath, ViewSettings settings) {
        super(project, (Object)remotePath.getNameOrAuthority(), settings);
        this.remotePath = remotePath;
    }

    @NotNull
    public final JupyterRemotePath getRemotePath() {
        return this.remotePath;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        JupyterRemoteFileSystem fs = JupyterRemoteFileSystem.Companion.getInstance();
        return fs.findCachedFileByPath(this.remotePath);
    }

    public boolean canRepresent(@Nullable Object element) {
        PsiFile psiFile = element instanceof PsiFile ? (PsiFile)element : null;
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        JupyterRemoteVirtualFile jupyterRemoteVirtualFile = virtualFile2 instanceof JupyterRemoteVirtualFile ? (JupyterRemoteVirtualFile)virtualFile2 : null;
        if (jupyterRemoteVirtualFile == null) {
            return false;
        }
        JupyterRemoteVirtualFile virtualFile3 = jupyterRemoteVirtualFile;
        return Intrinsics.areEqual((Object)virtualFile3.getRemotePath(), (Object)this.remotePath);
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof JupyterRemoteVirtualFile && this.remotePath.isParentForOrEqual(((JupyterRemoteVirtualFile)file).getRemotePath());
    }

    @Nullable
    protected VirtualFile getCacheableFile() {
        return null;
    }

    @Nullable
    public Comparable<?> getTypeSortKey() {
        String string = this.remotePath.getName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            String extension = FilesKt.getExtension((File)new File(it));
            return ((CharSequence)extension).length() > 0 ? (Comparable)new PsiFileNode.ExtensionSortKey(extension) : null;
        }
        return null;
    }

    public /* synthetic */ JupyterRemoteNode(Project project, JupyterRemotePath remotePath, ViewSettings settings, DefaultConstructorMarker $constructor_marker) {
        this(project, remotePath, settings);
    }
}

