/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.images;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.css.util.CssImageUtil;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.css.util.CssUriUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.intellij.images.fileTypes.impl.SvgFileType;
import org.intellij.images.index.ImageInfoIndex;
import org.intellij.images.util.ImageInfo;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssUpdateBackgroundImageSizeIntention
extends CssBaseElementAtCaretIntentionAction {
    private static final String EMPTY_STRING = "";
    private static final Logger LOG = Logger.getInstance(CssUpdateBackgroundImageSizeIntention.class);

    public void invoke(@NotNull Project project, final @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(2);
        }
        boolean allSizesAreEqual = true;
        ImageInfoReader.Info lastAddedInfo = null;
        final LinkedHashMap<CssUri, ImageInfoReader.Info> uri2size = new LinkedHashMap<CssUri, ImageInfoReader.Info>();
        final CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class, (boolean)false);
        if (block != null) {
            Collection<CssUri> imageUris = CssImageUtil.findBackgroundImageUris(element);
            if (imageUris.isEmpty()) {
                imageUris = CssImageUtil.findBackgroundImageUrlsInBlock(block);
            }
            for (CssUri imageUri : imageUris) {
                ImageInfoReader.Info info = CssUpdateBackgroundImageSizeIntention.getImageInfo(project, (VirtualFile)ContainerUtil.getFirstItem(CssImageUtil.getImageFiles(imageUri)));
                if (info == null && CssUriUtil.isDataUri(imageUri)) {
                    info = CssUpdateBackgroundImageSizeIntention.calculateImageInfoInBackground(project, URLUtil.getBytesFromDataUri((String)imageUri.getValue()));
                }
                if (info == null || info.width <= 0 || info.height <= 0) continue;
                uri2size.put(imageUri, info);
                allSizesAreEqual &= lastAddedInfo == null || lastAddedInfo.equals((Object)info);
                lastAddedInfo = info;
            }
        }
        if (uri2size.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message("css.intentions.update.background.image.size.error", new Object[0]), (String)EMPTY_STRING, null);
            return;
        }
        if (allSizesAreEqual || ApplicationManager.getApplication().isUnitTestMode()) {
            Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(uri2size.entrySet());
            assert (item != null);
            CssUpdateBackgroundImageSizeIntention.updateSize(block, (CssUri)item.getKey(), editor, (ImageInfoReader.Info)item.getValue());
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, new ArrayList(uri2size.keySet()), (Pass)new Pass<CssUri>(){

                public void pass(@NotNull CssUri e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    CssUpdateBackgroundImageSizeIntention.updateSize(block, e, editor, (ImageInfoReader.Info)uri2size.get(e));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/css/actions/images/CssUpdateBackgroundImageSizeIntention$1", "pass"));
                }
            }, string -> {
                String value = string.getValue();
                String result = CssUriUtil.isDataUri(string) && value.length() > 30 ? value.substring(30) + "..." : value;
                ImageInfoReader.Info info = (ImageInfoReader.Info)uri2size.get(string);
                return info != null ? String.format("%s (%dx%d)", result, info.width, info.height) : result;
            }, (String)CssBundle.message("dialog.title.images", new Object[0]));
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        CssBlock block = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class, (boolean)false);
        if (block != null) {
            Collection<CssUri> imageUris = CssImageUtil.findBackgroundImageUris(element);
            if (imageUris.isEmpty()) {
                imageUris = CssImageUtil.findBackgroundImageUrlsInBlock(block);
            }
            for (CssUri imageUri : imageUris) {
                Collection<VirtualFile> files = CssImageUtil.getImageFiles(imageUri);
                if (files.size() != 1 && !CssUriUtil.isDataUri(imageUri)) continue;
                this.setText(CssBundle.message(block.findDeclaration("height") != null || block.findDeclaration("width") != null ? "css.intentions.update.background.image.size" : "css.intentions.insert.background.image.size", new Object[0]));
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static ImageInfoReader.Info calculateImageInfoInBackground(@NotNull Project project, byte @Nullable [] imageBytes) {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(6);
        }
        if (imageBytes == null) {
            return null;
        }
        try {
            return (ImageInfoReader.Info)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ImageInfoReader.getInfo((byte[])imageBytes), CssBundle.message("progress.title.calculating.image.size", new Object[0]), true, project);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static ImageInfoReader.Info getImageInfo(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(7);
        }
        if (file == null) {
            return null;
        }
        ImageInfo imageInfo = ImageInfoIndex.getInfo((VirtualFile)file, (Project)project);
        if (imageInfo != null) {
            return new ImageInfoReader.Info(imageInfo.width, imageInfo.height, 0, FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SvgFileType.INSTANCE));
        }
        try {
            return CssUpdateBackgroundImageSizeIntention.calculateImageInfoInBackground(project, file.contentsToByteArray());
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void updateSize(CssBlock block, CssUri imageUri, Editor editor, ImageInfoReader.Info size) {
        WriteCommandAction.writeCommandAction((Project)block.getProject(), (PsiFile[])new PsiFile[]{imageUri.getContainingFile()}).run(() -> {
            if (size.width <= 0 || size.height <= 0) {
                CommonRefactoringUtil.showErrorHint((Project)block.getProject(), (Editor)editor, (String)CssBundle.message("css.intentions.update.background.image.calculate.size.error", new Object[0]), (String)EMPTY_STRING, null);
                return;
            }
            CssDeclaration anchor = (CssDeclaration)PsiTreeUtil.getParentOfType((PsiElement)imageUri, CssDeclaration.class);
            CssBlock newBlock = CssUpdateBackgroundImageSizeIntention.updateOrInsertSize("height", size.height + "px", block, anchor);
            LOG.assertTrue(newBlock != null, (Object)CoreAttachmentFactory.createAttachment((Document)editor.getDocument()));
            CssUpdateBackgroundImageSizeIntention.updateOrInsertSize("width", size.width + "px", newBlock, anchor);
        });
    }

    @Nullable
    private static CssBlock updateOrInsertSize(String propertyName, String newValue, CssBlock block, CssDeclaration anchor) {
        CssDeclaration property = block.findDeclaration(propertyName, false);
        if (property == null) {
            CssDeclaration declaration = block.addDeclaration(propertyName, newValue, anchor);
            return (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)declaration, CssBlock.class);
        }
        property.setValue(newValue);
        return block;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(9);
        }
        if (psiFile == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(10);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(11);
        }
        return intentionPreviewInfo;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message("css.intentions.update.background.image.size.family", new Object[0]);
        if (string == null) {
            CssUpdateBackgroundImageSizeIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/images/CssUpdateBackgroundImageSizeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/images/CssUpdateBackgroundImageSizeIntention";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calculateImageInfoInBackground";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImageInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }
}

