/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker.service;

import com.github.javafaker.Faker;
import com.github.javafaker.service.FakeValues;
import com.github.javafaker.service.FakeValuesGrouping;
import com.github.javafaker.service.FakeValuesInterface;
import com.github.javafaker.service.RandomService;
import com.github.javafaker.service.files.EnFile;
import com.mifmif.common.regex.Generex;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class FakeValuesService {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("#\\{([a-z0-9A-Z_.]+)\\s?((?:,?'([^']+)')*)\\}");
    private static final Pattern EXPRESSION_ARGUMENTS_PATTERN = Pattern.compile("(?:'(.*?)')");
    private final Logger log = Logger.getLogger("faker");
    private final List<FakeValuesInterface> fakeValuesList;
    private final RandomService randomService;

    public FakeValuesService(Locale locale, RandomService randomService) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is required");
        }
        this.randomService = randomService;
        locale = this.normalizeLocale(locale);
        List<Locale> locales = this.localeChain(locale);
        ArrayList<FakeValuesInterface> all = new ArrayList<FakeValuesInterface>(locales.size());
        for (Locale l : locales) {
            boolean isEnglish = l.equals(Locale.ENGLISH);
            if (isEnglish) {
                FakeValuesGrouping fakeValuesGrouping = new FakeValuesGrouping();
                for (EnFile file : EnFile.getFiles()) {
                    fakeValuesGrouping.add(new FakeValues(l, file.getFile(), file.getPath()));
                }
                all.add(fakeValuesGrouping);
                continue;
            }
            all.add(new FakeValues(locale));
        }
        this.fakeValuesList = Collections.unmodifiableList(all);
    }

    protected List<Locale> localeChain(Locale from) {
        if (Locale.ENGLISH.equals(from)) {
            return Collections.singletonList(Locale.ENGLISH);
        }
        Locale normalized = this.normalizeLocale(from);
        ArrayList<Locale> chain = new ArrayList<Locale>(3);
        chain.add(normalized);
        if (!"".equals(normalized.getCountry()) && !Locale.ENGLISH.getLanguage().equals(normalized.getLanguage())) {
            chain.add(new Locale(normalized.getLanguage()));
        }
        chain.add(Locale.ENGLISH);
        return chain;
    }

    private Locale normalizeLocale(Locale locale) {
        String[] parts = locale.toString().split("[-_]");
        if (parts.length == 1) {
            return new Locale(parts[0]);
        }
        return new Locale(parts[0], parts[1]);
    }

    public Object fetch(String key) {
        List valuesArray = (List)this.fetchObject(key);
        return valuesArray == null ? null : valuesArray.get(this.randomService.nextInt(valuesArray.size()));
    }

    public String fetchString(String key) {
        return (String)this.fetch(key);
    }

    public String safeFetch(String key, String defaultIfNull) {
        Object o = this.fetchObject(key);
        if (o == null) {
            return defaultIfNull;
        }
        if (o instanceof List) {
            List values = (List)o;
            if (values.size() == 0) {
                return defaultIfNull;
            }
            return (String)values.get(this.randomService.nextInt(values.size()));
        }
        if (this.isSlashDelimitedRegex(o.toString())) {
            return String.format("#{regexify '%s'}", this.trimRegexSlashes(o.toString()));
        }
        return (String)o;
    }

    public Object fetchObject(String key) {
        String[] path = key.split("\\.");
        Object result = null;
        for (FakeValuesInterface fakeValuesInterface : this.fakeValuesList) {
            Object currentValue = fakeValuesInterface;
            for (int p = 0; currentValue != null && p < path.length; ++p) {
                String currentPath = path[p];
                currentValue = currentValue instanceof Map ? ((Map)currentValue).get(currentPath) : currentValue.get(currentPath);
            }
            result = currentValue;
            if (result == null) continue;
            break;
        }
        return result;
    }

    public String numerify(String numberString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberString.length(); ++i) {
            if (numberString.charAt(i) == '#') {
                sb.append(this.randomService.nextInt(10));
                continue;
            }
            sb.append(numberString.charAt(i));
        }
        return sb.toString();
    }

    public String bothify(String string) {
        return this.letterify(this.numerify(string));
    }

    public String bothify(String string, boolean isUpper) {
        return this.letterify(this.numerify(string), isUpper);
    }

    public String regexify(String regex) {
        Generex generex = new Generex(regex);
        generex.setSeed(this.randomService.nextLong());
        return generex.random();
    }

    public String letterify(String letterString) {
        return this.letterify(letterString, false);
    }

    public String letterify(String letterString, boolean isUpper) {
        return this.letterHelper(isUpper ? 65 : 97, letterString);
    }

    private String letterHelper(int baseChar, String letterString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < letterString.length(); ++i) {
            if (letterString.charAt(i) == '?') {
                sb.append((char)(baseChar + this.randomService.nextInt(26)));
                continue;
            }
            sb.append(letterString.charAt(i));
        }
        return sb.toString();
    }

    public String resolve(String key, Object current, Faker root) {
        String expression = this.safeFetch(key, null);
        if (expression == null) {
            throw new RuntimeException(key + " resulted in null expression");
        }
        return this.resolveExpression(expression, current, root);
    }

    public String expression(String expression, Faker faker) {
        return this.resolveExpression(expression, null, faker);
    }

    protected String resolveExpression(String expression, Object current, Faker root) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        String result = expression;
        while (matcher.find()) {
            String escapedDirective = matcher.group(0);
            String directive = matcher.group(1);
            String arguments = matcher.group(2);
            Matcher argsMatcher = EXPRESSION_ARGUMENTS_PATTERN.matcher(arguments);
            ArrayList<String> args = new ArrayList<String>();
            while (argsMatcher.find()) {
                args.add(argsMatcher.group(1));
            }
            String resolved = this.resolveExpression(directive, args, current, root);
            if (resolved == null) {
                throw new RuntimeException("Unable to resolve " + escapedDirective + " directive.");
            }
            resolved = this.resolveExpression(resolved, current, root);
            result = StringUtils.replaceOnce((String)result, (String)escapedDirective, (String)resolved);
        }
        return result;
    }

    private String resolveExpression(String directive, List<String> args, Object current, Faker root) {
        String simpleDirective = this.isDotDirective(directive) || current == null ? directive : this.classNameToYamlName(current) + "." + directive;
        String resolved = null;
        if (!this.isDotDirective(directive)) {
            resolved = this.resolveFromMethodOn(current, directive, args);
        }
        if (resolved == null) {
            resolved = this.safeFetch(simpleDirective, null);
        }
        if (resolved == null && !this.isDotDirective(directive)) {
            resolved = this.resolveFromMethodOn(root, directive, args);
        }
        if (resolved == null && this.isDotDirective(directive)) {
            resolved = this.resolveFakerObjectAndMethod(root, directive, args);
        }
        if (resolved == null && this.isDotDirective(directive)) {
            resolved = this.safeFetch(this.javaNameToYamlName(simpleDirective), null);
        }
        return resolved;
    }

    private boolean isSlashDelimitedRegex(String expression) {
        return expression != null && expression.startsWith("/") && expression.endsWith("/");
    }

    private String trimRegexSlashes(String slashDelimitedRegex) {
        return slashDelimitedRegex.substring(1, slashDelimitedRegex.length() - 1);
    }

    private boolean isDotDirective(String directive) {
        return directive.contains(".");
    }

    private String classNameToYamlName(Object current) {
        return this.javaNameToYamlName(current.getClass().getSimpleName());
    }

    private String javaNameToYamlName(String expression) {
        return expression.replaceAll("([A-Z])", "_$1").substring(1).toLowerCase();
    }

    private String resolveFromMethodOn(Object obj, String directive, List<String> args) {
        if (obj == null) {
            return null;
        }
        try {
            MethodAndCoercedArgs accessor = this.accessor(obj, directive, args);
            return accessor == null ? null : this.string(accessor.invoke(obj));
        }
        catch (Exception e) {
            this.log.log(Level.FINE, "Can't call " + directive + " on " + obj, e);
            return null;
        }
    }

    private String resolveFakerObjectAndMethod(Faker faker, String key, List<String> args) {
        String[] classAndMethod = key.split("\\.", 2);
        try {
            String fakerMethodName = classAndMethod[0].replaceAll("_", "");
            MethodAndCoercedArgs fakerAccessor = this.accessor(faker, fakerMethodName, Collections.<String>emptyList());
            if (fakerAccessor == null) {
                this.log.fine("Can't find top level faker object named " + fakerMethodName + ".");
                return null;
            }
            Object objectWithMethodToInvoke = fakerAccessor.invoke(faker);
            String nestedMethodName = classAndMethod[1].replaceAll("_", "");
            MethodAndCoercedArgs accessor = this.accessor(objectWithMethodToInvoke, classAndMethod[1].replaceAll("_", ""), args);
            if (accessor == null) {
                throw new Exception("Can't find method on " + objectWithMethodToInvoke.getClass().getSimpleName() + " called " + nestedMethodName + ".");
            }
            return this.string(accessor.invoke(objectWithMethodToInvoke));
        }
        catch (Exception e) {
            this.log.fine(e.getMessage());
            return null;
        }
    }

    private MethodAndCoercedArgs accessor(Object onObject, String name, List<String> args) {
        this.log.log(Level.FINE, "Find accessor named " + name + " on " + onObject.getClass().getSimpleName() + " with args " + args);
        for (Method m : onObject.getClass().getMethods()) {
            List<Object> coercedArguments;
            if (!m.getName().equalsIgnoreCase(name) || m.getParameterTypes().length != args.size() || (coercedArguments = this.coerceArguments(m, args)) == null) continue;
            return new MethodAndCoercedArgs(m, coercedArguments);
        }
        if (name.contains("_")) {
            return this.accessor(onObject, name.replaceAll("_", ""), args);
        }
        return null;
    }

    private List<Object> coerceArguments(Method accessor, List<String> args) {
        ArrayList<Object> coerced = new ArrayList<Object>();
        for (int i = 0; i < accessor.getParameterTypes().length; ++i) {
            Class toType = ClassUtils.primitiveToWrapper(accessor.getParameterTypes()[i]);
            try {
                if (toType.isEnum()) {
                    Method method = toType.getMethod("valueOf", String.class);
                    String enumArg = args.get(i).substring(args.get(i).indexOf(".") + 1);
                    Object coercedArg = method.invoke(null, enumArg);
                    coerced.add(coercedArg);
                    continue;
                }
                Constructor ctor = toType.getConstructor(String.class);
                Object coercedArgument = ctor.newInstance(args.get(i));
                coerced.add(coercedArgument);
                continue;
            }
            catch (Exception e) {
                this.log.fine("Unable to coerce " + args.get(i) + " to " + toType.getSimpleName() + " via " + toType.getSimpleName() + "(String) constructor.");
                return null;
            }
        }
        return coerced;
    }

    private String string(Object obj) {
        return obj == null ? null : obj.toString();
    }

    private static class MethodAndCoercedArgs {
        private final Method method;
        private final List<Object> coerced;

        private MethodAndCoercedArgs(Method m, List<Object> coerced) {
            this.method = this.requireNonNull(m, "method cannot be null");
            this.coerced = this.requireNonNull(coerced, "coerced arguments cannot be null");
        }

        private Object invoke(Object on) throws InvocationTargetException, IllegalAccessException {
            return this.method.invoke(on, this.coerced.toArray());
        }

        private <T> T requireNonNull(T instance, String messageIfNull) {
            if (instance == null) {
                throw new NullPointerException(messageIfNull);
            }
            return instance;
        }
    }
}

