/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation.diff;

import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class SnapshotObjectsComparator {
    private final V8CachingReader myBaseReader;
    private final V8CachingReader myChangedReader;
    private final LongList myChangedSnapshotIds;
    private final boolean myIsSystemAggregate;
    private final Map<Long, Long> myBaseSnapshotIdToId;
    private final Map<Long, Long> myBaseEquivalentToChanged;
    private final Set<Long> myTakenBase;

    SnapshotObjectsComparator(V8CachingReader baseReader, V8CachingReader changedReader, LongList baseSnapshotIds, LongList changedSnapshotIds, List<Long> baseChildren, boolean isSystemAggregate) {
        this.myBaseReader = baseReader;
        this.myChangedReader = changedReader;
        this.myChangedSnapshotIds = changedSnapshotIds;
        this.myIsSystemAggregate = isSystemAggregate;
        this.myBaseSnapshotIdToId = new HashMap<Long, Long>();
        for (Long child : baseChildren) {
            this.myBaseSnapshotIdToId.put(baseSnapshotIds.getLong(child.intValue()), child);
        }
        this.myBaseEquivalentToChanged = new HashMap<Long, Long>();
        this.myTakenBase = new HashSet<Long>();
    }

    public Long getBaseForChanged(Long changedId) {
        Long saved = this.myBaseEquivalentToChanged.get(changedId);
        if (saved != null && saved >= 0L) {
            return saved;
        }
        Long baseId = this.myBaseSnapshotIdToId.get(this.myChangedSnapshotIds.getLong(changedId.intValue()));
        if (baseId != null && (!this.myIsSystemAggregate || this.compareNames(baseId, changedId))) {
            this.myBaseEquivalentToChanged.put(changedId, baseId);
            this.myTakenBase.add(baseId);
            return baseId;
        }
        this.myBaseEquivalentToChanged.put(changedId, -1L);
        return null;
    }

    private boolean compareNames(Long baseId, Long changedId) {
        String changedName = this.myChangedReader.getString(this.myChangedReader.getNode(changedId).getNameId());
        String baseName = this.myBaseReader.getString(this.myBaseReader.getNode(baseId).getNameId());
        return Objects.equals(changedName, baseName);
    }

    public boolean haveEquivalent(Long baseId) {
        return this.myTakenBase.contains(baseId);
    }
}

