/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.database.model.DataType;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.SqlIntroduceHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlExtractVariableHelper
implements SqlIntroduceHelper {
    private final SqlLanguageDialectEx dialect;

    protected SqlExtractVariableHelper(SqlLanguageDialectEx dialect) {
        this.dialect = dialect;
    }

    public SqlLanguageDialectEx getDialect() {
        return this.dialect;
    }

    @NotNull
    public String getInitialName() {
        return "new_var";
    }

    public boolean isTypeStrict() {
        return false;
    }

    public boolean canInlineInitializer() {
        return false;
    }

    @Nullable
    public PsiElement findInitializerAnchor(@NotNull List<PsiElement> occurrences) {
        if (occurrences == null) {
            SqlExtractVariableHelper.$$$reportNull$$$0(0);
        }
        return SqlExtractVariableHelper.findAnchor(occurrences, SqlBlockStatementImpl.class);
    }

    @Nullable
    protected static PsiElement findAnchor(@NotNull List<PsiElement> occurrences, Class<? extends SqlElement> ... parentClasses) {
        PsiElement e;
        int minOffset;
        PsiElement block;
        PsiElement anchor;
        if (occurrences == null) {
            SqlExtractVariableHelper.$$$reportNull$$$0(1);
        }
        if (parentClasses == null) {
            SqlExtractVariableHelper.$$$reportNull$$$0(2);
        }
        if ((anchor = (PsiElement)ContainerUtil.getFirstItem(occurrences)) == null) {
            return null;
        }
        block0: while (true) {
            block = PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])parentClasses);
            minOffset = Integer.MAX_VALUE;
            for (PsiElement element : occurrences) {
                minOffset = Math.min(minOffset, element.getTextOffset());
                if (PsiTreeUtil.isContextAncestor((PsiElement)block, (PsiElement)element, (boolean)true)) continue;
                if (block == null) {
                    return null;
                }
                anchor = block;
                continue block0;
            }
            break;
        }
        if (block == null) {
            return null;
        }
        PsiElement child = null;
        Iterator iterator = SqlImplUtil.sqlChildren(block).iterator();
        while (iterator.hasNext() && !(child = (e = (PsiElement)iterator.next())).getTextRange().contains(minOffset)) {
        }
        return child;
    }

    @NotNull
    public DdlBuilder createBuilder(@NotNull Project project) {
        if (project == null) {
            SqlExtractVariableHelper.$$$reportNull$$$0(3);
        }
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, this.dialect).withDialect(this.dialect.getDatabaseDialect()).suppressQuoteIdentifiers(true);
        if (ddlBuilder == null) {
            SqlExtractVariableHelper.$$$reportNull$$$0(4);
        }
        return ddlBuilder;
    }

    @Nullable
    public abstract PsiElement createDeclaration(@NotNull Project var1, @NotNull String var2, @NotNull DataType var3, @NotNull String var4);

    @Nullable
    public abstract PsiElement createInitializerDeclaration(@NotNull Project var1, @NotNull String var2, @NotNull String var3);

    public abstract PsiElement addDeclaration(@NotNull PsiElement var1, @NotNull PsiElement var2, @NotNull PsiElement var3);

    @Override
    @Nullable
    public PsiElement findTopmostBlock(@Nullable PsiElement element) {
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)element, SqlBlockStatementImpl.class);
    }

    @Nullable
    public PsiElement getTopmostScope(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, SqlBlockStatementImpl.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/refactoring/SqlExtractVariableHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/refactoring/SqlExtractVariableHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInitializerAnchor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findAnchor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

