/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationDigest;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.annotations.Nullable;

final class JreProxySelector
implements ProxySelector {
    JreProxySelector() {
    }

    public Proxy getProxy(RemoteRepository repository) {
        return this.getProxy(repository.getUrl());
    }

    @Nullable
    public Proxy getProxy(String url) {
        try {
            java.net.ProxySelector systemSelector = java.net.ProxySelector.getDefault();
            if (systemSelector == null) {
                return null;
            }
            URI uri = new URI(url).parseServerAuthority();
            List<java.net.Proxy> selected = systemSelector.select(uri);
            if (selected == null || selected.isEmpty()) {
                return null;
            }
            for (java.net.Proxy proxy : selected) {
                String proxyType;
                if (proxy.type() != Proxy.Type.HTTP || !JreProxySelector.isValid(proxy.address()) || (proxyType = JreProxySelector.chooseProxyType(uri.getScheme())) == null) continue;
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                return new Proxy(proxyType, addr.getHostString(), addr.getPort(), JreProxyAuthentication.INSTANCE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static String chooseProxyType(String protocol) {
        if ("http".equals(protocol)) {
            return "http";
        }
        if ("https".equals(protocol)) {
            return "https";
        }
        return null;
    }

    private static boolean isValid(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)address;
            String hostString = addr.getHostString();
            return addr.getPort() > 0 && hostString != null && !hostString.isEmpty();
        }
        return false;
    }

    private static final class JreProxyAuthentication
    implements Authentication {
        public static final Authentication INSTANCE = new JreProxyAuthentication();

        private JreProxyAuthentication() {
        }

        public void fill(AuthenticationContext context, String key, Map<String, String> data) {
            Proxy proxy = context.getProxy();
            if (proxy == null) {
                return;
            }
            if (!"username".equals(key) && !"password".equals(key)) {
                return;
            }
            try {
                URL url;
                String protocol = "http";
                try {
                    url = new URL(context.getRepository().getUrl());
                    protocol = url.getProtocol();
                }
                catch (Exception e) {
                    url = null;
                }
                PasswordAuthentication auth = Authenticator.requestPasswordAuthentication(proxy.getHost(), null, proxy.getPort(), protocol, "Credentials for proxy " + String.valueOf(proxy), null, url, Authenticator.RequestorType.PROXY);
                if (auth != null) {
                    context.put("username", (Object)auth.getUserName());
                    context.put("password", (Object)auth.getPassword());
                } else {
                    context.put("username", (Object)System.getProperty(protocol + ".proxyUser"));
                    context.put("password", (Object)System.getProperty(protocol + ".proxyPassword"));
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public void digest(AuthenticationDigest digest) {
            digest.update(new String[]{UUID.randomUUID().toString()});
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass().equals(obj.getClass());
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }
}

