/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.microservices;

import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpHost;
import com.intellij.httpClient.http.request.psi.HttpPathAbsolute;
import com.intellij.httpClient.http.request.psi.HttpPort;
import com.intellij.httpClient.http.request.psi.HttpQuery;
import com.intellij.httpClient.http.request.psi.HttpQueryParameter;
import com.intellij.httpClient.http.request.psi.HttpQueryParameterKey;
import com.intellij.httpClient.http.request.psi.HttpQueryParameterValue;
import com.intellij.httpClient.http.request.psi.HttpRequestCompositeElement;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpScheme;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.httpClient.http.request.psi.HttpVisitor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.StringEntry;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class HttpRequestPartiallyKnownUrls {
    private HttpRequestPartiallyKnownUrls() {
    }

    public static List<StringEntry.Known> getUrlParts(final HttpRequestTarget target) {
        final HttpRequestVariableSubstitutor substitutor2 = HttpRequestVariableSubstitutor.getDefault(target.getContainingFile().getOriginalFile()).invalidVariablesAware(false);
        final ArrayList<StringEntry.Known> entries = new ArrayList<StringEntry.Known>();
        target.accept(new HttpVisitor(){

            @Override
            public void visitRequestCompositeElement(@NotNull HttpRequestCompositeElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiElement child : o.getChildren()) {
                    child.accept((PsiElementVisitor)this);
                }
            }

            @Override
            public void visitScheme(@NotNull HttpScheme o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                entries.add(new StringEntry.Known(o.getText(), (PsiElement)target, this.getRange((PsiElement)o)));
                PsiElement schemeSeparator = HttpRequestPsiUtils.getNextSiblingByType((PsiElement)o, HttpRequestElementTypes.SCHEME_SEPARATOR, true);
                if (schemeSeparator != null) {
                    entries.add(new StringEntry.Known(schemeSeparator.getText(), (PsiElement)target, this.getRange(schemeSeparator)));
                }
            }

            @Override
            public void visitHost(@NotNull HttpHost o) {
                if (o == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.visitChildrenExceptSpaces(o);
            }

            private void visitChildrenExceptSpaces(@NotNull HttpRequestCompositeElement o) {
                if (o == null) {
                    1.$$$reportNull$$$0(3);
                }
                for (PsiElement child = o.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child instanceof HttpVariable) {
                        String text2 = substitutor2.getValue(child);
                        if (text2.equals(child.getText())) {
                            entries.add(new StringEntry.Known(text2, (PsiElement)target, this.getRange(child)));
                            continue;
                        }
                        entries.add(new StringEntry.Known(text2, null, TextRange.EMPTY_RANGE));
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace) continue;
                    entries.add(new StringEntry.Known(child.getText(), (PsiElement)target, this.getRange(child)));
                }
            }

            @Override
            public void visitPort(@NotNull HttpPort o) {
                PsiElement portSeparator;
                if (o == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((portSeparator = HttpRequestPsiUtils.getPrevSiblingByType((PsiElement)o, HttpRequestElementTypes.COLON, true)) != null) {
                    entries.add(new StringEntry.Known(portSeparator.getText(), (PsiElement)target, this.getRange(portSeparator)));
                }
                this.visitChildrenExceptSpaces(o);
            }

            @Override
            public void visitPathAbsolute(@NotNull HttpPathAbsolute o) {
                if (o == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.visitChildrenExceptSpaces(o);
            }

            @Override
            public void visitQuery(@NotNull HttpQuery o) {
                PsiElement querySign;
                if (o == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((querySign = HttpRequestPsiUtils.getPrevSiblingByType((PsiElement)o, HttpRequestElementTypes.QUESTION, true)) != null) {
                    entries.add(new StringEntry.Known(querySign.getText(), (PsiElement)target, this.getRange(querySign)));
                }
                super.visitQuery(o);
            }

            @Override
            public void visitQueryParameter(@NotNull HttpQueryParameter o) {
                PsiElement querySeparator;
                if (o == null) {
                    1.$$$reportNull$$$0(7);
                }
                if ((querySeparator = HttpRequestPsiUtils.getPrevSiblingByType((PsiElement)o, HttpRequestElementTypes.AND, true)) != null) {
                    entries.add(new StringEntry.Known(querySeparator.getText(), (PsiElement)target, this.getRange(querySeparator)));
                }
                super.visitQueryParameter(o);
            }

            @Override
            public void visitQueryParameterKey(@NotNull HttpQueryParameterKey o) {
                if (o == null) {
                    1.$$$reportNull$$$0(8);
                }
                this.visitChildrenExceptSpaces(o);
            }

            @Override
            public void visitQueryParameterValue(@NotNull HttpQueryParameterValue o) {
                PsiElement equalSign;
                if (o == null) {
                    1.$$$reportNull$$$0(9);
                }
                if ((equalSign = HttpRequestPsiUtils.getPrevSiblingByType((PsiElement)o, HttpRequestElementTypes.EQUALS, true)) != null) {
                    entries.add(new StringEntry.Known(equalSign.getText(), (PsiElement)target, this.getRange(equalSign)));
                }
                this.visitChildrenExceptSpaces(o);
            }

            @NotNull
            private TextRange getRange(PsiElement child) {
                TextRange textRange = child.getTextRange().shiftLeft(target.getTextOffset());
                if (textRange == null) {
                    1.$$$reportNull$$$0(10);
                }
                return textRange;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 10 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestPartiallyKnownUrls$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestPartiallyKnownUrls$1";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRange";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitRequestCompositeElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitScheme";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitHost";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitChildrenExceptSpaces";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPort";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPathAbsolute";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "visitQuery";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "visitQueryParameter";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "visitQueryParameterKey";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "visitQueryParameterValue";
                        break;
                    }
                    case 10: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 10 -> new IllegalStateException(string);
                };
            }
        });
        return HttpRequestPartiallyKnownUrls.collapseNeighbours(entries);
    }

    @NotNull
    private static List<StringEntry.Known> collapseNeighbours(@NotNull List<StringEntry.Known> entries) {
        if (entries == null) {
            HttpRequestPartiallyKnownUrls.$$$reportNull$$$0(0);
        }
        ArrayList<StringEntry.Known> result2 = new ArrayList<StringEntry.Known>();
        ExtendableStringEntry buffer = null;
        for (StringEntry.Known entry : entries) {
            if (buffer == null) {
                buffer = new ExtendableStringEntry.JustEntry(entry);
                continue;
            }
            if (buffer.canExtend(entry)) {
                buffer = buffer.extend(entry);
                continue;
            }
            result2.add(buffer.getEntry());
            buffer = new ExtendableStringEntry.JustEntry(entry);
        }
        if (buffer != null) {
            result2.add(buffer.getEntry());
        }
        ArrayList<StringEntry.Known> arrayList = result2;
        if (arrayList == null) {
            HttpRequestPartiallyKnownUrls.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestPartiallyKnownUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestPartiallyKnownUrls";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseNeighbours";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collapseNeighbours";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static interface ExtendableStringEntry {
        public boolean canExtend(@NotNull StringEntry.Known var1);

        @NotNull
        public ExtendableStringEntry extend(@NotNull StringEntry.Known var1);

        @NotNull
        public StringEntry.Known getEntry();

        public static class ComplexEntry
        implements ExtendableStringEntry {
            private final StringBuilder myText = new StringBuilder();
            private final PsiElement myElement;
            private final int myStartOffset;

            ComplexEntry(PsiElement element, int startOffset, String firstEntry, String secondEntry) {
                this.myText.append(firstEntry);
                this.myText.append(secondEntry);
                this.myElement = element;
                this.myStartOffset = startOffset;
            }

            @Override
            public boolean canExtend(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull StringEntry.Known entry) {
                if (entry == null) {
                    ComplexEntry.$$$reportNull$$$0(0);
                }
                return this.myStartOffset + this.myText.length() == entry.getRange().getStartOffset();
            }

            @Override
            @NotNull
            public ExtendableStringEntry extend(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull StringEntry.Known entry) {
                if (entry == null) {
                    ComplexEntry.$$$reportNull$$$0(1);
                }
                if (!this.canExtend(entry)) {
                    throw new IllegalArgumentException("Cannot extend with entry");
                }
                this.myText.append(entry.getValue());
                ComplexEntry complexEntry = this;
                if (complexEntry == null) {
                    ComplexEntry.$$$reportNull$$$0(2);
                }
                return complexEntry;
            }

            @Override
            @NotNull
            public StringEntry.Known getEntry() {
                return new StringEntry.Known(this.myText.toString(), this.myElement, TextRange.create((int)this.myStartOffset, (int)(this.myStartOffset + this.myText.length())));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "entry";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestPartiallyKnownUrls$ExtendableStringEntry$ComplexEntry";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestPartiallyKnownUrls$ExtendableStringEntry$ComplexEntry";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "extend";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "canExtend";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "extend";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }

        public static class JustEntry
        implements ExtendableStringEntry {
            private final StringEntry.Known myEntry;

            public JustEntry(StringEntry.Known entry) {
                this.myEntry = entry;
            }

            @Override
            public boolean canExtend(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull StringEntry.Known entry) {
                if (entry == null) {
                    JustEntry.$$$reportNull$$$0(0);
                }
                return this.myEntry.getRange().getEndOffset() == entry.getRange().getStartOffset();
            }

            @Override
            @NotNull
            public ExtendableStringEntry extend(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull StringEntry.Known entry) {
                if (entry == null) {
                    JustEntry.$$$reportNull$$$0(1);
                }
                if (!this.canExtend(entry)) {
                    throw new IllegalArgumentException("Cannot extend with entry");
                }
                return new ComplexEntry(this.myEntry.getSourcePsi(), this.myEntry.getRange().getStartOffset(), this.myEntry.getValue(), entry.getValue());
            }

            @Override
            @NotNull
            public StringEntry.Known getEntry() {
                StringEntry.Known known = this.myEntry;
                if (known == null) {
                    JustEntry.$$$reportNull$$$0(2);
                }
                return known;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "entry";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/httpClient/http/request/microservices/HttpRequestPartiallyKnownUrls$ExtendableStringEntry$JustEntry";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/httpClient/http/request/microservices/HttpRequestPartiallyKnownUrls$ExtendableStringEntry$JustEntry";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEntry";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "canExtend";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "extend";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }
    }
}

