/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptSuspiciousConstructorParameterAssignmentInspection
extends JSInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            TypeScriptSuspiciousConstructorParameterAssignmentInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!node.isConstructor()) {
                    return;
                }
                if (node instanceof TypeScriptFunction && ((TypeScriptFunction)node).isOverloadDeclaration()) {
                    return;
                }
                JSClass containingClass = JSUtils.getMemberContainingClass(node);
                if (containingClass == null) {
                    return;
                }
                JSAttributeList list = containingClass.getAttributeList();
                if (list != null && TypeScriptPsiUtil.isAmbientDeclaration(containingClass)) {
                    return;
                }
                this.checkSuspiciousFieldParamAssignments(node);
            }

            private void checkSuspiciousFieldParamAssignments(final @NotNull JSFunction constructor) {
                Set fieldParamNames;
                if (constructor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((fieldParamNames = Arrays.stream(constructor.getParameterVariables()).filter(TypeScriptPsiUtil::isFieldParameter).map(v -> v.getName()).filter(n -> n != null).collect(Collectors.toSet())).isEmpty()) {
                    return;
                }
                constructor.acceptChildren(new JSRecursiveWalkingElementVisitor(){

                    @Override
                    public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression node) {
                        JSExpression lOperand;
                        if (node == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((lOperand = node.getLOperand()) instanceof JSDefinitionExpression) {
                            lOperand = ((JSDefinitionExpression)lOperand).getExpression();
                        }
                        if (!(lOperand instanceof JSReferenceExpression) || ((JSReferenceExpression)lOperand).getQualifier() != null) {
                            return;
                        }
                        String name = ((JSReferenceExpression)lOperand).getReferenceName();
                        if (!fieldParamNames.contains(name)) {
                            return;
                        }
                        JSFunction function = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)node);
                        if (function != constructor) {
                            return;
                        }
                        holder.registerProblem((PsiElement)lOperand, JavaScriptBundle.message("typescript.suspicious.constructor.parameter.assignment", new Object[0]), new LocalQuickFix[]{new JSInsertThisFix(lOperand)});
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection$1$1", "visitJSAssignmentExpression"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "constructor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkSuspiciousFieldParamAssignments";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptSuspiciousConstructorParameterAssignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

