/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSStatementImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSIfStatementImpl
extends JSStatementImpl
implements JSIfStatement {
    public JSIfStatementImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    public JSExpression getCondition() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Override
    public JSStatement getThenBranch() {
        ASTNode node = this.getNode().findChildByType(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
        return node != null ? (JSStatement)node.getPsi() : null;
    }

    @Override
    public JSStatement getElseBranch() {
        ASTNode myNode = this.getNode();
        ASTNode elseNode = myNode.findChildByType(JSTokenTypes.ELSE_KEYWORD);
        ASTNode node = elseNode != null ? myNode.findChildByType(JSExtendedLanguagesTokenSetProvider.STATEMENTS, elseNode) : null;
        return node != null ? (JSStatement)node.getPsi() : null;
    }

    @Override
    public void setThenBranch(@Nullable JSStatement statement) {
        JSStatement originalThen = this.getThenBranch();
        if (originalThen == null) {
            return;
        }
        if (statement == null) {
            originalThen.replace(JSPsiElementFactory.createJSStatement("{}", this, JSStatement.class));
        } else {
            originalThen.replace(statement);
        }
    }

    @Override
    public void setElseBranch(@Nullable JSStatement statement) {
        JSStatement originalElse = this.getElseBranch();
        PsiElement elseKeyword = this.getElseKeyword();
        if (JSIfStatementImpl.isEmpty(statement) && elseKeyword != null) {
            if (originalElse != null) {
                this.deleteChildRange(elseKeyword, (PsiElement)originalElse);
            }
            return;
        }
        if (originalElse == null) {
            JSIfStatement dummyIfStatement = JSPsiElementFactory.createJSStatement("if () {} else {}", this, JSIfStatement.class);
            this.addRange(JSIfStatementImpl.getElseKeyword((PsiElement)dummyIfStatement), (PsiElement)dummyIfStatement.getElseBranch());
            originalElse = this.getElseBranch();
        }
        if (originalElse != null) {
            originalElse.replace(statement);
        }
    }

    @Nullable
    private PsiElement getElseKeyword() {
        return JSIfStatementImpl.getElseKeyword(this);
    }

    @Nullable
    private static PsiElement getElseKeyword(@NotNull PsiElement element2) {
        ASTNode child;
        if (element2 == null) {
            JSIfStatementImpl.$$$reportNull$$$0(0);
        }
        return (child = element2.getNode().findChildByType(JSTokenTypes.ELSE_KEYWORD)) != null ? child.getPsi() : null;
    }

    private static boolean isEmpty(@Nullable JSStatement branch) {
        return branch == null || branch instanceof JSBlockStatement && ((JSBlockStatement)branch).getStatementListItems().length == 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSIfStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSIfStatement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSIfStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElseKeyword";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

