/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageDataSourcesAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Nullable
    static DasDataSource getDataSourceFromEvent(@NotNull AnActionEvent e) {
        DataContext dataContext;
        if (e == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(1);
        }
        if (DatabaseContextFun.fromDatabaseTree(dataContext = e.getDataContext())) {
            Project project = e.getProject();
            if (project == null) {
                return null;
            }
            List<@NotNull DataSourceNode> sources = DatabaseContextFun.getSelectionRelatedDataSources(dataContext);
            DataSourceNode dsn = sources.stream().findFirst().orElse(null);
            return dsn != null ? dsn.dataSource : null;
        }
        PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        DasDataSource system = (DasDataSource)ObjectUtils.coalesce((Object)DataGridUtilCore.getDatabaseSystem((CoreGrid)dataGrid), (Object)DbImplUtilCore.getForcedDataSource((PsiFile)file), (Object)((DbDataSource)PsiTreeUtil.getParentOfType((PsiElement)element, DbDataSource.class, (boolean)false)));
        return (DasDataSource)ObjectUtils.tryCast((Object)system, DbDataSource.class);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        DataSourceManagerDialog.showDialog(project, (Object)ManageDataSourcesAction.getDataSourceFromEvent(e), null);
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isDS;
        boolean isOrInsideDS;
        KeyEvent ke;
        if (e == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(3);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        DataContext dc = e.getDataContext();
        InputEvent inputEvent = e.getInputEvent();
        KeyEvent keyEvent = inputEvent instanceof KeyEvent ? (ke = (KeyEvent)inputEvent) : null;
        boolean fromTree = DatabaseContextFun.fromDatabaseTree(dc);
        boolean fromActionToolbar = e.isFromActionToolbar();
        boolean fromMainMenu = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || e.getPlace().contains("SettingsEntryPoint");
        boolean fromContextMenu = e.isFromContextMenu();
        boolean withKeyEvent = keyEvent != null;
        boolean isDataGrip = PlatformUtils.isDataGrip();
        if (fromTree) {
            DataSourceNode dsn = DatabaseContextFun.getSelectionRelatedSingleDataSource(dc);
            isOrInsideDS = dsn != null;
            isDS = CollectionFun.containsOnly(DatabaseContextFun.getSelectedTreeNodeRanks(dc), (Object)DvTreeNodeRank.TL_ROOT);
        } else {
            PsiElement psiElement = (PsiElement)dc.getData(CommonDataKeys.PSI_ELEMENT);
            isDS = psiElement instanceof DbDataSource;
            isOrInsideDS = isDS || PsiTreeUtil.getParentOfType((PsiElement)psiElement, DbDataSource.class, (boolean)false) != null;
        }
        boolean enabled = !(!isOrInsideDS && !fromMainMenu && !fromActionToolbar || !fromTree && withKeyEvent);
        boolean visible = fromActionToolbar || fromMainMenu && (isDataGrip || fromTree || withKeyEvent) || fromContextMenu && isDS || withKeyEvent && isDataGrip && this.isFirstApplicableShortcut(e);
        presentation.setEnabled(enabled);
        presentation.setVisible(visible);
        if (visible) {
            presentation.setText(e.isFromContextMenu() ? DatabaseBundle.message((String)"action.DatabaseView.PropertiesAction.popup.text", (Object[])new Object[0]) : DatabaseBundle.message((String)"action.DatabaseView.PropertiesAction.menu.text", (Object[])new Object[0]));
        }
    }

    private boolean isFirstApplicableShortcut(@NotNull AnActionEvent e) {
        KeyEvent ke;
        InputEvent inputEvent;
        if (e == null) {
            ManageDataSourcesAction.$$$reportNull$$$0(4);
        }
        KeyEvent keyEvent = (inputEvent = e.getInputEvent()) instanceof KeyEvent ? (ke = (KeyEvent)inputEvent) : null;
        String actionId = e.getActionManager().getId((AnAction)this);
        KeyboardShortcut shortcut = actionId == null ? null : e.getActionManager().getKeyboardShortcut(actionId);
        return shortcut != null && Comparing.equal((Object)KeyStroke.getKeyStrokeForEvent(keyEvent), (Object)shortcut.getFirstKeyStroke());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ManageDataSourcesAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ManageDataSourcesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDataSourceFromEvent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFirstApplicableShortcut";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

