/*
 * Copyright (c) 2014 DeNA Co., Ltd.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/* DO NOT EDIT! generated by tokens.pl */
h2o_token_t h2o__tokens[] = {{{H2O_STRLIT(":authority")}, {1, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT(":method")}, {2, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT(":path")}, {4, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT(":protocol")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT(":scheme")}, {6, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT(":status")}, {8, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("accept")}, {19, 0, 0, 0, 0, 1, 0, 1}},
                             {{H2O_STRLIT("accept-charset")}, {15, 0, 0, 0, 0, 1, 0, 1}},
                             {{H2O_STRLIT("accept-encoding")}, {16, 0, 0, 0, 0, 1, 0, 1}},
                             {{H2O_STRLIT("accept-language")}, {17, 0, 0, 0, 0, 1, 0, 1}},
                             {{H2O_STRLIT("accept-ranges")}, {18, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("access-control-allow-credentials")}, {0, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("access-control-allow-headers")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("access-control-allow-methods")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("access-control-allow-origin")}, {20, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("access-control-expose-headers")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("access-control-request-headers")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("access-control-request-method")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("age")}, {21, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("allow")}, {22, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("alt-svc")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("authorization")}, {23, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("cache-control")}, {24, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("cache-digest")}, {0, 0, 0, 0, 1, 0, 0, 0}},
                             {{H2O_STRLIT("connection")}, {0, 1, 1, 0, 1, 0, 0, 0}},
                             {{H2O_STRLIT("content-disposition")}, {25, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("content-encoding")}, {26, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("content-language")}, {27, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("content-length")}, {28, 0, 0, 1, 1, 0, 0, 0}},
                             {{H2O_STRLIT("content-location")}, {29, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("content-range")}, {30, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("content-security-policy")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("content-type")}, {31, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("cookie")}, {32, 0, 0, 0, 0, 0, 1, 0}},
                             {{H2O_STRLIT("datagram-flow-id")}, {0, 1, 1, 0, 1, 0, 0, 0}},
                             {{H2O_STRLIT("date")}, {33, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("early-data")}, {0, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("etag")}, {34, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("expect")}, {35, 0, 0, 1, 1, 0, 0, 1}},
                             {{H2O_STRLIT("expect-ct")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("expires")}, {36, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("forwarded")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("from")}, {37, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("host")}, {38, 0, 0, 1, 1, 0, 0, 0}},
                             {{H2O_STRLIT("http2-settings")}, {0, 1, 0, 0, 1, 0, 0, 0}},
                             {{H2O_STRLIT("if-match")}, {39, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("if-modified-since")}, {40, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("if-none-match")}, {41, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("if-range")}, {42, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("if-unmodified-since")}, {43, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("keep-alive")}, {0, 1, 1, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("last-modified")}, {44, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("link")}, {45, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("location")}, {46, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("max-forwards")}, {47, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("no-early-hints")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("origin")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("priority")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("proxy-authenticate")}, {48, 1, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("proxy-authorization")}, {49, 1, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("proxy-connection")}, {0, 1, 1, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("purpose")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("range")}, {50, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("referer")}, {51, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("refresh")}, {52, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("retry-after")}, {53, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("server")}, {54, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("set-cookie")}, {55, 0, 0, 0, 0, 0, 1, 0}},
                             {{H2O_STRLIT("strict-transport-security")}, {56, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("te")}, {0, 1, 0, 0, 1, 0, 0, 1}},
                             {{H2O_STRLIT("timing-allow-origin")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("transfer-encoding")}, {57, 1, 1, 1, 1, 0, 0, 0}},
                             {{H2O_STRLIT("upgrade")}, {0, 1, 1, 1, 1, 0, 0, 0}},
                             {{H2O_STRLIT("upgrade-insecure-requests")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("user-agent")}, {58, 0, 0, 0, 0, 1, 0, 1}},
                             {{H2O_STRLIT("vary")}, {59, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("via")}, {60, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("www-authenticate")}, {61, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("x-compress-hint")}, {0, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("x-content-type-options")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("x-forwarded-for")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("x-frame-options")}, {0, 0, 0, 0, 0, 0, 0, 1}},
                             {{H2O_STRLIT("x-reproxy-url")}, {0, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("x-traffic")}, {0, 0, 0, 0, 0, 0, 0, 0}},
                             {{H2O_STRLIT("x-xss-protection")}, {0, 0, 0, 0, 0, 0, 0, 1}}};
size_t h2o__num_tokens = 85;

const h2o_hpack_static_table_entry_t h2o_hpack_static_table[61] = {{H2O_TOKEN_AUTHORITY, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_METHOD, {H2O_STRLIT("GET")}},
                                                                   {H2O_TOKEN_METHOD, {H2O_STRLIT("POST")}},
                                                                   {H2O_TOKEN_PATH, {H2O_STRLIT("/")}},
                                                                   {H2O_TOKEN_PATH, {H2O_STRLIT("/index.html")}},
                                                                   {H2O_TOKEN_SCHEME, {H2O_STRLIT("http")}},
                                                                   {H2O_TOKEN_SCHEME, {H2O_STRLIT("https")}},
                                                                   {H2O_TOKEN_STATUS, {H2O_STRLIT("200")}},
                                                                   {H2O_TOKEN_STATUS, {H2O_STRLIT("204")}},
                                                                   {H2O_TOKEN_STATUS, {H2O_STRLIT("206")}},
                                                                   {H2O_TOKEN_STATUS, {H2O_STRLIT("304")}},
                                                                   {H2O_TOKEN_STATUS, {H2O_STRLIT("400")}},
                                                                   {H2O_TOKEN_STATUS, {H2O_STRLIT("404")}},
                                                                   {H2O_TOKEN_STATUS, {H2O_STRLIT("500")}},
                                                                   {H2O_TOKEN_ACCEPT_CHARSET, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_ACCEPT_ENCODING, {H2O_STRLIT("gzip, deflate")}},
                                                                   {H2O_TOKEN_ACCEPT_LANGUAGE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_ACCEPT_RANGES, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_ACCEPT, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_ACCESS_CONTROL_ALLOW_ORIGIN, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_AGE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_ALLOW, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_AUTHORIZATION, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_CACHE_CONTROL, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_CONTENT_DISPOSITION, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_CONTENT_ENCODING, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_CONTENT_LANGUAGE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_CONTENT_LENGTH, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_CONTENT_LOCATION, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_CONTENT_RANGE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_COOKIE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_DATE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_ETAG, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_EXPECT, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_EXPIRES, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_FROM, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_HOST, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_IF_MATCH, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_IF_MODIFIED_SINCE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_IF_NONE_MATCH, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_IF_RANGE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_IF_UNMODIFIED_SINCE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_LAST_MODIFIED, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_LINK, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_LOCATION, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_MAX_FORWARDS, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_PROXY_AUTHENTICATE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_PROXY_AUTHORIZATION, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_RANGE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_REFERER, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_REFRESH, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_RETRY_AFTER, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_SERVER, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_SET_COOKIE, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_STRICT_TRANSPORT_SECURITY, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_TRANSFER_ENCODING, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_USER_AGENT, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_VARY, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_VIA, {H2O_STRLIT("")}},
                                                                   {H2O_TOKEN_WWW_AUTHENTICATE, {H2O_STRLIT("")}}};

const h2o_qpack_static_table_entry_t h2o_qpack_static_table[99] = {
    {H2O_TOKEN_AUTHORITY, {H2O_STRLIT("")}},
    {H2O_TOKEN_PATH, {H2O_STRLIT("/")}},
    {H2O_TOKEN_AGE, {H2O_STRLIT("0")}},
    {H2O_TOKEN_CONTENT_DISPOSITION, {H2O_STRLIT("")}},
    {H2O_TOKEN_CONTENT_LENGTH, {H2O_STRLIT("0")}},
    {H2O_TOKEN_COOKIE, {H2O_STRLIT("")}},
    {H2O_TOKEN_DATE, {H2O_STRLIT("")}},
    {H2O_TOKEN_ETAG, {H2O_STRLIT("")}},
    {H2O_TOKEN_IF_MODIFIED_SINCE, {H2O_STRLIT("")}},
    {H2O_TOKEN_IF_NONE_MATCH, {H2O_STRLIT("")}},
    {H2O_TOKEN_LAST_MODIFIED, {H2O_STRLIT("")}},
    {H2O_TOKEN_LINK, {H2O_STRLIT("")}},
    {H2O_TOKEN_LOCATION, {H2O_STRLIT("")}},
    {H2O_TOKEN_REFERER, {H2O_STRLIT("")}},
    {H2O_TOKEN_SET_COOKIE, {H2O_STRLIT("")}},
    {H2O_TOKEN_METHOD, {H2O_STRLIT("CONNECT")}},
    {H2O_TOKEN_METHOD, {H2O_STRLIT("DELETE")}},
    {H2O_TOKEN_METHOD, {H2O_STRLIT("GET")}},
    {H2O_TOKEN_METHOD, {H2O_STRLIT("HEAD")}},
    {H2O_TOKEN_METHOD, {H2O_STRLIT("OPTIONS")}},
    {H2O_TOKEN_METHOD, {H2O_STRLIT("POST")}},
    {H2O_TOKEN_METHOD, {H2O_STRLIT("PUT")}},
    {H2O_TOKEN_SCHEME, {H2O_STRLIT("http")}},
    {H2O_TOKEN_SCHEME, {H2O_STRLIT("https")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("103")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("200")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("304")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("404")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("503")}},
    {H2O_TOKEN_ACCEPT, {H2O_STRLIT("*/*")}},
    {H2O_TOKEN_ACCEPT, {H2O_STRLIT("application/dns-message")}},
    {H2O_TOKEN_ACCEPT_ENCODING, {H2O_STRLIT("gzip, deflate, br")}},
    {H2O_TOKEN_ACCEPT_RANGES, {H2O_STRLIT("bytes")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_HEADERS, {H2O_STRLIT("cache-control")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_HEADERS, {H2O_STRLIT("content-type")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_ORIGIN, {H2O_STRLIT("*")}},
    {H2O_TOKEN_CACHE_CONTROL, {H2O_STRLIT("max-age=0")}},
    {H2O_TOKEN_CACHE_CONTROL, {H2O_STRLIT("max-age=2592000")}},
    {H2O_TOKEN_CACHE_CONTROL, {H2O_STRLIT("max-age=604800")}},
    {H2O_TOKEN_CACHE_CONTROL, {H2O_STRLIT("no-cache")}},
    {H2O_TOKEN_CACHE_CONTROL, {H2O_STRLIT("no-store")}},
    {H2O_TOKEN_CACHE_CONTROL, {H2O_STRLIT("public, max-age=31536000")}},
    {H2O_TOKEN_CONTENT_ENCODING, {H2O_STRLIT("br")}},
    {H2O_TOKEN_CONTENT_ENCODING, {H2O_STRLIT("gzip")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("application/dns-message")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("application/javascript")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("application/json")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("application/x-www-form-urlencoded")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("image/gif")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("image/jpeg")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("image/png")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("text/css")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("text/html; charset=utf-8")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("text/plain")}},
    {H2O_TOKEN_CONTENT_TYPE, {H2O_STRLIT("text/plain;charset=utf-8")}},
    {H2O_TOKEN_RANGE, {H2O_STRLIT("bytes=0-")}},
    {H2O_TOKEN_STRICT_TRANSPORT_SECURITY, {H2O_STRLIT("max-age=31536000")}},
    {H2O_TOKEN_STRICT_TRANSPORT_SECURITY, {H2O_STRLIT("max-age=31536000; includesubdomains")}},
    {H2O_TOKEN_STRICT_TRANSPORT_SECURITY, {H2O_STRLIT("max-age=31536000; includesubdomains; preload")}},
    {H2O_TOKEN_VARY, {H2O_STRLIT("accept-encoding")}},
    {H2O_TOKEN_VARY, {H2O_STRLIT("origin")}},
    {H2O_TOKEN_X_CONTENT_TYPE_OPTIONS, {H2O_STRLIT("nosniff")}},
    {H2O_TOKEN_X_XSS_PROTECTION, {H2O_STRLIT("1; mode=block")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("100")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("204")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("206")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("302")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("400")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("403")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("421")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("425")}},
    {H2O_TOKEN_STATUS, {H2O_STRLIT("500")}},
    {H2O_TOKEN_ACCEPT_LANGUAGE, {H2O_STRLIT("")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_CREDENTIALS, {H2O_STRLIT("FALSE")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_CREDENTIALS, {H2O_STRLIT("TRUE")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_HEADERS, {H2O_STRLIT("*")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_METHODS, {H2O_STRLIT("get")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_METHODS, {H2O_STRLIT("get, post, options")}},
    {H2O_TOKEN_ACCESS_CONTROL_ALLOW_METHODS, {H2O_STRLIT("options")}},
    {H2O_TOKEN_ACCESS_CONTROL_EXPOSE_HEADERS, {H2O_STRLIT("content-length")}},
    {H2O_TOKEN_ACCESS_CONTROL_REQUEST_HEADERS, {H2O_STRLIT("content-type")}},
    {H2O_TOKEN_ACCESS_CONTROL_REQUEST_METHOD, {H2O_STRLIT("get")}},
    {H2O_TOKEN_ACCESS_CONTROL_REQUEST_METHOD, {H2O_STRLIT("post")}},
    {H2O_TOKEN_ALT_SVC, {H2O_STRLIT("clear")}},
    {H2O_TOKEN_AUTHORIZATION, {H2O_STRLIT("")}},
    {H2O_TOKEN_CONTENT_SECURITY_POLICY, {H2O_STRLIT("script-src 'none'; object-src 'none'; base-uri 'none'")}},
    {H2O_TOKEN_EARLY_DATA, {H2O_STRLIT("1")}},
    {H2O_TOKEN_EXPECT_CT, {H2O_STRLIT("")}},
    {H2O_TOKEN_FORWARDED, {H2O_STRLIT("")}},
    {H2O_TOKEN_IF_RANGE, {H2O_STRLIT("")}},
    {H2O_TOKEN_ORIGIN, {H2O_STRLIT("")}},
    {H2O_TOKEN_PURPOSE, {H2O_STRLIT("prefetch")}},
    {H2O_TOKEN_SERVER, {H2O_STRLIT("")}},
    {H2O_TOKEN_TIMING_ALLOW_ORIGIN, {H2O_STRLIT("*")}},
    {H2O_TOKEN_UPGRADE_INSECURE_REQUESTS, {H2O_STRLIT("1")}},
    {H2O_TOKEN_USER_AGENT, {H2O_STRLIT("")}},
    {H2O_TOKEN_X_FORWARDED_FOR, {H2O_STRLIT("")}},
    {H2O_TOKEN_X_FRAME_OPTIONS, {H2O_STRLIT("deny")}},
    {H2O_TOKEN_X_FRAME_OPTIONS, {H2O_STRLIT("sameorigin")}}};

const h2o_token_t *h2o_lookup_token(const char *name, size_t len)
{
    switch (len) {
    case 2:
        switch (name[1]) {
        case 'e':
            if (memcmp(name, "t", 1) == 0)
                return H2O_TOKEN_TE;
            break;
        }
        break;
    case 3:
        switch (name[2]) {
        case 'a':
            if (memcmp(name, "vi", 2) == 0)
                return H2O_TOKEN_VIA;
            break;
        case 'e':
            if (memcmp(name, "ag", 2) == 0)
                return H2O_TOKEN_AGE;
            break;
        }
        break;
    case 4:
        switch (name[3]) {
        case 'e':
            if (memcmp(name, "dat", 3) == 0)
                return H2O_TOKEN_DATE;
            break;
        case 'g':
            if (memcmp(name, "eta", 3) == 0)
                return H2O_TOKEN_ETAG;
            break;
        case 'k':
            if (memcmp(name, "lin", 3) == 0)
                return H2O_TOKEN_LINK;
            break;
        case 'm':
            if (memcmp(name, "fro", 3) == 0)
                return H2O_TOKEN_FROM;
            break;
        case 't':
            if (memcmp(name, "hos", 3) == 0)
                return H2O_TOKEN_HOST;
            break;
        case 'y':
            if (memcmp(name, "var", 3) == 0)
                return H2O_TOKEN_VARY;
            break;
        }
        break;
    case 5:
        switch (name[4]) {
        case 'e':
            if (memcmp(name, "rang", 4) == 0)
                return H2O_TOKEN_RANGE;
            break;
        case 'h':
            if (memcmp(name, ":pat", 4) == 0)
                return H2O_TOKEN_PATH;
            break;
        case 'w':
            if (memcmp(name, "allo", 4) == 0)
                return H2O_TOKEN_ALLOW;
            break;
        }
        break;
    case 6:
        switch (name[5]) {
        case 'e':
            if (memcmp(name, "cooki", 5) == 0)
                return H2O_TOKEN_COOKIE;
            break;
        case 'n':
            if (memcmp(name, "origi", 5) == 0)
                return H2O_TOKEN_ORIGIN;
            break;
        case 'r':
            if (memcmp(name, "serve", 5) == 0)
                return H2O_TOKEN_SERVER;
            break;
        case 't':
            if (memcmp(name, "accep", 5) == 0)
                return H2O_TOKEN_ACCEPT;
            if (memcmp(name, "expec", 5) == 0)
                return H2O_TOKEN_EXPECT;
            break;
        }
        break;
    case 7:
        switch (name[6]) {
        case 'c':
            if (memcmp(name, "alt-sv", 6) == 0)
                return H2O_TOKEN_ALT_SVC;
            break;
        case 'd':
            if (memcmp(name, ":metho", 6) == 0)
                return H2O_TOKEN_METHOD;
            break;
        case 'e':
            if (memcmp(name, ":schem", 6) == 0)
                return H2O_TOKEN_SCHEME;
            if (memcmp(name, "purpos", 6) == 0)
                return H2O_TOKEN_PURPOSE;
            if (memcmp(name, "upgrad", 6) == 0)
                return H2O_TOKEN_UPGRADE;
            break;
        case 'h':
            if (memcmp(name, "refres", 6) == 0)
                return H2O_TOKEN_REFRESH;
            break;
        case 'r':
            if (memcmp(name, "refere", 6) == 0)
                return H2O_TOKEN_REFERER;
            break;
        case 's':
            if (memcmp(name, ":statu", 6) == 0)
                return H2O_TOKEN_STATUS;
            if (memcmp(name, "expire", 6) == 0)
                return H2O_TOKEN_EXPIRES;
            break;
        }
        break;
    case 8:
        switch (name[7]) {
        case 'e':
            if (memcmp(name, "if-rang", 7) == 0)
                return H2O_TOKEN_IF_RANGE;
            break;
        case 'h':
            if (memcmp(name, "if-matc", 7) == 0)
                return H2O_TOKEN_IF_MATCH;
            break;
        case 'n':
            if (memcmp(name, "locatio", 7) == 0)
                return H2O_TOKEN_LOCATION;
            break;
        case 'y':
            if (memcmp(name, "priorit", 7) == 0)
                return H2O_TOKEN_PRIORITY;
            break;
        }
        break;
    case 9:
        switch (name[8]) {
        case 'c':
            if (memcmp(name, "x-traffi", 8) == 0)
                return H2O_TOKEN_X_TRAFFIC;
            break;
        case 'd':
            if (memcmp(name, "forwarde", 8) == 0)
                return H2O_TOKEN_FORWARDED;
            break;
        case 'l':
            if (memcmp(name, ":protoco", 8) == 0)
                return H2O_TOKEN_PROTOCOL;
            break;
        case 't':
            if (memcmp(name, "expect-c", 8) == 0)
                return H2O_TOKEN_EXPECT_CT;
            break;
        }
        break;
    case 10:
        switch (name[9]) {
        case 'a':
            if (memcmp(name, "early-dat", 9) == 0)
                return H2O_TOKEN_EARLY_DATA;
            break;
        case 'e':
            if (memcmp(name, "keep-aliv", 9) == 0)
                return H2O_TOKEN_KEEP_ALIVE;
            if (memcmp(name, "set-cooki", 9) == 0)
                return H2O_TOKEN_SET_COOKIE;
            break;
        case 'n':
            if (memcmp(name, "connectio", 9) == 0)
                return H2O_TOKEN_CONNECTION;
            break;
        case 't':
            if (memcmp(name, "user-agen", 9) == 0)
                return H2O_TOKEN_USER_AGENT;
            break;
        case 'y':
            if (memcmp(name, ":authorit", 9) == 0)
                return H2O_TOKEN_AUTHORITY;
            break;
        }
        break;
    case 11:
        switch (name[10]) {
        case 'r':
            if (memcmp(name, "retry-afte", 10) == 0)
                return H2O_TOKEN_RETRY_AFTER;
            break;
        }
        break;
    case 12:
        switch (name[11]) {
        case 'e':
            if (memcmp(name, "content-typ", 11) == 0)
                return H2O_TOKEN_CONTENT_TYPE;
            break;
        case 's':
            if (memcmp(name, "max-forward", 11) == 0)
                return H2O_TOKEN_MAX_FORWARDS;
            break;
        case 't':
            if (memcmp(name, "cache-diges", 11) == 0)
                return H2O_TOKEN_CACHE_DIGEST;
            break;
        }
        break;
    case 13:
        switch (name[12]) {
        case 'd':
            if (memcmp(name, "last-modifie", 12) == 0)
                return H2O_TOKEN_LAST_MODIFIED;
            break;
        case 'e':
            if (memcmp(name, "content-rang", 12) == 0)
                return H2O_TOKEN_CONTENT_RANGE;
            break;
        case 'h':
            if (memcmp(name, "if-none-matc", 12) == 0)
                return H2O_TOKEN_IF_NONE_MATCH;
            break;
        case 'l':
            if (memcmp(name, "cache-contro", 12) == 0)
                return H2O_TOKEN_CACHE_CONTROL;
            if (memcmp(name, "x-reproxy-ur", 12) == 0)
                return H2O_TOKEN_X_REPROXY_URL;
            break;
        case 'n':
            if (memcmp(name, "authorizatio", 12) == 0)
                return H2O_TOKEN_AUTHORIZATION;
            break;
        case 's':
            if (memcmp(name, "accept-range", 12) == 0)
                return H2O_TOKEN_ACCEPT_RANGES;
            break;
        }
        break;
    case 14:
        switch (name[13]) {
        case 'h':
            if (memcmp(name, "content-lengt", 13) == 0)
                return H2O_TOKEN_CONTENT_LENGTH;
            break;
        case 's':
            if (memcmp(name, "http2-setting", 13) == 0)
                return H2O_TOKEN_HTTP2_SETTINGS;
            if (memcmp(name, "no-early-hint", 13) == 0)
                return H2O_TOKEN_NO_EARLY_HINTS;
            break;
        case 't':
            if (memcmp(name, "accept-charse", 13) == 0)
                return H2O_TOKEN_ACCEPT_CHARSET;
            break;
        }
        break;
    case 15:
        switch (name[14]) {
        case 'e':
            if (memcmp(name, "accept-languag", 14) == 0)
                return H2O_TOKEN_ACCEPT_LANGUAGE;
            break;
        case 'g':
            if (memcmp(name, "accept-encodin", 14) == 0)
                return H2O_TOKEN_ACCEPT_ENCODING;
            break;
        case 'r':
            if (memcmp(name, "x-forwarded-fo", 14) == 0)
                return H2O_TOKEN_X_FORWARDED_FOR;
            break;
        case 's':
            if (memcmp(name, "x-frame-option", 14) == 0)
                return H2O_TOKEN_X_FRAME_OPTIONS;
            break;
        case 't':
            if (memcmp(name, "x-compress-hin", 14) == 0)
                return H2O_TOKEN_X_COMPRESS_HINT;
            break;
        }
        break;
    case 16:
        switch (name[15]) {
        case 'd':
            if (memcmp(name, "datagram-flow-i", 15) == 0)
                return H2O_TOKEN_DATAGRAM_FLOW_ID;
            break;
        case 'e':
            if (memcmp(name, "content-languag", 15) == 0)
                return H2O_TOKEN_CONTENT_LANGUAGE;
            if (memcmp(name, "www-authenticat", 15) == 0)
                return H2O_TOKEN_WWW_AUTHENTICATE;
            break;
        case 'g':
            if (memcmp(name, "content-encodin", 15) == 0)
                return H2O_TOKEN_CONTENT_ENCODING;
            break;
        case 'n':
            if (memcmp(name, "content-locatio", 15) == 0)
                return H2O_TOKEN_CONTENT_LOCATION;
            if (memcmp(name, "proxy-connectio", 15) == 0)
                return H2O_TOKEN_PROXY_CONNECTION;
            if (memcmp(name, "x-xss-protectio", 15) == 0)
                return H2O_TOKEN_X_XSS_PROTECTION;
            break;
        }
        break;
    case 17:
        switch (name[16]) {
        case 'e':
            if (memcmp(name, "if-modified-sinc", 16) == 0)
                return H2O_TOKEN_IF_MODIFIED_SINCE;
            break;
        case 'g':
            if (memcmp(name, "transfer-encodin", 16) == 0)
                return H2O_TOKEN_TRANSFER_ENCODING;
            break;
        }
        break;
    case 18:
        switch (name[17]) {
        case 'e':
            if (memcmp(name, "proxy-authenticat", 17) == 0)
                return H2O_TOKEN_PROXY_AUTHENTICATE;
            break;
        }
        break;
    case 19:
        switch (name[18]) {
        case 'e':
            if (memcmp(name, "if-unmodified-sinc", 18) == 0)
                return H2O_TOKEN_IF_UNMODIFIED_SINCE;
            break;
        case 'n':
            if (memcmp(name, "content-dispositio", 18) == 0)
                return H2O_TOKEN_CONTENT_DISPOSITION;
            if (memcmp(name, "proxy-authorizatio", 18) == 0)
                return H2O_TOKEN_PROXY_AUTHORIZATION;
            if (memcmp(name, "timing-allow-origi", 18) == 0)
                return H2O_TOKEN_TIMING_ALLOW_ORIGIN;
            break;
        }
        break;
    case 22:
        switch (name[21]) {
        case 's':
            if (memcmp(name, "x-content-type-option", 21) == 0)
                return H2O_TOKEN_X_CONTENT_TYPE_OPTIONS;
            break;
        }
        break;
    case 23:
        switch (name[22]) {
        case 'y':
            if (memcmp(name, "content-security-polic", 22) == 0)
                return H2O_TOKEN_CONTENT_SECURITY_POLICY;
            break;
        }
        break;
    case 25:
        switch (name[24]) {
        case 's':
            if (memcmp(name, "upgrade-insecure-request", 24) == 0)
                return H2O_TOKEN_UPGRADE_INSECURE_REQUESTS;
            break;
        case 'y':
            if (memcmp(name, "strict-transport-securit", 24) == 0)
                return H2O_TOKEN_STRICT_TRANSPORT_SECURITY;
            break;
        }
        break;
    case 27:
        switch (name[26]) {
        case 'n':
            if (memcmp(name, "access-control-allow-origi", 26) == 0)
                return H2O_TOKEN_ACCESS_CONTROL_ALLOW_ORIGIN;
            break;
        }
        break;
    case 28:
        switch (name[27]) {
        case 's':
            if (memcmp(name, "access-control-allow-header", 27) == 0)
                return H2O_TOKEN_ACCESS_CONTROL_ALLOW_HEADERS;
            if (memcmp(name, "access-control-allow-method", 27) == 0)
                return H2O_TOKEN_ACCESS_CONTROL_ALLOW_METHODS;
            break;
        }
        break;
    case 29:
        switch (name[28]) {
        case 'd':
            if (memcmp(name, "access-control-request-metho", 28) == 0)
                return H2O_TOKEN_ACCESS_CONTROL_REQUEST_METHOD;
            break;
        case 's':
            if (memcmp(name, "access-control-expose-header", 28) == 0)
                return H2O_TOKEN_ACCESS_CONTROL_EXPOSE_HEADERS;
            break;
        }
        break;
    case 30:
        switch (name[29]) {
        case 's':
            if (memcmp(name, "access-control-request-header", 29) == 0)
                return H2O_TOKEN_ACCESS_CONTROL_REQUEST_HEADERS;
            break;
        }
        break;
    case 32:
        switch (name[31]) {
        case 's':
            if (memcmp(name, "access-control-allow-credential", 31) == 0)
                return H2O_TOKEN_ACCESS_CONTROL_ALLOW_CREDENTIALS;
            break;
        }
        break;
    }

    return NULL;
}

int32_t h2o_qpack_lookup_authority(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 0;
    }
    *is_exact = 0;
    return 0;
}

int32_t h2o_qpack_lookup_method(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("CONNECT"))) {
        *is_exact = 1;
        return 15;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("DELETE"))) {
        *is_exact = 1;
        return 16;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("GET"))) {
        *is_exact = 1;
        return 17;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("HEAD"))) {
        *is_exact = 1;
        return 18;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("OPTIONS"))) {
        *is_exact = 1;
        return 19;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("POST"))) {
        *is_exact = 1;
        return 20;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("PUT"))) {
        *is_exact = 1;
        return 21;
    }
    *is_exact = 0;
    return 15;
}

int32_t h2o_qpack_lookup_path(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("/"))) {
        *is_exact = 1;
        return 1;
    }
    *is_exact = 0;
    return 1;
}

int32_t h2o_qpack_lookup_protocol(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_scheme(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("http"))) {
        *is_exact = 1;
        return 22;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("https"))) {
        *is_exact = 1;
        return 23;
    }
    *is_exact = 0;
    return 22;
}

int32_t h2o_qpack_lookup_status(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("103"))) {
        *is_exact = 1;
        return 24;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("200"))) {
        *is_exact = 1;
        return 25;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("304"))) {
        *is_exact = 1;
        return 26;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("404"))) {
        *is_exact = 1;
        return 27;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("503"))) {
        *is_exact = 1;
        return 28;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("100"))) {
        *is_exact = 1;
        return 63;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("204"))) {
        *is_exact = 1;
        return 64;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("206"))) {
        *is_exact = 1;
        return 65;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("302"))) {
        *is_exact = 1;
        return 66;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("400"))) {
        *is_exact = 1;
        return 67;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("403"))) {
        *is_exact = 1;
        return 68;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("421"))) {
        *is_exact = 1;
        return 69;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("425"))) {
        *is_exact = 1;
        return 70;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("500"))) {
        *is_exact = 1;
        return 71;
    }
    *is_exact = 0;
    return 24;
}

int32_t h2o_qpack_lookup_accept(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("*/*"))) {
        *is_exact = 1;
        return 29;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("application/dns-message"))) {
        *is_exact = 1;
        return 30;
    }
    *is_exact = 0;
    return 29;
}

int32_t h2o_qpack_lookup_accept_charset(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_accept_encoding(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("gzip, deflate, br"))) {
        *is_exact = 1;
        return 31;
    }
    *is_exact = 0;
    return 31;
}

int32_t h2o_qpack_lookup_accept_language(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 72;
    }
    *is_exact = 0;
    return 72;
}

int32_t h2o_qpack_lookup_accept_ranges(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("bytes"))) {
        *is_exact = 1;
        return 32;
    }
    *is_exact = 0;
    return 32;
}

int32_t h2o_qpack_lookup_access_control_allow_credentials(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("FALSE"))) {
        *is_exact = 1;
        return 73;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("TRUE"))) {
        *is_exact = 1;
        return 74;
    }
    *is_exact = 0;
    return 73;
}

int32_t h2o_qpack_lookup_access_control_allow_headers(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("cache-control"))) {
        *is_exact = 1;
        return 33;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("content-type"))) {
        *is_exact = 1;
        return 34;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("*"))) {
        *is_exact = 1;
        return 75;
    }
    *is_exact = 0;
    return 33;
}

int32_t h2o_qpack_lookup_access_control_allow_methods(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("get"))) {
        *is_exact = 1;
        return 76;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("get, post, options"))) {
        *is_exact = 1;
        return 77;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("options"))) {
        *is_exact = 1;
        return 78;
    }
    *is_exact = 0;
    return 76;
}

int32_t h2o_qpack_lookup_access_control_allow_origin(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("*"))) {
        *is_exact = 1;
        return 35;
    }
    *is_exact = 0;
    return 35;
}

int32_t h2o_qpack_lookup_access_control_expose_headers(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("content-length"))) {
        *is_exact = 1;
        return 79;
    }
    *is_exact = 0;
    return 79;
}

int32_t h2o_qpack_lookup_access_control_request_headers(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("content-type"))) {
        *is_exact = 1;
        return 80;
    }
    *is_exact = 0;
    return 80;
}

int32_t h2o_qpack_lookup_access_control_request_method(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("get"))) {
        *is_exact = 1;
        return 81;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("post"))) {
        *is_exact = 1;
        return 82;
    }
    *is_exact = 0;
    return 81;
}

int32_t h2o_qpack_lookup_age(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("0"))) {
        *is_exact = 1;
        return 2;
    }
    *is_exact = 0;
    return 2;
}

int32_t h2o_qpack_lookup_allow(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_alt_svc(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("clear"))) {
        *is_exact = 1;
        return 83;
    }
    *is_exact = 0;
    return 83;
}

int32_t h2o_qpack_lookup_authorization(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 84;
    }
    *is_exact = 0;
    return 84;
}

int32_t h2o_qpack_lookup_cache_control(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("max-age=0"))) {
        *is_exact = 1;
        return 36;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("max-age=2592000"))) {
        *is_exact = 1;
        return 37;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("max-age=604800"))) {
        *is_exact = 1;
        return 38;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("no-cache"))) {
        *is_exact = 1;
        return 39;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("no-store"))) {
        *is_exact = 1;
        return 40;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("public, max-age=31536000"))) {
        *is_exact = 1;
        return 41;
    }
    *is_exact = 0;
    return 36;
}

int32_t h2o_qpack_lookup_cache_digest(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_connection(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_content_disposition(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 3;
    }
    *is_exact = 0;
    return 3;
}

int32_t h2o_qpack_lookup_content_encoding(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("br"))) {
        *is_exact = 1;
        return 42;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("gzip"))) {
        *is_exact = 1;
        return 43;
    }
    *is_exact = 0;
    return 42;
}

int32_t h2o_qpack_lookup_content_language(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_content_length(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("0"))) {
        *is_exact = 1;
        return 4;
    }
    *is_exact = 0;
    return 4;
}

int32_t h2o_qpack_lookup_content_location(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_content_range(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_content_security_policy(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("script-src 'none'; object-src 'none'; base-uri 'none'"))) {
        *is_exact = 1;
        return 85;
    }
    *is_exact = 0;
    return 85;
}

int32_t h2o_qpack_lookup_content_type(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("application/dns-message"))) {
        *is_exact = 1;
        return 44;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("application/javascript"))) {
        *is_exact = 1;
        return 45;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("application/json"))) {
        *is_exact = 1;
        return 46;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("application/x-www-form-urlencoded"))) {
        *is_exact = 1;
        return 47;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("image/gif"))) {
        *is_exact = 1;
        return 48;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("image/jpeg"))) {
        *is_exact = 1;
        return 49;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("image/png"))) {
        *is_exact = 1;
        return 50;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("text/css"))) {
        *is_exact = 1;
        return 51;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("text/html; charset=utf-8"))) {
        *is_exact = 1;
        return 52;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("text/plain"))) {
        *is_exact = 1;
        return 53;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("text/plain;charset=utf-8"))) {
        *is_exact = 1;
        return 54;
    }
    *is_exact = 0;
    return 44;
}

int32_t h2o_qpack_lookup_cookie(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 5;
    }
    *is_exact = 0;
    return 5;
}

int32_t h2o_qpack_lookup_datagram_flow_id(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_date(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 6;
    }
    *is_exact = 0;
    return 6;
}

int32_t h2o_qpack_lookup_early_data(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("1"))) {
        *is_exact = 1;
        return 86;
    }
    *is_exact = 0;
    return 86;
}

int32_t h2o_qpack_lookup_etag(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 7;
    }
    *is_exact = 0;
    return 7;
}

int32_t h2o_qpack_lookup_expect(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_expect_ct(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 87;
    }
    *is_exact = 0;
    return 87;
}

int32_t h2o_qpack_lookup_expires(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_forwarded(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 88;
    }
    *is_exact = 0;
    return 88;
}

int32_t h2o_qpack_lookup_from(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_host(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_http2_settings(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_if_match(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_if_modified_since(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 8;
    }
    *is_exact = 0;
    return 8;
}

int32_t h2o_qpack_lookup_if_none_match(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 9;
    }
    *is_exact = 0;
    return 9;
}

int32_t h2o_qpack_lookup_if_range(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 89;
    }
    *is_exact = 0;
    return 89;
}

int32_t h2o_qpack_lookup_if_unmodified_since(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_keep_alive(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_last_modified(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 10;
    }
    *is_exact = 0;
    return 10;
}

int32_t h2o_qpack_lookup_link(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 11;
    }
    *is_exact = 0;
    return 11;
}

int32_t h2o_qpack_lookup_location(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 12;
    }
    *is_exact = 0;
    return 12;
}

int32_t h2o_qpack_lookup_max_forwards(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_no_early_hints(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_origin(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 90;
    }
    *is_exact = 0;
    return 90;
}

int32_t h2o_qpack_lookup_priority(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_proxy_authenticate(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_proxy_authorization(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_proxy_connection(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_purpose(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("prefetch"))) {
        *is_exact = 1;
        return 91;
    }
    *is_exact = 0;
    return 91;
}

int32_t h2o_qpack_lookup_range(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("bytes=0-"))) {
        *is_exact = 1;
        return 55;
    }
    *is_exact = 0;
    return 55;
}

int32_t h2o_qpack_lookup_referer(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 13;
    }
    *is_exact = 0;
    return 13;
}

int32_t h2o_qpack_lookup_refresh(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_retry_after(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_server(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 92;
    }
    *is_exact = 0;
    return 92;
}

int32_t h2o_qpack_lookup_set_cookie(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 14;
    }
    *is_exact = 0;
    return 14;
}

int32_t h2o_qpack_lookup_strict_transport_security(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("max-age=31536000"))) {
        *is_exact = 1;
        return 56;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("max-age=31536000; includesubdomains"))) {
        *is_exact = 1;
        return 57;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("max-age=31536000; includesubdomains; preload"))) {
        *is_exact = 1;
        return 58;
    }
    *is_exact = 0;
    return 56;
}

int32_t h2o_qpack_lookup_te(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_timing_allow_origin(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("*"))) {
        *is_exact = 1;
        return 93;
    }
    *is_exact = 0;
    return 93;
}

int32_t h2o_qpack_lookup_transfer_encoding(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_upgrade(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_upgrade_insecure_requests(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("1"))) {
        *is_exact = 1;
        return 94;
    }
    *is_exact = 0;
    return 94;
}

int32_t h2o_qpack_lookup_user_agent(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 95;
    }
    *is_exact = 0;
    return 95;
}

int32_t h2o_qpack_lookup_vary(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("accept-encoding"))) {
        *is_exact = 1;
        return 59;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("origin"))) {
        *is_exact = 1;
        return 60;
    }
    *is_exact = 0;
    return 59;
}

int32_t h2o_qpack_lookup_via(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_www_authenticate(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_x_compress_hint(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_x_content_type_options(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("nosniff"))) {
        *is_exact = 1;
        return 61;
    }
    *is_exact = 0;
    return 61;
}

int32_t h2o_qpack_lookup_x_forwarded_for(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT(""))) {
        *is_exact = 1;
        return 96;
    }
    *is_exact = 0;
    return 96;
}

int32_t h2o_qpack_lookup_x_frame_options(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("deny"))) {
        *is_exact = 1;
        return 97;
    }
    if (h2o_memis(value.base, value.len, H2O_STRLIT("sameorigin"))) {
        *is_exact = 1;
        return 98;
    }
    *is_exact = 0;
    return 97;
}

int32_t h2o_qpack_lookup_x_reproxy_url(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_x_traffic(h2o_iovec_t value, int *is_exact)
{
    *is_exact = 0;
    return -1;
}

int32_t h2o_qpack_lookup_x_xss_protection(h2o_iovec_t value, int *is_exact)
{
    if (h2o_memis(value.base, value.len, H2O_STRLIT("1; mode=block"))) {
        *is_exact = 1;
        return 62;
    }
    *is_exact = 0;
    return 62;
}

const h2o_qpack_lookup_static_cb h2o_qpack_lookup_static[85] = {h2o_qpack_lookup_authority,
                                                                h2o_qpack_lookup_method,
                                                                h2o_qpack_lookup_path,
                                                                h2o_qpack_lookup_protocol,
                                                                h2o_qpack_lookup_scheme,
                                                                h2o_qpack_lookup_status,
                                                                h2o_qpack_lookup_accept,
                                                                h2o_qpack_lookup_accept_charset,
                                                                h2o_qpack_lookup_accept_encoding,
                                                                h2o_qpack_lookup_accept_language,
                                                                h2o_qpack_lookup_accept_ranges,
                                                                h2o_qpack_lookup_access_control_allow_credentials,
                                                                h2o_qpack_lookup_access_control_allow_headers,
                                                                h2o_qpack_lookup_access_control_allow_methods,
                                                                h2o_qpack_lookup_access_control_allow_origin,
                                                                h2o_qpack_lookup_access_control_expose_headers,
                                                                h2o_qpack_lookup_access_control_request_headers,
                                                                h2o_qpack_lookup_access_control_request_method,
                                                                h2o_qpack_lookup_age,
                                                                h2o_qpack_lookup_allow,
                                                                h2o_qpack_lookup_alt_svc,
                                                                h2o_qpack_lookup_authorization,
                                                                h2o_qpack_lookup_cache_control,
                                                                h2o_qpack_lookup_cache_digest,
                                                                h2o_qpack_lookup_connection,
                                                                h2o_qpack_lookup_content_disposition,
                                                                h2o_qpack_lookup_content_encoding,
                                                                h2o_qpack_lookup_content_language,
                                                                h2o_qpack_lookup_content_length,
                                                                h2o_qpack_lookup_content_location,
                                                                h2o_qpack_lookup_content_range,
                                                                h2o_qpack_lookup_content_security_policy,
                                                                h2o_qpack_lookup_content_type,
                                                                h2o_qpack_lookup_cookie,
                                                                h2o_qpack_lookup_datagram_flow_id,
                                                                h2o_qpack_lookup_date,
                                                                h2o_qpack_lookup_early_data,
                                                                h2o_qpack_lookup_etag,
                                                                h2o_qpack_lookup_expect,
                                                                h2o_qpack_lookup_expect_ct,
                                                                h2o_qpack_lookup_expires,
                                                                h2o_qpack_lookup_forwarded,
                                                                h2o_qpack_lookup_from,
                                                                h2o_qpack_lookup_host,
                                                                h2o_qpack_lookup_http2_settings,
                                                                h2o_qpack_lookup_if_match,
                                                                h2o_qpack_lookup_if_modified_since,
                                                                h2o_qpack_lookup_if_none_match,
                                                                h2o_qpack_lookup_if_range,
                                                                h2o_qpack_lookup_if_unmodified_since,
                                                                h2o_qpack_lookup_keep_alive,
                                                                h2o_qpack_lookup_last_modified,
                                                                h2o_qpack_lookup_link,
                                                                h2o_qpack_lookup_location,
                                                                h2o_qpack_lookup_max_forwards,
                                                                h2o_qpack_lookup_no_early_hints,
                                                                h2o_qpack_lookup_origin,
                                                                h2o_qpack_lookup_priority,
                                                                h2o_qpack_lookup_proxy_authenticate,
                                                                h2o_qpack_lookup_proxy_authorization,
                                                                h2o_qpack_lookup_proxy_connection,
                                                                h2o_qpack_lookup_purpose,
                                                                h2o_qpack_lookup_range,
                                                                h2o_qpack_lookup_referer,
                                                                h2o_qpack_lookup_refresh,
                                                                h2o_qpack_lookup_retry_after,
                                                                h2o_qpack_lookup_server,
                                                                h2o_qpack_lookup_set_cookie,
                                                                h2o_qpack_lookup_strict_transport_security,
                                                                h2o_qpack_lookup_te,
                                                                h2o_qpack_lookup_timing_allow_origin,
                                                                h2o_qpack_lookup_transfer_encoding,
                                                                h2o_qpack_lookup_upgrade,
                                                                h2o_qpack_lookup_upgrade_insecure_requests,
                                                                h2o_qpack_lookup_user_agent,
                                                                h2o_qpack_lookup_vary,
                                                                h2o_qpack_lookup_via,
                                                                h2o_qpack_lookup_www_authenticate,
                                                                h2o_qpack_lookup_x_compress_hint,
                                                                h2o_qpack_lookup_x_content_type_options,
                                                                h2o_qpack_lookup_x_forwarded_for,
                                                                h2o_qpack_lookup_x_frame_options,
                                                                h2o_qpack_lookup_x_reproxy_url,
                                                                h2o_qpack_lookup_x_traffic,
                                                                h2o_qpack_lookup_x_xss_protection};
