/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.lookup;

import java.util.ArrayList;
import java.util.function.IntFunction;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.utils.GeometryValidator;
import org.elasticsearch.geometry.utils.WellKnownBinary;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;

public abstract class QueryList {
    protected final Block block;

    protected QueryList(Block block) {
        this.block = block;
    }

    int getPositionCount() {
        return this.block.getPositionCount();
    }

    @Nullable
    abstract Query getQuery(int var1);

    public static QueryList rawTermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block block) {
        IntFunction<Object> blockToJavaObject = switch (block.elementType()) {
            default -> throw new IncompatibleClassChangeError();
            case ElementType.BOOLEAN -> {
                BooleanBlock booleanBlock = (BooleanBlock)block;
                yield booleanBlock::getBoolean;
            }
            case ElementType.BYTES_REF -> offset -> {
                BytesRefBlock bytesRefBlock = (BytesRefBlock)block;
                return bytesRefBlock.getBytesRef(offset, new BytesRef());
            };
            case ElementType.DOUBLE -> {
                DoubleBlock doubleBlock = (DoubleBlock)block;
                yield doubleBlock::getDouble;
            }
            case ElementType.FLOAT -> {
                FloatBlock floatBlock = (FloatBlock)block;
                yield floatBlock::getFloat;
            }
            case ElementType.LONG -> {
                Block intBlock = (LongBlock)block;
                yield ((LongBlock)intBlock)::getLong;
            }
            case ElementType.INT -> {
                Block intBlock = (IntBlock)block;
                yield ((IntBlock)intBlock)::getInt;
            }
            case ElementType.NULL -> offset -> null;
            case ElementType.DOC -> throw new IllegalArgumentException("can't read values from [doc] block");
            case ElementType.COMPOSITE -> throw new IllegalArgumentException("can't read values from [composite] block");
            case ElementType.UNKNOWN -> throw new IllegalArgumentException("can't read values from [" + String.valueOf(block) + "]");
        };
        return new TermQueryList(field, searchExecutionContext, block, blockToJavaObject);
    }

    public static QueryList ipTermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, BytesRefBlock block) {
        BytesRef scratch = new BytesRef();
        byte[] ipBytes = new byte[16];
        return new TermQueryList(field, searchExecutionContext, block, offset -> {
            BytesRef bytes = block.getBytesRef(offset, scratch);
            if (ipBytes.length != bytes.length) {
                throw new IllegalStateException("Cannot decode IP field from bytes of length " + bytes.length);
            }
            System.arraycopy(bytes.bytes, bytes.offset, ipBytes, 0, bytes.length);
            return InetAddressPoint.decode((byte[])ipBytes);
        });
    }

    public static QueryList dateTermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, LongBlock block) {
        IntFunction<Object> intFunction;
        if (field instanceof RangeFieldMapper.RangeFieldType) {
            RangeFieldMapper.RangeFieldType rangeFieldType = (RangeFieldMapper.RangeFieldType)field;
            intFunction = offset -> rangeFieldType.dateTimeFormatter().formatMillis(block.getLong(offset));
        } else {
            intFunction = block::getLong;
        }
        return new TermQueryList(field, searchExecutionContext, block, intFunction);
    }

    public static QueryList geoShapeQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block block) {
        return new GeoShapeQueryList(field, searchExecutionContext, block);
    }

    private static class TermQueryList
    extends QueryList {
        private final MappedFieldType field;
        private final SearchExecutionContext searchExecutionContext;
        private final IntFunction<Object> blockValueReader;

        private TermQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block block, IntFunction<Object> blockValueReader) {
            super(block);
            this.field = field;
            this.searchExecutionContext = searchExecutionContext;
            this.blockValueReader = blockValueReader;
        }

        @Override
        Query getQuery(int position) {
            int first = this.block.getFirstValueIndex(position);
            int count = this.block.getValueCount(position);
            return switch (count) {
                case 0 -> null;
                case 1 -> this.field.termQuery(this.blockValueReader.apply(first), this.searchExecutionContext);
                default -> {
                    ArrayList<Object> terms = new ArrayList<Object>(count);
                    for (int i = 0; i < count; ++i) {
                        Object value = this.blockValueReader.apply(first + i);
                        terms.add(value);
                    }
                    yield this.field.termsQuery(terms, this.searchExecutionContext);
                }
            };
        }
    }

    private static class GeoShapeQueryList
    extends QueryList {
        private final BytesRef scratch = new BytesRef();
        private final MappedFieldType field;
        private final SearchExecutionContext searchExecutionContext;
        private final IntFunction<Geometry> blockValueReader;
        private final IntFunction<Query> shapeQuery;

        private GeoShapeQueryList(MappedFieldType field, SearchExecutionContext searchExecutionContext, Block block) {
            super(block);
            this.field = field;
            this.searchExecutionContext = searchExecutionContext;
            this.blockValueReader = this.blockToGeometry(block);
            this.shapeQuery = this.shapeQuery();
        }

        @Override
        Query getQuery(int position) {
            int first = this.block.getFirstValueIndex(position);
            int count = this.block.getValueCount(position);
            return switch (count) {
                case 0 -> null;
                case 1 -> this.shapeQuery.apply(first);
                default -> throw new IllegalArgumentException("can't read multiple Geometry values from a single position");
            };
        }

        private IntFunction<Geometry> blockToGeometry(Block block) {
            return switch (block.elementType()) {
                case ElementType.LONG -> offset -> {
                    long encoded = ((LongBlock)block).getLong(offset);
                    return new Point(GeoEncodingUtils.decodeLongitude((int)((int)encoded)), GeoEncodingUtils.decodeLatitude((int)((int)(encoded >>> 32))));
                };
                case ElementType.BYTES_REF -> offset -> {
                    BytesRef wkb = ((BytesRefBlock)block).getBytesRef(offset, this.scratch);
                    return WellKnownBinary.fromWKB((GeometryValidator)GeometryValidator.NOOP, (boolean)false, (byte[])wkb.bytes, (int)wkb.offset, (int)wkb.length);
                };
                case ElementType.NULL -> offset -> null;
                default -> throw new IllegalArgumentException("can't read Geometry values from [" + String.valueOf((Object)block.elementType()) + "] block");
            };
        }

        private IntFunction<Query> shapeQuery() {
            MappedFieldType mappedFieldType = this.field;
            if (mappedFieldType instanceof GeoShapeQueryable) {
                GeoShapeQueryable geoShapeQueryable = (GeoShapeQueryable)mappedFieldType;
                return offset -> geoShapeQueryable.geoShapeQuery(this.searchExecutionContext, this.field.name(), ShapeRelation.INTERSECTS, this.blockValueReader.apply(offset));
            }
            throw new IllegalArgumentException("Unsupported field type for geo_match ENRICH: " + this.field.typeName());
        }
    }
}

