/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.Describable;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.DriverSleeps;
import org.elasticsearch.compute.operator.DriverStatus;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.TaskCancelledException;

public class Driver
implements Releasable,
Describable {
    public static final TimeValue DEFAULT_TIME_BEFORE_YIELDING = TimeValue.timeValueMinutes((long)5L);
    public static final int DEFAULT_MAX_ITERATIONS = 10000;
    public static final TimeValue DEFAULT_STATUS_INTERVAL = TimeValue.timeValueSeconds((long)1L);
    private final String sessionId;
    private final long startTime;
    private final long startNanos;
    private final DriverContext driverContext;
    private final Supplier<String> description;
    private final List<Operator> activeOperators;
    private final List<DriverStatus.OperatorStatus> statusOfCompletedOperators = new ArrayList<DriverStatus.OperatorStatus>();
    private final Releasable releasable;
    private final long statusNanos;
    private final AtomicReference<String> cancelReason = new AtomicReference();
    private final AtomicReference<SubscribableListener<Void>> blocked = new AtomicReference();
    private final AtomicBoolean started = new AtomicBoolean();
    private final SubscribableListener<Void> completionListener = new SubscribableListener();
    private final AtomicReference<DriverStatus> status;
    private long finishNanos;

    public Driver(String sessionId, long startTime, long startNanos, DriverContext driverContext, Supplier<String> description, SourceOperator source, List<Operator> intermediateOperators, SinkOperator sink, TimeValue statusInterval, Releasable releasable) {
        this.sessionId = sessionId;
        this.startTime = startTime;
        this.startNanos = startNanos;
        this.driverContext = driverContext;
        this.description = description;
        this.activeOperators = new ArrayList<Operator>();
        this.activeOperators.add(source);
        this.activeOperators.addAll(intermediateOperators);
        this.activeOperators.add(sink);
        this.statusNanos = statusInterval.nanos();
        this.releasable = releasable;
        this.status = new AtomicReference<DriverStatus>(new DriverStatus(sessionId, startTime, System.currentTimeMillis(), 0L, 0L, DriverStatus.Status.QUEUED, List.of(), List.of(), DriverSleeps.empty()));
    }

    public Driver(DriverContext driverContext, SourceOperator source, List<Operator> intermediateOperators, SinkOperator sink, Releasable releasable) {
        this("unset", System.currentTimeMillis(), System.nanoTime(), driverContext, () -> null, source, intermediateOperators, sink, DEFAULT_STATUS_INTERVAL, releasable);
    }

    public DriverContext driverContext() {
        return this.driverContext;
    }

    SubscribableListener<Void> run(TimeValue maxTime, int maxIterations, LongSupplier nowSupplier) {
        this.updateStatus(0L, 0, DriverStatus.Status.RUNNING, "driver running");
        long maxTimeNanos = maxTime.nanos();
        long startTime = nowSupplier.getAsLong();
        long nextStatus = startTime + this.statusNanos;
        int iter = 0;
        while (true) {
            IsBlockedResult isBlocked = this.runSingleLoopIteration();
            ++iter;
            if (!isBlocked.listener().isDone()) {
                this.updateStatus(nowSupplier.getAsLong() - startTime, iter, DriverStatus.Status.ASYNC, isBlocked.reason());
                return isBlocked.listener();
            }
            if (this.isFinished()) {
                this.finishNanos = nowSupplier.getAsLong();
                this.updateStatus(this.finishNanos - startTime, iter, DriverStatus.Status.DONE, "driver done");
                this.driverContext.finish();
                Releasables.close((Releasable[])new Releasable[]{this.releasable, this.driverContext.getSnapshot()});
                return Operator.NOT_BLOCKED.listener();
            }
            long now = nowSupplier.getAsLong();
            if (iter >= maxIterations) {
                this.updateStatus(now - startTime, iter, DriverStatus.Status.WAITING, "driver iterations");
                return Operator.NOT_BLOCKED.listener();
            }
            if (now - startTime >= maxTimeNanos) {
                this.updateStatus(now - startTime, iter, DriverStatus.Status.WAITING, "driver time");
                return Operator.NOT_BLOCKED.listener();
            }
            if (now <= nextStatus) continue;
            this.updateStatus(now - startTime, iter, DriverStatus.Status.RUNNING, "driver running");
            nextStatus = now + this.statusNanos;
        }
    }

    private boolean isFinished() {
        return this.activeOperators.isEmpty();
    }

    public void close() {
        this.drainAndCloseOperators(null);
    }

    public void abort(Exception reason, ActionListener<Void> listener) {
        this.finishNanos = System.nanoTime();
        this.completionListener.addListener(listener);
        if (this.started.compareAndSet(false, true)) {
            this.drainAndCloseOperators(reason);
            this.completionListener.onFailure(reason);
        } else {
            this.cancel(reason.getMessage());
        }
    }

    private IsBlockedResult runSingleLoopIteration() {
        this.ensureNotCancelled();
        boolean movedPage = false;
        for (int i = 0; i < this.activeOperators.size() - 1; ++i) {
            Page page;
            Operator op = this.activeOperators.get(i);
            Operator nextOp = this.activeOperators.get(i + 1);
            if (!op.isBlocked().listener().isDone()) continue;
            if (!op.isFinished() && nextOp.needsInput() && (page = op.getOutput()) != null) {
                if (page.getPositionCount() == 0) {
                    page.releaseBlocks();
                } else {
                    nextOp.addInput(page);
                    movedPage = true;
                }
            }
            if (!op.isFinished()) continue;
            nextOp.finish();
        }
        for (int index = this.activeOperators.size() - 1; index >= 0; --index) {
            if (!this.activeOperators.get(index).isFinished()) continue;
            List<Operator> finishedOperators = this.activeOperators.subList(0, index + 1);
            Iterator<Operator> itr = finishedOperators.iterator();
            while (itr.hasNext()) {
                Operator op = itr.next();
                this.statusOfCompletedOperators.add(new DriverStatus.OperatorStatus(op.toString(), op.status()));
                op.close();
                itr.remove();
            }
            if (this.activeOperators.isEmpty()) break;
            Operator newRootOperator = this.activeOperators.get(0);
            newRootOperator.finish();
            break;
        }
        if (!movedPage) {
            return Driver.oneOf(this.activeOperators.stream().map(Operator::isBlocked).filter(laf -> !laf.listener().isDone()).collect(Collectors.toList()));
        }
        return Operator.NOT_BLOCKED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String reason) {
        if (this.cancelReason.compareAndSet(null, reason)) {
            Driver driver = this;
            synchronized (driver) {
                SubscribableListener<Void> fut = this.blocked.get();
                if (fut != null) {
                    fut.onFailure((Exception)new TaskCancelledException(reason));
                }
            }
        }
    }

    private boolean isCancelled() {
        return this.cancelReason.get() != null;
    }

    private void ensureNotCancelled() {
        String reason = this.cancelReason.get();
        if (reason != null) {
            throw new TaskCancelledException(reason);
        }
    }

    public static void start(ThreadContext threadContext, Executor executor, Driver driver, int maxIterations, ActionListener<Void> listener) {
        driver.completionListener.addListener(listener);
        if (driver.started.compareAndSet(false, true)) {
            driver.updateStatus(0L, 0, DriverStatus.Status.STARTING, "driver starting");
            Driver.schedule(DEFAULT_TIME_BEFORE_YIELDING, maxIterations, threadContext, executor, driver, driver.completionListener);
        }
    }

    private void drainAndCloseOperators(@Nullable Exception e) {
        Iterator<Operator> itr = this.activeOperators.iterator();
        while (itr.hasNext()) {
            block3: {
                try {
                    Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{itr.next()});
                }
                catch (Exception x) {
                    if (e == null) break block3;
                    e.addSuppressed(x);
                }
            }
            itr.remove();
        }
        this.driverContext.finish();
        Releasables.closeWhileHandlingException((Releasable[])new Releasable[]{this.releasable, this.driverContext.getSnapshot()});
    }

    private static void schedule(final TimeValue maxTime, final int maxIterations, final ThreadContext threadContext, final Executor executor, final Driver driver, final ActionListener<Void> listener) {
        executor.execute((Runnable)new AbstractRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doRun() {
                SubscribableListener<Void> fut = driver.run(maxTime, maxIterations, System::nanoTime);
                if (driver.isFinished()) {
                    this.onComplete((ActionListener<Void>)listener);
                    return;
                }
                if (fut.isDone()) {
                    Driver.schedule(maxTime, maxIterations, threadContext, executor, driver, (ActionListener<Void>)listener);
                } else {
                    Driver driver2 = driver;
                    synchronized (driver2) {
                        if (!driver.isCancelled()) {
                            driver.blocked.set(fut);
                        }
                    }
                    ActionListener readyListener = ActionListener.wrap(ignored -> Driver.schedule(maxTime, maxIterations, threadContext, executor, driver, (ActionListener<Void>)listener), this::onFailure);
                    fut.addListener((ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)readyListener, (ThreadContext)threadContext));
                }
            }

            public void onFailure(Exception e) {
                driver.drainAndCloseOperators(e);
                this.onComplete((ActionListener<Void>)ActionListener.running(() -> listener.onFailure(e)));
            }

            void onComplete(ActionListener<Void> listener2) {
                driver.driverContext.waitForAsyncActions((ActionListener<Void>)ContextPreservingActionListener.wrapPreservingContext(listener2, (ThreadContext)threadContext));
            }
        });
    }

    private static IsBlockedResult oneOf(List<IsBlockedResult> results) {
        if (results.isEmpty()) {
            return Operator.NOT_BLOCKED;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        SubscribableListener oneOf = new SubscribableListener();
        StringBuilder reason = new StringBuilder();
        for (IsBlockedResult r : results) {
            r.listener().addListener((ActionListener)oneOf);
            if (!reason.isEmpty()) {
                reason.append(" OR ");
            }
            reason.append(r.reason());
        }
        return new IsBlockedResult((SubscribableListener<Void>)oneOf, reason.toString());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[activeOperators=" + String.valueOf(this.activeOperators) + "]";
    }

    @Override
    public String describe() {
        return this.description.get();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public DriverStatus status() {
        return this.status.get();
    }

    public DriverProfile profile() {
        DriverStatus status = this.status();
        if (status.status() != DriverStatus.Status.DONE) {
            throw new IllegalStateException("can only get profile from finished driver");
        }
        return new DriverProfile(status.started(), status.lastUpdated(), this.finishNanos - this.startNanos, status.cpuNanos(), status.iterations(), status.completedOperators(), status.sleeps());
    }

    private void updateStatus(long extraCpuNanos, int extraIterations, DriverStatus.Status status, String reason) {
        this.status.getAndUpdate(prev -> {
            long now = System.currentTimeMillis();
            DriverSleeps sleeps = prev.sleeps();
            block0 : switch (status) {
                case ASYNC: 
                case WAITING: {
                    sleeps = sleeps.sleep(reason, now);
                    return new DriverStatus(this.sessionId, this.startTime, now, prev.cpuNanos() + extraCpuNanos, prev.iterations() + (long)extraIterations, status, this.statusOfCompletedOperators, this.activeOperators.stream().map(op -> new DriverStatus.OperatorStatus(op.toString(), op.status())).toList(), sleeps);
                }
                case RUNNING: {
                    switch (prev.status()) {
                        case ASYNC: 
                        case WAITING: {
                            sleeps = sleeps.wake(now);
                            break block0;
                        }
                        case STARTING: {
                            if (extraIterations != 0) return new DriverStatus(this.sessionId, this.startTime, now, prev.cpuNanos() + extraCpuNanos, prev.iterations() + (long)extraIterations, status, this.statusOfCompletedOperators, this.activeOperators.stream().map(op -> new DriverStatus.OperatorStatus(op.toString(), op.status())).toList(), sleeps);
                            return prev;
                        }
                    }
                }
            }
            return new DriverStatus(this.sessionId, this.startTime, now, prev.cpuNanos() + extraCpuNanos, prev.iterations() + (long)extraIterations, status, this.statusOfCompletedOperators, this.activeOperators.stream().map(op -> new DriverStatus.OperatorStatus(op.toString(), op.status())).toList(), sleeps);
        });
    }
}

