/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractArrayBlock;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockRamUsageEstimator;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.LongArrayVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongLookup;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

final class LongArrayBlock
extends AbstractArrayBlock
implements LongBlock {
    static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongArrayBlock.class);
    private final LongArrayVector vector;

    LongArrayBlock(long[] values, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering, BlockFactory blockFactory) {
        this(new LongArrayVector(values, firstValueIndexes == null ? positionCount : firstValueIndexes[positionCount], blockFactory), positionCount, firstValueIndexes, nulls, mvOrdering);
    }

    private LongArrayBlock(LongArrayVector vector, int positionCount, int[] firstValueIndexes, BitSet nulls, Block.MvOrdering mvOrdering) {
        super(positionCount, firstValueIndexes, nulls, mvOrdering);
        this.vector = vector;
        assert (firstValueIndexes != null ? firstValueIndexes[this.getPositionCount()] == vector.getPositionCount() : vector.getPositionCount() == this.getPositionCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LongArrayBlock readArrayBlock(BlockFactory blockFactory, BlockStreamInput in) throws IOException {
        AbstractArrayBlock.SubFields sub = new AbstractArrayBlock.SubFields(blockFactory, (StreamInput)in);
        LongArrayVector vector = null;
        boolean success = false;
        try {
            vector = LongArrayVector.readArrayVector(sub.vectorPositions(), (StreamInput)in, blockFactory);
            LongArrayBlock block = new LongArrayBlock(vector, sub.positionCount, sub.firstValueIndexes, sub.nullsMask, sub.mvOrdering);
            blockFactory.adjustBreaker(block.ramBytesUsed() - vector.ramBytesUsed() - sub.bytesReserved);
            success = true;
            LongArrayBlock longArrayBlock = block;
            return longArrayBlock;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)vector);
                blockFactory.adjustBreaker(-sub.bytesReserved);
            }
        }
    }

    void writeArrayBlock(StreamOutput out) throws IOException {
        this.writeSubFields(out);
        this.vector.writeArrayVector(this.vector.getPositionCount(), out);
    }

    @Override
    public LongVector asVector() {
        return null;
    }

    @Override
    public long getLong(int valueIndex) {
        return this.vector.getLong(valueIndex);
    }

    @Override
    public LongBlock filter(int ... positions) {
        try (LongBlock.Builder builder = this.blockFactory().newLongBlockBuilder(positions.length);){
            for (int pos : positions) {
                if (this.isNull(pos)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(pos);
                int first = this.getFirstValueIndex(pos);
                if (valueCount == 1) {
                    builder.appendLong(this.getLong(this.getFirstValueIndex(pos)));
                    continue;
                }
                builder.beginPositionEntry();
                for (int c = 0; c < valueCount; ++c) {
                    builder.appendLong(this.getLong(first + c));
                }
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.mvOrdering(this.mvOrdering()).build();
            return longBlock;
        }
    }

    @Override
    public LongBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return this;
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return this;
            }
            return (LongBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (LongBlock.Builder builder = this.blockFactory().newLongBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (!mask.getBoolean(p)) {
                    builder.appendNull();
                    continue;
                }
                int valueCount = this.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int start = this.getFirstValueIndex(p);
                if (valueCount == 1) {
                    builder.appendLong(this.getLong(start));
                    continue;
                }
                int end = start + valueCount;
                builder.beginPositionEntry();
                for (int i = start; i < end; ++i) {
                    builder.appendLong(this.getLong(i));
                }
                builder.endPositionEntry();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    public ReleasableIterator<LongBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        return new LongLookup(this, positions, targetBlockSize);
    }

    @Override
    public ElementType elementType() {
        return ElementType.LONG;
    }

    @Override
    public LongBlock expand() {
        if (this.firstValueIndexes == null) {
            this.incRef();
            return this;
        }
        if (this.nullsMask == null) {
            this.vector.incRef();
            return this.vector.asBlock();
        }
        int expandedPositionCount = this.vector.getPositionCount();
        long bitSetRamUsedEstimate = Math.max((long)this.nullsMask.size(), BlockRamUsageEstimator.sizeOfBitSet(expandedPositionCount));
        this.blockFactory().adjustBreaker(bitSetRamUsedEstimate);
        LongArrayBlock expanded = new LongArrayBlock(this.vector, expandedPositionCount, null, this.shiftNullsToExpandedPositions(), Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
        this.blockFactory().adjustBreaker(expanded.ramBytesUsedOnlyBlock() - bitSetRamUsedEstimate);
        this.vector.incRef();
        return expanded;
    }

    private long ramBytesUsedOnlyBlock() {
        return BASE_RAM_BYTES_USED + BlockRamUsageEstimator.sizeOf(this.firstValueIndexes) + BlockRamUsageEstimator.sizeOfBitSet(this.nullsMask);
    }

    public long ramBytesUsed() {
        return this.ramBytesUsedOnlyBlock() + this.vector.ramBytesUsed();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongBlock) {
            LongBlock that = (LongBlock)obj;
            return LongBlock.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LongBlock.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", mvOrdering=" + String.valueOf((Object)this.mvOrdering()) + ", vector=" + String.valueOf(this.vector) + "]";
    }

    @Override
    public void allowPassingToDifferentDriver() {
        this.vector.allowPassingToDifferentDriver();
    }

    @Override
    public BlockFactory blockFactory() {
        return this.vector.blockFactory();
    }

    @Override
    public void closeInternal() {
        this.blockFactory().adjustBreaker(-this.ramBytesUsedOnlyBlock());
        Releasables.closeExpectNoException((Releasable)this.vector);
    }
}

