/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.AbstractVector;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongLookup;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.LongVectorBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;

final class ConstantLongVector
extends AbstractVector
implements LongVector {
    static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantLongVector.class);
    private final long value;

    ConstantLongVector(long value, int positionCount, BlockFactory blockFactory) {
        super(positionCount, blockFactory);
        this.value = value;
    }

    @Override
    public long getLong(int position) {
        return this.value;
    }

    @Override
    public LongBlock asBlock() {
        return new LongVectorBlock(this);
    }

    @Override
    public LongVector filter(int ... positions) {
        return this.blockFactory().newConstantLongVector(this.value, positions.length);
    }

    @Override
    public LongBlock keepMask(BooleanVector mask) {
        if (this.getPositionCount() == 0) {
            this.incRef();
            return new LongVectorBlock(this);
        }
        if (mask.isConstant()) {
            if (mask.getBoolean(0)) {
                this.incRef();
                return new LongVectorBlock(this);
            }
            return (LongBlock)this.blockFactory().newConstantNullBlock(this.getPositionCount());
        }
        try (LongBlock.Builder builder = this.blockFactory().newLongBlockBuilder(this.getPositionCount());){
            for (int p = 0; p < this.getPositionCount(); ++p) {
                if (mask.getBoolean(p)) {
                    builder.appendLong(this.value);
                    continue;
                }
                builder.appendNull();
            }
            LongBlock longBlock = builder.build();
            return longBlock;
        }
    }

    public ReleasableIterator<LongBlock> lookup(IntBlock positions, ByteSizeValue targetBlockSize) {
        if (positions.getPositionCount() == 0) {
            return ReleasableIterator.empty();
        }
        IntVector positionsVector = positions.asVector();
        if (positionsVector == null) {
            return new LongLookup(this.asBlock(), positions, targetBlockSize);
        }
        int min = positionsVector.min();
        if (min < 0) {
            throw new IllegalArgumentException("invalid position [" + min + "]");
        }
        if (min > this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)((LongBlock)positions.blockFactory().newConstantNullBlock(positions.getPositionCount())));
        }
        if (positionsVector.max() < this.getPositionCount()) {
            return ReleasableIterator.single((Releasable)positions.blockFactory().newConstantLongBlockWith(this.value, positions.getPositionCount()));
        }
        return new LongLookup(this.asBlock(), positions, targetBlockSize);
    }

    @Override
    public ElementType elementType() {
        return ElementType.LONG;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public long ramBytesUsed() {
        return RAM_BYTES_USED;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof LongVector) {
            LongVector that = (LongVector)obj;
            return LongVector.equals(this, that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LongVector.hash(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[positions=" + this.getPositionCount() + ", value=" + this.value + "]";
    }
}

