/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Vector;

abstract class AbstractVectorBuilder
implements Vector.Builder {
    protected int valueCount;
    boolean closed = false;
    protected final BlockFactory blockFactory;
    protected long estimatedBytes;

    protected AbstractVectorBuilder(BlockFactory blockFactory) {
        this.blockFactory = blockFactory;
    }

    protected abstract int valuesLength();

    protected abstract void growValuesArray(int var1);

    protected abstract int elementSize();

    protected final void ensureCapacity() {
        int valuesLength = this.valuesLength();
        if (this.valueCount < valuesLength) {
            return;
        }
        int newSize = AbstractVectorBuilder.calculateNewArraySize(valuesLength);
        this.adjustBreaker((long)(newSize - valuesLength) * (long)this.elementSize());
        this.growValuesArray(newSize);
    }

    static int calculateNewArraySize(int currentSize) {
        return currentSize + (currentSize >> 1);
    }

    protected void adjustBreaker(long deltaBytes) {
        this.blockFactory.adjustBreaker(deltaBytes);
        this.estimatedBytes += deltaBytes;
    }

    protected final void finish() {
        if (this.closed) {
            throw new IllegalStateException("already closed");
        }
    }

    @Override
    public long estimatedBytes() {
        return this.estimatedBytes;
    }

    protected final void built() {
        this.closed = true;
        this.estimatedBytes = 0L;
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.adjustBreaker(-this.estimatedBytes);
            this.extraClose();
        }
    }

    protected void extraClose() {
    }
}

