/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.querydsl.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.esql.core.tree.Location;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.querydsl.query.SingleValueMatchQuery;

public class SingleValueQuery
extends org.elasticsearch.xpack.esql.core.querydsl.query.Query {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(QueryBuilder.class, "esql_single_value", Builder::new);
    private final org.elasticsearch.xpack.esql.core.querydsl.query.Query next;
    private final String field;

    public SingleValueQuery(org.elasticsearch.xpack.esql.core.querydsl.query.Query next, String field) {
        super(next.source());
        this.next = next;
        this.field = field;
    }

    public Builder asBuilder() {
        return new Builder(this.next.asBuilder(), this.field, this.next.source());
    }

    protected String innerToString() {
        return this.next.toString();
    }

    public SingleValueQuery negate(Source source) {
        return new SingleValueQuery(this.next.negate(source), this.field);
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SingleValueQuery other = (SingleValueQuery)((Object)o);
        return Objects.equals(this.next, other.next) && Objects.equals(this.field, other.field);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.next, this.field);
    }

    static void writeOldSource(StreamOutput out, Source source) throws IOException {
        out.writeInt(source.source().getLineNumber());
        out.writeInt(source.source().getColumnNumber());
        out.writeString(source.text());
    }

    static Source readOldSource(StreamInput in) throws IOException {
        int line = in.readInt();
        int column = in.readInt();
        int charPositionInLine = column - 1;
        String text = in.readString();
        return new Source(new Location(line, charPositionInLine), text);
    }

    public static class Builder
    extends AbstractQueryBuilder<Builder> {
        private final QueryBuilder next;
        private final String field;
        private final Source source;

        Builder(QueryBuilder next, String field, Source source) {
            this.next = next;
            this.field = field;
            this.source = source;
        }

        Builder(StreamInput in) throws IOException {
            super(in);
            this.next = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
            this.field = in.readString();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_SINGLE_VALUE_QUERY_SOURCE)) {
                if (in instanceof PlanStreamInput) {
                    PlanStreamInput psi = (PlanStreamInput)in;
                    this.source = Source.readFrom((StreamInput)psi);
                } else {
                    this.source = Source.readEmpty((StreamInput)in);
                }
            } else {
                this.source = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0) ? SingleValueQuery.readOldSource(in) : Source.EMPTY;
            }
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            out.writeNamedWriteable((NamedWriteable)this.next);
            out.writeString(this.field);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_SINGLE_VALUE_QUERY_SOURCE)) {
                this.source.writeTo(out);
            } else if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_12_0)) {
                SingleValueQuery.writeOldSource(out, this.source);
            }
        }

        public QueryBuilder next() {
            return this.next;
        }

        public String field() {
            return this.field;
        }

        public Source source() {
            return this.source;
        }

        public String getWriteableName() {
            return SingleValueQuery.ENTRY.name;
        }

        protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(SingleValueQuery.ENTRY.name);
            builder.field("field", this.field);
            builder.field("next", (ToXContent)this.next, params);
            builder.field("source", this.source.toString());
            builder.endObject();
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }

        protected Query doToQuery(SearchExecutionContext context) throws IOException {
            MappedFieldType ft = context.getFieldType(this.field);
            if (ft == null) {
                return new MatchNoDocsQuery("missing field [" + this.field + "]");
            }
            SingleValueMatchQuery singleValueQuery = new SingleValueMatchQuery(context.getForField(ft, MappedFieldType.FielddataOperation.SEARCH), Warnings.createWarnings((DriverContext.WarningsMode)DriverContext.WarningsMode.COLLECT, (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text()));
            Query rewrite = singleValueQuery.rewrite(context.searcher());
            if (rewrite instanceof MatchAllDocsQuery) {
                return this.next.toQuery(context);
            }
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(this.next.toQuery(context), BooleanClause.Occur.FILTER);
            builder.add(rewrite, BooleanClause.Occur.FILTER);
            return builder.build();
        }

        protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
            QueryBuilder rewritten = this.next.rewrite(queryRewriteContext);
            if (rewritten instanceof MatchNoneQueryBuilder) {
                return rewritten;
            }
            if (rewritten == this.next) {
                return this;
            }
            return new Builder(rewritten, this.field, this.source);
        }

        protected boolean doEquals(Builder other) {
            return this.next.equals(other.next) && this.field.equals(other.field);
        }

        protected int doHashCode() {
            return Objects.hash(this.next, this.field);
        }
    }
}

