/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical.local;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.stats.SearchStats;

public interface LucenePushdownPredicates {
    public static final LucenePushdownPredicates DEFAULT = new LucenePushdownPredicates(){

        @Override
        public boolean hasExactSubfield(FieldAttribute attr) {
            return false;
        }

        @Override
        public boolean isIndexedAndHasDocValues(FieldAttribute attr) {
            return attr.field().isAggregatable();
        }

        @Override
        public boolean isIndexed(FieldAttribute attr) {
            return attr.field().isAggregatable();
        }
    };

    public boolean hasExactSubfield(FieldAttribute var1);

    public boolean isIndexedAndHasDocValues(FieldAttribute var1);

    public boolean isIndexed(FieldAttribute var1);

    default public boolean isPushableFieldAttribute(Expression exp) {
        FieldAttribute fa;
        if (exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).getExactInfo().hasExact() && this.isIndexedAndHasDocValues(fa)) {
            return fa.dataType() != DataType.TEXT && fa.dataType() != DataType.SEMANTIC_TEXT || this.hasExactSubfield(fa);
        }
        return false;
    }

    public static LucenePushdownPredicates from(final SearchStats stats) {
        return new LucenePushdownPredicates(){

            @Override
            public boolean hasExactSubfield(FieldAttribute attr) {
                return stats.hasExactSubfield(attr.name());
            }

            @Override
            public boolean isIndexedAndHasDocValues(FieldAttribute attr) {
                return attr.field().isAggregatable() || stats.isIndexed(attr.name()) && stats.hasDocValues(attr.name());
            }

            @Override
            public boolean isIndexed(FieldAttribute attr) {
                return stats.isIndexed(attr.name());
            }
        };
    }
}

