/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import java.util.Collection;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.BinaryPredicate;
import org.elasticsearch.xpack.esql.core.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.And;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Not;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.optimizer.rules.logical.OptimizerRules;

public final class BooleanSimplification
extends OptimizerRules.OptimizerExpressionRule<ScalarFunction> {
    public BooleanSimplification() {
        super(OptimizerRules.TransformDirection.UP);
    }

    @Override
    public Expression rule(ScalarFunction e) {
        if (e instanceof And || e instanceof Or) {
            return BooleanSimplification.simplifyAndOr((BinaryPredicate)e);
        }
        if (e instanceof Not) {
            return this.simplifyNot((Not)e);
        }
        return e;
    }

    private static Expression simplifyAndOr(BinaryPredicate<?, ?, ?, ?> bc) {
        Expression l = bc.left();
        Expression r = bc.right();
        if (bc instanceof And) {
            List rightSplit;
            if (Literal.TRUE.equals((Object)l)) {
                return r;
            }
            if (Literal.TRUE.equals((Object)r)) {
                return l;
            }
            if (Literal.FALSE.equals((Object)l) || Literal.FALSE.equals((Object)r)) {
                return new Literal(bc.source(), (Object)Boolean.FALSE, DataType.BOOLEAN);
            }
            if (l.semanticEquals(r)) {
                return l;
            }
            List leftSplit = Predicates.splitOr((Expression)l);
            List common = Predicates.inCommon((List)leftSplit, (List)(rightSplit = Predicates.splitOr((Expression)r)));
            if (common.isEmpty()) {
                return bc;
            }
            List lDiff = Predicates.subtract((List)leftSplit, (List)common);
            List rDiff = Predicates.subtract((List)rightSplit, (List)common);
            if (lDiff.isEmpty() || rDiff.isEmpty()) {
                return Predicates.combineOr((List)common);
            }
            Expression combineLeft = Predicates.combineOr((List)lDiff);
            Expression combineRight = Predicates.combineOr((List)rDiff);
            return Predicates.combineOr((List)CollectionUtils.combine((Collection)common, (Object[])new Expression[]{new And(combineLeft.source(), combineLeft, combineRight)}));
        }
        if (bc instanceof Or) {
            List rightSplit;
            if (Literal.TRUE.equals((Object)l) || Literal.TRUE.equals((Object)r)) {
                return new Literal(bc.source(), (Object)Boolean.TRUE, DataType.BOOLEAN);
            }
            if (Literal.FALSE.equals((Object)l)) {
                return r;
            }
            if (Literal.FALSE.equals((Object)r)) {
                return l;
            }
            if (l.semanticEquals(r)) {
                return l;
            }
            List leftSplit = Predicates.splitAnd((Expression)l);
            List common = Predicates.inCommon((List)leftSplit, (List)(rightSplit = Predicates.splitAnd((Expression)r)));
            if (common.isEmpty()) {
                return bc;
            }
            List lDiff = Predicates.subtract((List)leftSplit, (List)common);
            List rDiff = Predicates.subtract((List)rightSplit, (List)common);
            if (lDiff.isEmpty() || rDiff.isEmpty()) {
                return Predicates.combineAnd((List)common);
            }
            Expression combineLeft = Predicates.combineAnd((List)lDiff);
            Expression combineRight = Predicates.combineAnd((List)rDiff);
            return Predicates.combineAnd((List)CollectionUtils.combine((Collection)common, (Object[])new Expression[]{new Or(combineLeft.source(), combineLeft, combineRight)}));
        }
        return bc;
    }

    private Expression simplifyNot(Not n) {
        Expression c = n.field();
        if (Literal.TRUE.semanticEquals(c)) {
            return new Literal(n.source(), (Object)Boolean.FALSE, DataType.BOOLEAN);
        }
        if (Literal.FALSE.semanticEquals(c)) {
            return new Literal(n.source(), (Object)Boolean.TRUE, DataType.BOOLEAN);
        }
        Expression negated = this.maybeSimplifyNegatable(c);
        if (negated != null) {
            return negated;
        }
        if (c instanceof Not) {
            return ((Not)c).field();
        }
        return n;
    }

    protected Expression maybeSimplifyNegatable(Expression e) {
        return null;
    }
}

