/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvg;

public final class MvAvgUnsignedLongEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvAvgUnsignedLongEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvAvg";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            CompensatedSum work = new CompensatedSum();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                if (valueCount == 1) {
                    long value = v.getLong(first);
                    double result = MvAvg.singleUnsignedLong(value);
                    builder.appendDouble(result);
                    continue;
                }
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    long value = v.getLong(i);
                    MvAvg.processUnsignedLong(work, value);
                }
                double result = MvAvg.finish(work, valueCount);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            CompensatedSum work = new CompensatedSum();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                if (valueCount == 1) {
                    long value = v.getLong(first);
                    double result = MvAvg.singleUnsignedLong(value);
                    builder.appendDouble(result);
                    continue;
                }
                int end = first + valueCount;
                for (int i = first; i < end; ++i) {
                    long value = v.getLong(i);
                    MvAvg.processUnsignedLong(work, value);
                }
                double result = MvAvg.finish(work, valueCount);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    @Override
    public Block evalSingleValuedNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            CompensatedSum work = new CompensatedSum();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                assert (valueCount == 1);
                int first = v.getFirstValueIndex(p);
                long value = v.getLong(first);
                double result = MvAvg.singleUnsignedLong(value);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    @Override
    public Block evalSingleValuedNotNullable(Block fieldVal) {
        LongBlock v = (LongBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (DoubleVector.FixedBuilder builder = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            CompensatedSum work = new CompensatedSum();
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                assert (valueCount == 1);
                int first = v.getFirstValueIndex(p);
                long value = v.getLong(first);
                double result = MvAvg.singleUnsignedLong(value);
                builder.appendDouble(result);
            }
            DoubleBlock doubleBlock = builder.build().asBlock();
            return doubleBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvAvgUnsignedLongEvaluator get(DriverContext context) {
            return new MvAvgUnsignedLongEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvAvg[field=" + String.valueOf(this.field) + "]";
        }
    }
}

