/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbstractTrigonometricFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AtanEvaluator;

public class Atan
extends AbstractTrigonometricFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Atan", Atan::new);

    @FunctionInfo(returnType={"double"}, description="Returns the {wikipedia}/Inverse_trigonometric_functions[arctangent] of the input\nnumeric expression as an angle, expressed in radians.", examples={@Example(file="floats", tag="atan")})
    public Atan(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    private Atan(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Atan.ENTRY.name;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory doubleEvaluator(EvalOperator.ExpressionEvaluator.Factory field) {
        return new AtanEvaluator.Factory(this.source(), field);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Atan(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Atan::new, (Object)this.field());
    }

    static double process(double val) {
        return Math.atan(val);
    }
}

