/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.lookup.QueryList;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.enrich.AbstractLookupService;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;

public class EnrichLookupService
extends AbstractLookupService<Request, TransportRequest> {
    public static final String LOOKUP_ACTION_NAME = "indices:data/read/esql/lookup";

    public EnrichLookupService(ClusterService clusterService, SearchService searchService, TransportService transportService, BigArrays bigArrays, BlockFactory blockFactory) {
        super(LOOKUP_ACTION_NAME, ClusterPrivilegeResolver.MONITOR_ENRICH.name(), clusterService, searchService, transportService, bigArrays, blockFactory, TransportRequest::readFrom);
    }

    @Override
    protected TransportRequest transportRequest(Request request, ShardId shardId) {
        return new TransportRequest(request.sessionId, shardId, request.inputDataType, request.matchType, request.matchField, request.inputPage, null, request.extractFields, request.source);
    }

    @Override
    protected QueryList queryList(TransportRequest request, SearchExecutionContext context, Block inputBlock, DataType inputDataType) {
        MappedFieldType fieldType = context.getFieldType(request.matchField);
        EnrichLookupService.validateTypes(inputDataType, fieldType);
        return switch (request.matchType) {
            case "match", "range" -> EnrichLookupService.termQueryList(fieldType, context, inputBlock, inputDataType);
            case "geo_match" -> QueryList.geoShapeQueryList((MappedFieldType)fieldType, (SearchExecutionContext)context, (Block)inputBlock);
            default -> throw new EsqlIllegalArgumentException("illegal match type " + request.matchType);
        };
    }

    private static void validateTypes(DataType inputDataType, MappedFieldType fieldType) {
        RangeFieldMapper.RangeFieldType rangeType;
        if (fieldType instanceof RangeFieldMapper.RangeFieldType && !EnrichLookupService.rangeTypesCompatible((rangeType = (RangeFieldMapper.RangeFieldType)fieldType).rangeType(), inputDataType)) {
            throw new EsqlIllegalArgumentException("ENRICH range and input types are incompatible: range[" + String.valueOf(rangeType.rangeType()) + "], input[" + String.valueOf(inputDataType) + "]");
        }
    }

    private static boolean rangeTypesCompatible(RangeType rangeType, DataType inputDataType) {
        if (inputDataType.noText() == DataType.KEYWORD) {
            return true;
        }
        return switch (rangeType) {
            case RangeType.INTEGER, RangeType.LONG -> inputDataType.isWholeNumber();
            case RangeType.IP -> {
                if (inputDataType == DataType.IP) {
                    yield true;
                }
                yield false;
            }
            case RangeType.DATE -> inputDataType.isDate();
            default -> rangeType.isNumeric() == inputDataType.isNumeric();
        };
    }

    protected static class TransportRequest
    extends AbstractLookupService.TransportRequest {
        private final String matchType;
        private final String matchField;

        TransportRequest(String sessionId, ShardId shardId, DataType inputDataType, String matchType, String matchField, Page inputPage, Page toRelease, List<NamedExpression> extractFields, Source source) {
            super(sessionId, shardId, inputDataType, inputPage, toRelease, extractFields, source);
            this.matchType = matchType;
            this.matchField = matchField;
        }

        static TransportRequest readFrom(StreamInput in, BlockFactory blockFactory) throws IOException {
            Page inputPage;
            TaskId parentTaskId = TaskId.readFromStream((StreamInput)in);
            String sessionId = in.readString();
            ShardId shardId = new ShardId(in);
            DataType inputDataType = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? DataType.fromTypeName((String)in.readString()) : null;
            String matchType = in.readString();
            String matchField = in.readString();
            try (BlockStreamInput bsi = new BlockStreamInput(in, blockFactory);){
                inputPage = new Page((StreamInput)bsi);
            }
            PlanStreamInput planIn = new PlanStreamInput(in, in.namedWriteableRegistry(), null);
            List extractFields = planIn.readNamedWriteableCollectionAsList(NamedExpression.class);
            Source source = Source.EMPTY;
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ENRICH_RUNTIME_WARNINGS)) {
                source = Source.readFrom((StreamInput)planIn);
            }
            TransportRequest result = new TransportRequest(sessionId, shardId, inputDataType, matchType, matchField, inputPage, inputPage, extractFields, source);
            result.setParentTask(parentTaskId);
            return result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sessionId);
            out.writeWriteable((Writeable)this.shardId);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
                out.writeString(this.inputDataType.typeName());
            }
            out.writeString(this.matchType);
            out.writeString(this.matchField);
            out.writeWriteable((Writeable)this.inputPage);
            PlanStreamOutput planOut = new PlanStreamOutput(out, null);
            planOut.writeNamedWriteableCollection(this.extractFields);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ENRICH_RUNTIME_WARNINGS)) {
                this.source.writeTo((StreamOutput)planOut);
            }
        }

        @Override
        protected String extraDescription() {
            return " ,match_type=" + this.matchType + " ,match_field=" + this.matchField;
        }
    }

    public static class Request
    extends AbstractLookupService.Request {
        private final String matchType;
        private final String matchField;

        Request(String sessionId, String index, DataType inputDataType, String matchType, String matchField, Page inputPage, List<NamedExpression> extractFields, Source source) {
            super(sessionId, index, inputDataType, inputPage, extractFields, source);
            this.matchType = matchType;
            this.matchField = matchField;
        }
    }
}

