/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb;

import java.time.Instant;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.xpack.logsdb.LogsDBPlugin;

final class LogsdbIndexModeSettingsProvider
implements IndexSettingProvider {
    private static final String LOGS_PATTERN = "logs-*-*";
    private volatile boolean isLogsdbEnabled;

    LogsdbIndexModeSettingsProvider(Settings settings) {
        this.isLogsdbEnabled = (Boolean)LogsDBPlugin.CLUSTER_LOGSDB_ENABLED.get(settings);
    }

    void updateClusterIndexModeLogsdbEnabled(boolean isLogsdbEnabled) {
        this.isLogsdbEnabled = isLogsdbEnabled;
    }

    public Settings getAdditionalIndexSettings(String indexName, String dataStreamName, IndexMode templateIndexMode, Metadata metadata, Instant resolvedAt, Settings settings, List<CompressedXContent> combinedTemplateMappings) {
        return this.getLogsdbModeSetting(dataStreamName, settings);
    }

    Settings getLogsdbModeSetting(String dataStreamName, Settings settings) {
        if (this.isLogsdbEnabled && dataStreamName != null && this.resolveIndexMode(settings.get(IndexSettings.MODE.getKey())) == null && LogsdbIndexModeSettingsProvider.matchesLogsPattern(dataStreamName)) {
            return Settings.builder().put("index.mode", IndexMode.LOGSDB.getName()).build();
        }
        return Settings.EMPTY;
    }

    private static boolean matchesLogsPattern(String name) {
        return Regex.simpleMatch((String)LOGS_PATTERN, (String)name);
    }

    private IndexMode resolveIndexMode(String mode) {
        return mode != null ? Enum.valueOf(IndexMode.class, mode.toUpperCase(Locale.ROOT)) : null;
    }
}

