/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.eql.expression.function.scalar.string.IndexOfFunctionProcessor;
import org.elasticsearch.xpack.ql.execution.search.QlSourceBuilder;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class IndexOfFunctionPipe
extends Pipe {
    private final Pipe input;
    private final Pipe substring;
    private final Pipe start;
    private final boolean caseInsensitive;

    public IndexOfFunctionPipe(Source source, Expression expression, Pipe input, Pipe substring, Pipe start, boolean caseInsensitive) {
        super(source, expression, Arrays.asList(input, substring, start));
        this.input = input;
        this.substring = substring;
        this.start = start;
        this.caseInsensitive = caseInsensitive;
    }

    public final Pipe replaceChildren(List<Pipe> newChildren) {
        return this.replaceChildren(newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newInput = this.input.resolveAttributes(resolver);
        Pipe newSubstring = this.substring.resolveAttributes(resolver);
        Pipe newStart = this.start.resolveAttributes(resolver);
        if (newInput == this.input && newSubstring == this.substring && newStart == this.start) {
            return this;
        }
        return this.replaceChildren(newInput, newSubstring, newStart);
    }

    public boolean supportedByAggsOnlyQuery() {
        return this.input.supportedByAggsOnlyQuery() && this.substring.supportedByAggsOnlyQuery() && this.start.supportedByAggsOnlyQuery();
    }

    public boolean resolved() {
        return this.input.resolved() && this.substring.resolved() && this.start.resolved();
    }

    protected IndexOfFunctionPipe replaceChildren(Pipe newInput, Pipe newSubstring, Pipe newStart) {
        return new IndexOfFunctionPipe(this.source(), this.expression(), newInput, newSubstring, newStart, this.caseInsensitive);
    }

    public final void collectFields(QlSourceBuilder sourceBuilder) {
        this.input.collectFields(sourceBuilder);
        this.substring.collectFields(sourceBuilder);
        this.start.collectFields(sourceBuilder);
    }

    protected NodeInfo<IndexOfFunctionPipe> info() {
        return NodeInfo.create((Node)this, IndexOfFunctionPipe::new, (Object)this.expression(), (Object)this.input, (Object)this.substring, (Object)this.start, (Object)this.caseInsensitive);
    }

    public IndexOfFunctionProcessor asProcessor() {
        return new IndexOfFunctionProcessor(this.input.asProcessor(), this.substring.asProcessor(), this.start.asProcessor(), this.caseInsensitive);
    }

    public Pipe input() {
        return this.input;
    }

    public Pipe substring() {
        return this.substring;
    }

    public Pipe start() {
        return this.start;
    }

    protected boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public int hashCode() {
        return Objects.hash(this.input, this.substring, this.start, this.caseInsensitive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        IndexOfFunctionPipe other = (IndexOfFunctionPipe)((Object)obj);
        return Objects.equals(this.input(), other.input()) && Objects.equals(this.substring(), other.substring()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.isCaseInsensitive(), other.isCaseInsensitive());
    }
}

