/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.movingPercentiles;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.movingPercentiles.MovingPercentilesPipelineAggregator;

public class MovingPercentilesPipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<MovingPercentilesPipelineAggregationBuilder> {
    public static final String NAME = "moving_percentiles";
    private static final ParseField WINDOW = new ParseField("window", new String[0]);
    private static final ParseField SHIFT = new ParseField("shift", new String[0]);
    public static final ConstructingObjectParser<MovingPercentilesPipelineAggregationBuilder, String> PARSER = new ConstructingObjectParser("moving_percentiles", false, (args, name) -> new MovingPercentilesPipelineAggregationBuilder((String)name, (String)args[0], (Integer)args[1]));
    private final int window;
    private int shift;

    public MovingPercentilesPipelineAggregationBuilder(String name, String bucketsPath, int window) {
        super(name, NAME, new String[]{bucketsPath});
        if (window <= 0) {
            throw new IllegalArgumentException("[" + WINDOW.getPreferredName() + "] must be a positive, non-zero integer.");
        }
        this.window = window;
    }

    public MovingPercentilesPipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.window = in.readVInt();
        this.shift = in.readInt();
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.window);
        out.writeInt(this.shift);
    }

    public int getWindow() {
        return this.window;
    }

    public int getShift() {
        return this.shift;
    }

    public void setShift(int shift) {
        this.shift = shift;
    }

    protected PipelineAggregator createInternal(Map<String, Object> metaData) {
        return new MovingPercentilesPipelineAggregator(this.name, this.bucketsPaths, this.getWindow(), this.getShift(), metaData);
    }

    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        if (this.bucketsPaths.length != 1) {
            context.addBucketPathValidationError("must contain a single entry for aggregation [" + this.name + "]");
        }
        context.validateParentAggSequentiallyOrdered(NAME, this.name);
    }

    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(BUCKETS_PATH_FIELD.getPreferredName(), this.bucketsPaths[0]);
        builder.field(WINDOW.getPreferredName(), this.window);
        builder.field(SHIFT.getPreferredName(), this.shift);
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.window, this.shift);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MovingPercentilesPipelineAggregationBuilder other = (MovingPercentilesPipelineAggregationBuilder)((Object)obj);
        return this.window == other.window && this.shift == other.shift;
    }

    public String getWriteableName() {
        return NAME;
    }

    protected boolean overrideBucketsPath() {
        return true;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_9_0;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), WINDOW);
        PARSER.declareInt(MovingPercentilesPipelineAggregationBuilder::setShift, SHIFT);
    }
}

