/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.metrics.AbstractHistoBackedTDigestPercentilesAggregator;

public class HistoBackedTDigestPercentileRanksAggregator
extends AbstractHistoBackedTDigestPercentilesAggregator {
    public HistoBackedTDigestPercentileRanksAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] percents, double compression, TDigestExecutionHint executionHint, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, config, context, parent, percents, compression, executionHint, keyed, formatter, metadata);
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalTDigestPercentileRanks(this.name, this.keys, state, this.keyed, this.formatter, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return InternalTDigestPercentileRanks.empty((String)this.name, (double[])this.keys, (double)this.compression, (TDigestExecutionHint)this.executionHint, (boolean)this.keyed, (DocValueFormat)this.formatter, (Map)this.metadata());
    }

    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalTDigestPercentileRanks.percentileRank((TDigestState)state, (double)Double.parseDouble(name));
    }
}

