/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.syncjob;

import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.connector.Connector;
import org.elasticsearch.xpack.application.connector.ConnectorFiltering;
import org.elasticsearch.xpack.application.connector.ConnectorSyncStatus;
import org.elasticsearch.xpack.application.connector.filtering.FilteringRules;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJob;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobInvalidStatusTransitionException;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobSearchResult;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobStateMachine;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobTriggerMethod;
import org.elasticsearch.xpack.application.connector.syncjob.ConnectorSyncJobType;
import org.elasticsearch.xpack.application.connector.syncjob.action.PostConnectorSyncJobAction;
import org.elasticsearch.xpack.application.connector.syncjob.action.UpdateConnectorSyncJobIngestionStatsAction;

public class ConnectorSyncJobIndexService {
    private static final Long ZERO = 0L;
    private final Client client;
    public static final String CONNECTOR_SYNC_JOB_INDEX_NAME = ".elastic-connectors-sync-jobs-v1";

    public ConnectorSyncJobIndexService(Client client) {
        this.client = client;
    }

    public void createConnectorSyncJob(PostConnectorSyncJobAction.Request request, ActionListener<PostConnectorSyncJobAction.Response> listener) {
        String connectorId = request.getId();
        ConnectorSyncJobType jobType = Objects.requireNonNullElse(request.getJobType(), ConnectorSyncJob.DEFAULT_JOB_TYPE);
        try {
            this.getSyncJobConnectorInfo(connectorId, jobType, (ActionListener<Connector>)listener.delegateFailure((l, connector) -> {
                if (Strings.isNullOrEmpty((String)connector.getIndexName())) {
                    l.onFailure((Exception)new ElasticsearchStatusException("Cannot start a sync for connector [" + connectorId + "] with no index attached. Set the [index_name] property for the connector to enable syncing data.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                if (Strings.isNullOrEmpty((String)connector.getServiceType())) {
                    l.onFailure((Exception)new ElasticsearchStatusException("Cannot start a sync for connector [" + connectorId + "] with [service_type] not defined. Set the service type of your connector before starting the sync.", RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
                Instant now = Instant.now();
                ConnectorSyncJobTriggerMethod triggerMethod = Objects.requireNonNullElse(request.getTriggerMethod(), ConnectorSyncJob.DEFAULT_TRIGGER_METHOD);
                try {
                    IndexRequest indexRequest = (IndexRequest)new IndexRequest(CONNECTOR_SYNC_JOB_INDEX_NAME).opType(DocWriteRequest.OpType.INDEX).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                    ConnectorSyncJob syncJob = new ConnectorSyncJob.Builder().setJobType(jobType).setTriggerMethod(triggerMethod).setStatus(ConnectorSyncJob.DEFAULT_INITIAL_STATUS).setConnector((Connector)connector).setCreatedAt(now).setLastSeen(now).setTotalDocumentCount(ZERO).setIndexedDocumentCount(ZERO).setIndexedDocumentVolume(ZERO).setDeletedDocumentCount(ZERO).build();
                    indexRequest.source(syncJob.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
                    this.client.index(indexRequest, l.delegateFailureAndWrap((ll, indexResponse) -> ll.onResponse((Object)new PostConnectorSyncJobAction.Response(indexResponse.getId()))));
                }
                catch (IOException e) {
                    l.onFailure((Exception)e);
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteConnectorSyncJob(String connectorSyncJobId, ActionListener<DeleteResponse> listener) {
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(CONNECTOR_SYNC_JOB_INDEX_NAME).id(connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            this.client.delete(deleteRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<DeleteResponse, DeleteResponse>(connectorSyncJobId, listener, (l, deleteResponse) -> {
                if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)((Object)new ResourceNotFoundException(connectorSyncJobId, new Object[0])));
                    return;
                }
                l.onResponse(deleteResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void checkInConnectorSyncJob(String connectorSyncJobId, ActionListener<UpdateResponse> listener) {
        Instant newLastSeen = Instant.now();
        UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(Map.of(ConnectorSyncJob.LAST_SEEN_FIELD.getPreferredName(), newLastSeen));
        try {
            this.client.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<UpdateResponse, UpdateResponse>(connectorSyncJobId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)((Object)new ResourceNotFoundException(connectorSyncJobId, new Object[0])));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void getConnectorSyncJob(String connectorSyncJobId, ActionListener<ConnectorSyncJobSearchResult> listener) {
        GetRequest getRequest = new GetRequest(CONNECTOR_SYNC_JOB_INDEX_NAME).id(connectorSyncJobId).realtime(true);
        try {
            this.client.get(getRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<GetResponse, ConnectorSyncJobSearchResult>(connectorSyncJobId, listener, (l, getResponse) -> {
                if (!getResponse.isExists()) {
                    l.onFailure((Exception)((Object)new ResourceNotFoundException(connectorSyncJobId, new Object[0])));
                    return;
                }
                try {
                    ConnectorSyncJobSearchResult syncJobSearchResult = new ConnectorSyncJobSearchResult.Builder().setId(getResponse.getId()).setResultBytes(getResponse.getSourceAsBytesRef()).setResultMap(getResponse.getSourceAsMap()).build();
                    l.onResponse((Object)syncJobSearchResult);
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void cancelConnectorSyncJob(String connectorSyncJobId, ActionListener<UpdateResponse> listener) {
        try {
            this.getConnectorSyncJob(connectorSyncJobId, (ActionListener<ConnectorSyncJobSearchResult>)listener.delegateFailure((getSyncJobListener, syncJobSearchResult) -> {
                Map<String, Instant> syncJobFieldsToUpdate;
                Instant now = Instant.now();
                ConnectorSyncStatus prevStatus = this.getConnectorSyncJobStatusFromSearchResult((ConnectorSyncJobSearchResult)syncJobSearchResult);
                try {
                    if (ConnectorSyncStatus.PENDING.equals((Object)prevStatus) || ConnectorSyncStatus.SUSPENDED.equals((Object)prevStatus)) {
                        nextStatus = ConnectorSyncStatus.CANCELED;
                        ConnectorSyncJobStateMachine.assertValidStateTransition(prevStatus, nextStatus);
                        syncJobFieldsToUpdate = Map.of(ConnectorSyncJob.STATUS_FIELD.getPreferredName(), nextStatus.toString(), ConnectorSyncJob.CANCELATION_REQUESTED_AT_FIELD.getPreferredName(), now, ConnectorSyncJob.CANCELED_AT_FIELD.getPreferredName(), now, ConnectorSyncJob.COMPLETED_AT_FIELD.getPreferredName(), now);
                    } else {
                        nextStatus = ConnectorSyncStatus.CANCELING;
                        ConnectorSyncJobStateMachine.assertValidStateTransition(prevStatus, nextStatus);
                        syncJobFieldsToUpdate = Map.of(ConnectorSyncJob.STATUS_FIELD.getPreferredName(), nextStatus.toString(), ConnectorSyncJob.CANCELATION_REQUESTED_AT_FIELD.getPreferredName(), now);
                    }
                }
                catch (ConnectorSyncJobInvalidStatusTransitionException e) {
                    getSyncJobListener.onFailure((Exception)new ElasticsearchStatusException(e.getMessage(), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
                    return;
                }
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(syncJobFieldsToUpdate);
                this.client.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener(connectorSyncJobId, listener, (indexNotFoundListener, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        indexNotFoundListener.onFailure((Exception)((Object)new ResourceNotFoundException(connectorSyncJobId, new Object[0])));
                        return;
                    }
                    indexNotFoundListener.onResponse(updateResponse);
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void listConnectorSyncJobs(int from, int size, String connectorId, ConnectorSyncStatus syncStatus, List<ConnectorSyncJobType> jobTypeList, final ActionListener<ConnectorSyncJobsResult> listener) {
        try {
            QueryBuilder query = ConnectorSyncJobIndexService.buildListQuery(connectorId, syncStatus, jobTypeList);
            SearchSourceBuilder searchSource = new SearchSourceBuilder().from(from).size(size).query(query).fetchSource(true).sort(ConnectorSyncJob.CREATED_AT_FIELD.getPreferredName(), SortOrder.DESC);
            SearchRequest searchRequest = new SearchRequest(new String[]{CONNECTOR_SYNC_JOB_INDEX_NAME}).source(searchSource);
            this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

                public void onResponse(SearchResponse searchResponse) {
                    try {
                        listener.onResponse((Object)ConnectorSyncJobIndexService.this.mapSearchResponseToConnectorSyncJobsList(searchResponse));
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    if (e instanceof IndexNotFoundException) {
                        listener.onResponse((Object)new ConnectorSyncJobsResult(Collections.emptyList(), 0L));
                        return;
                    }
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static QueryBuilder buildListQuery(String connectorId, ConnectorSyncStatus syncStatus, List<ConnectorSyncJobType> jobTypeList) {
        boolean usesFilter = Stream.of(new Object[]{connectorId, syncStatus, jobTypeList}).anyMatch(Objects::nonNull);
        BoolQueryBuilder boolFilterQueryBuilder = new BoolQueryBuilder();
        if (usesFilter) {
            if (Objects.nonNull(connectorId)) {
                TermQueryBuilder connectorIdQuery = new TermQueryBuilder(ConnectorSyncJob.CONNECTOR_FIELD.getPreferredName() + "." + Connector.ID_FIELD.getPreferredName(), connectorId);
                boolFilterQueryBuilder.must().add(connectorIdQuery);
            }
            if (Objects.nonNull((Object)syncStatus)) {
                TermQueryBuilder syncStatusQuery = new TermQueryBuilder(ConnectorSyncJob.STATUS_FIELD.getPreferredName(), syncStatus.toString());
                boolFilterQueryBuilder.must().add(syncStatusQuery);
            }
            if (!(jobTypeList == null || jobTypeList.isEmpty())) {
                TermsQueryBuilder syncJobTypeQuery = new TermsQueryBuilder(ConnectorSyncJob.JOB_TYPE_FIELD.getPreferredName(), jobTypeList.stream().map(ConnectorSyncJobType::toString).toList());
                boolFilterQueryBuilder.must().add(syncJobTypeQuery);
            }
        }
        return usesFilter ? boolFilterQueryBuilder : new MatchAllQueryBuilder();
    }

    private ConnectorSyncJobsResult mapSearchResponseToConnectorSyncJobsList(SearchResponse searchResponse) {
        List<ConnectorSyncJobSearchResult> connectorSyncJobs = Arrays.stream(searchResponse.getHits().getHits()).map(ConnectorSyncJobIndexService::hitToConnectorSyncJob).toList();
        return new ConnectorSyncJobsResult(connectorSyncJobs, (int)searchResponse.getHits().getTotalHits().value);
    }

    private static ConnectorSyncJobSearchResult hitToConnectorSyncJob(SearchHit searchHit) {
        return new ConnectorSyncJobSearchResult.Builder().setId(searchHit.getId()).setResultBytes(searchHit.getSourceRef()).setResultMap(searchHit.getSourceAsMap()).build();
    }

    public void updateConnectorSyncJobIngestionStats(UpdateConnectorSyncJobIngestionStatsAction.Request request, ActionListener<UpdateResponse> listener) {
        String syncJobId = request.getConnectorSyncJobId();
        HashMap<String, Long> fieldsToUpdate = new HashMap<String, Long>(Map.of(ConnectorSyncJob.DELETED_DOCUMENT_COUNT_FIELD.getPreferredName(), request.getDeletedDocumentCount(), ConnectorSyncJob.INDEXED_DOCUMENT_COUNT_FIELD.getPreferredName(), request.getIndexedDocumentCount(), ConnectorSyncJob.INDEXED_DOCUMENT_VOLUME_FIELD.getPreferredName(), request.getIndexedDocumentVolume()));
        if (Objects.nonNull(request.getTotalDocumentCount())) {
            fieldsToUpdate.put(ConnectorSyncJob.TOTAL_DOCUMENT_COUNT_FIELD.getPreferredName(), request.getTotalDocumentCount());
        }
        Instant lastSeen = Objects.nonNull(request.getLastSeen()) ? request.getLastSeen() : Instant.now();
        fieldsToUpdate.put(ConnectorSyncJob.LAST_SEEN_FIELD.getPreferredName(), (Long)((Object)lastSeen));
        Map<String, Object> metadata = request.getMetadata();
        if (Objects.nonNull(metadata)) {
            fieldsToUpdate.put(ConnectorSyncJob.METADATA_FIELD.getPreferredName(), (Long)((Object)metadata));
        }
        UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, syncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(fieldsToUpdate);
        try {
            this.client.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener<UpdateResponse, UpdateResponse>(syncJobId, listener, (l, updateResponse) -> {
                if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                    l.onFailure((Exception)((Object)new ResourceNotFoundException(syncJobId, new Object[0])));
                    return;
                }
                l.onResponse(updateResponse);
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private ConnectorSyncStatus getConnectorSyncJobStatusFromSearchResult(ConnectorSyncJobSearchResult searchResult) {
        return ConnectorSyncStatus.connectorSyncStatus((String)searchResult.getResultMap().get(ConnectorSyncJob.STATUS_FIELD.getPreferredName()));
    }

    private void getSyncJobConnectorInfo(final String connectorId, final ConnectorSyncJobType jobType, final ActionListener<Connector> listener) {
        try {
            GetRequest request = new GetRequest(".elastic-connectors-v1", connectorId);
            this.client.get(request, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    boolean connectorDoesNotExist;
                    boolean bl = connectorDoesNotExist = !response.isExists();
                    if (connectorDoesNotExist) {
                        this.onFailure((Exception)((Object)new ResourceNotFoundException("Connector with id '" + connectorId + "' does not exist.", new Object[0])));
                        return;
                    }
                    try {
                        Connector connector = Connector.fromXContentBytes(response.getSourceAsBytesRef(), connectorId, XContentType.JSON);
                        String targetIndexName = jobType == ConnectorSyncJobType.ACCESS_CONTROL ? connector.getAccessControlIndexName() : connector.getIndexName();
                        Connector syncJobConnector = new Connector.Builder().setConnectorId(connector.getConnectorId()).setSyncJobFiltering(ConnectorSyncJobIndexService.this.transformConnectorFilteringToSyncJobRepresentation(connector.getFiltering())).setIndexName(targetIndexName).setLanguage(connector.getLanguage()).setPipeline(connector.getPipeline()).setServiceType(connector.getServiceType()).setConfiguration(connector.getConfiguration()).build();
                        listener.onResponse((Object)syncJobConnector);
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    FilteringRules transformConnectorFilteringToSyncJobRepresentation(List<ConnectorFiltering> connectorFiltering) {
        return Optional.ofNullable(connectorFiltering).filter(list -> !list.isEmpty()).map(list -> ((ConnectorFiltering)list.get(0)).getActive()).orElse(null);
    }

    public void updateConnectorSyncJobError(String connectorSyncJobId, String error, ActionListener<UpdateResponse> listener) {
        try {
            this.getConnectorSyncJob(connectorSyncJobId, (ActionListener<ConnectorSyncJobSearchResult>)listener.delegateFailure((getSyncJobListener, syncJobSearchResult) -> {
                ConnectorSyncStatus prevStatus = this.getConnectorSyncJobStatusFromSearchResult((ConnectorSyncJobSearchResult)syncJobSearchResult);
                ConnectorSyncStatus nextStatus = ConnectorSyncStatus.ERROR;
                try {
                    ConnectorSyncJobStateMachine.assertValidStateTransition(prevStatus, nextStatus);
                }
                catch (ConnectorSyncJobInvalidStatusTransitionException e) {
                    getSyncJobListener.onFailure((Exception)new ElasticsearchStatusException(e.getMessage(), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
                    return;
                }
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(Map.of(ConnectorSyncJob.ERROR_FIELD.getPreferredName(), error, ConnectorSyncJob.STATUS_FIELD.getPreferredName(), nextStatus.toString()));
                this.client.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener(connectorSyncJobId, listener, (indexNotFoundListener, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        indexNotFoundListener.onFailure((Exception)((Object)new ResourceNotFoundException(connectorSyncJobId, new Object[0])));
                        return;
                    }
                    indexNotFoundListener.onResponse(updateResponse);
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteAllSyncJobsByConnectorId(String connectorId, ActionListener<BulkByScrollResponse> listener) {
        DeleteByQueryRequest deleteByQueryRequest = ((DeleteByQueryRequest)new DeleteByQueryRequest(new String[]{CONNECTOR_SYNC_JOB_INDEX_NAME}).setQuery((QueryBuilder)new TermQueryBuilder(ConnectorSyncJob.CONNECTOR_FIELD.getPreferredName() + "." + Connector.ID_FIELD.getPreferredName(), connectorId)).setRefresh(true)).setIndicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)false, (boolean)false));
        this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, listener.delegateFailureAndWrap((l, r) -> {
            List bulkDeleteFailures = r.getBulkFailures();
            if (!bulkDeleteFailures.isEmpty()) {
                l.onFailure((Exception)new ElasticsearchException("Error deleting sync jobs associated with connector [" + connectorId + "] " + bulkDeleteFailures.stream().map(BulkItemResponse.Failure::getMessage).collect(Collectors.joining("\n")), new Object[0]));
            }
            l.onResponse(r);
        }));
    }

    public void claimConnectorSyncJob(String connectorSyncJobId, String workerHostname, Object syncCursor, ActionListener<UpdateResponse> listener) {
        try {
            this.getConnectorSyncJob(connectorSyncJobId, (ActionListener<ConnectorSyncJobSearchResult>)listener.delegateFailure((getSyncJobListener, syncJobSearchResult) -> {
                HashMap<String, Object> document = new HashMap<String, Object>();
                document.put(ConnectorSyncJob.WORKER_HOSTNAME_FIELD.getPreferredName(), workerHostname);
                document.put(ConnectorSyncJob.STATUS_FIELD.getPreferredName(), ConnectorSyncStatus.IN_PROGRESS.toString());
                document.put(ConnectorSyncJob.LAST_SEEN_FIELD.getPreferredName(), Instant.now());
                document.put(ConnectorSyncJob.STARTED_AT_FIELD.getPreferredName(), Instant.now());
                if (syncCursor != null) {
                    document.put(ConnectorSyncJob.CONNECTOR_FIELD.getPreferredName(), Map.of(Connector.SYNC_CURSOR_FIELD.getPreferredName(), syncCursor));
                }
                UpdateRequest updateRequest = new UpdateRequest(CONNECTOR_SYNC_JOB_INDEX_NAME, connectorSyncJobId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).doc(document);
                this.client.update(updateRequest, new DelegatingIndexNotFoundOrDocumentMissingActionListener(connectorSyncJobId, listener, (indexNotFoundListener, updateResponse) -> {
                    if (updateResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                        indexNotFoundListener.onFailure((Exception)((Object)new ResourceNotFoundException(connectorSyncJobId, new Object[0])));
                        return;
                    }
                    indexNotFoundListener.onResponse(updateResponse);
                }));
            }));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    static class DelegatingIndexNotFoundOrDocumentMissingActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final BiConsumer<ActionListener<R>, T> bc;
        private final String connectorSyncJobId;

        DelegatingIndexNotFoundOrDocumentMissingActionListener(String connectorSyncJobId, ActionListener<R> delegate, BiConsumer<ActionListener<R>, T> bc) {
            super(delegate);
            this.bc = bc;
            this.connectorSyncJobId = connectorSyncJobId;
        }

        public void onResponse(T t) {
            this.bc.accept((ActionListener<R>)this.delegate, (ActionListener)t);
        }

        public void onFailure(Exception e) {
            Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
            if (cause instanceof IndexNotFoundException || cause instanceof DocumentMissingException) {
                this.delegate.onFailure((Exception)((Object)new ResourceNotFoundException("connector sync job [" + this.connectorSyncJobId + "] not found", new Object[0])));
                return;
            }
            this.delegate.onFailure(e);
        }
    }

    public record ConnectorSyncJobsResult(List<ConnectorSyncJobSearchResult> connectorSyncJobs, long totalResults) {
    }
}

