/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.action.ConnectorUpdateActionResponse;
import org.elasticsearch.xpack.application.connector.action.UpdateConnectorNativeAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestUpdateConnectorNativeAction
extends BaseRestHandler {
    private static final String CONNECTOR_ID_PARAM = "connector_id";

    public String getName() {
        return "connector_update_native_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_connector/{connector_id}/_native"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        try (XContentParser parser = restRequest.contentParser();){
            UpdateConnectorNativeAction.Request request = UpdateConnectorNativeAction.Request.fromXContent(parser, restRequest.param(CONNECTOR_ID_PARAM));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute(UpdateConnectorNativeAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel, ConnectorUpdateActionResponse::status));
            return restChannelConsumer;
        }
    }
}

