/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.aggregations.metric;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public abstract class ArrayValuesSource<VS extends ValuesSource> {
    protected final MultiValueMode multiValueMode;
    protected String[] names;
    protected VS[] values;

    private ArrayValuesSource(Map<String, ?> valuesSources, MultiValueMode multiValueMode) {
        if (valuesSources != null) {
            this.names = valuesSources.keySet().toArray(new String[0]);
        }
        this.multiValueMode = multiValueMode;
    }

    public boolean needsScores() {
        boolean needsScores = false;
        for (VS value : this.values) {
            needsScores |= value.needsScores();
        }
        return needsScores;
    }

    public String[] fieldNames() {
        return this.names;
    }

    public static class GeoPointValuesSource
    extends ArrayValuesSource<ValuesSource.GeoPoint> {
        public GeoPointValuesSource(Map<String, ValuesSource.GeoPoint> valuesSources, MultiValueMode multiValueMode) {
            super(valuesSources, multiValueMode);
            this.values = (ValuesSource[])valuesSources.values().toArray(new ValuesSource.GeoPoint[0]);
        }
    }

    public static class BytesArrayValuesSource
    extends ArrayValuesSource<ValuesSource.Bytes> {
        public BytesArrayValuesSource(Map<String, ValuesSource.Bytes> valuesSources, MultiValueMode multiValueMode) {
            super(valuesSources, multiValueMode);
            this.values = (ValuesSource[])valuesSources.values().toArray(new ValuesSource.Bytes[0]);
        }

        public Object getField(int ordinal, LeafReaderContext ctx) throws IOException {
            return ((ValuesSource.Bytes[])this.values)[ordinal].bytesValues(ctx);
        }
    }

    public static class NumericArrayValuesSource
    extends ArrayValuesSource<ValuesSource.Numeric> {
        public NumericArrayValuesSource(Map<String, ValuesSource.Numeric> valuesSources, MultiValueMode multiValueMode) {
            super(valuesSources, multiValueMode);
            this.values = valuesSources != null ? (ValuesSource[])valuesSources.values().toArray(new ValuesSource.Numeric[0]) : new ValuesSource.Numeric[0];
        }

        public NumericDoubleValues getField(int ordinal, LeafReaderContext ctx) throws IOException {
            if (ordinal > this.names.length) {
                throw new IndexOutOfBoundsException("ValuesSource array index " + ordinal + " out of bounds");
            }
            return this.multiValueMode.select(((ValuesSource.Numeric[])this.values)[ordinal].doubleValues(ctx));
        }
    }
}

