/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public abstract class AbstractCreateApiKeyRequest
extends ActionRequest {
    protected final String id;
    protected String name;
    protected TimeValue expiration;
    protected Map<String, Object> metadata;
    protected List<RoleDescriptor> roleDescriptors = Collections.emptyList();
    protected WriteRequest.RefreshPolicy refreshPolicy;

    public AbstractCreateApiKeyRequest() {
        this.id = UUIDs.base64UUID();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public abstract ApiKey.Type getType();

    public TimeValue getExpiration() {
        return this.expiration;
    }

    public List<RoleDescriptor> getRoleDescriptors() {
        return this.roleDescriptors;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy, "refresh policy may not be null");
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.name)) {
            validationException = ValidateActions.addValidationError((String)"api key name is required", validationException);
        } else {
            if (this.name.length() > 256) {
                validationException = ValidateActions.addValidationError((String)"api key name may not be more than 256 characters long", (ActionRequestValidationException)validationException);
            }
            if (!this.name.equals(this.name.trim())) {
                validationException = ValidateActions.addValidationError((String)"api key name may not begin or end with whitespace", (ActionRequestValidationException)validationException);
            }
            if (this.name.startsWith("_")) {
                validationException = ValidateActions.addValidationError((String)"api key name may not begin with an underscore", (ActionRequestValidationException)validationException);
            }
        }
        if (this.metadata != null && MetadataUtils.containsReservedMetadata(this.metadata)) {
            validationException = ValidateActions.addValidationError((String)"API key metadata keys may not start with [_]", (ActionRequestValidationException)validationException);
        }
        assert (this.refreshPolicy != null) : "refresh policy is required";
        return validationException;
    }

    public final void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }
}

