/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.time.Clock;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class ClusterStateWaitUntilThresholdStep
extends ClusterStateWaitStep {
    private static final Logger logger = LogManager.getLogger(ClusterStateWaitUntilThresholdStep.class);
    private final ClusterStateWaitStep stepToExecute;
    private final Step.StepKey nextKeyOnThresholdBreach;
    private final AtomicBoolean thresholdPassed = new AtomicBoolean(false);

    public ClusterStateWaitUntilThresholdStep(ClusterStateWaitStep stepToExecute, Step.StepKey nextKeyOnThresholdBreach) {
        super(stepToExecute.getKey(), stepToExecute.getNextStepKey());
        this.stepToExecute = stepToExecute;
        this.nextKeyOnThresholdBreach = nextKeyOnThresholdBreach;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        IndexMetadata idxMeta = clusterState.metadata().index(index);
        if (idxMeta == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        ClusterStateWaitStep.Result stepResult = this.stepToExecute.isConditionMet(index, clusterState);
        if (!stepResult.isComplete()) {
            TimeValue retryThreshold = (TimeValue)LifecycleSettings.LIFECYCLE_STEP_WAIT_TIME_THRESHOLD_SETTING.get(idxMeta.getSettings());
            LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
            if (!this.stepToExecute.isCompletable()) {
                this.thresholdPassed.set(true);
                String message = String.format(Locale.ROOT, "[%s] lifecycle step, as part of [%s] action, for index [%s] Is not completable, reason: [%s]. Abandoning execution and moving to the next fallback step [%s]", this.getKey().name(), this.getKey().action(), idxMeta.getIndex().getName(), Strings.toString((ToXContent)stepResult.getInfomationContext()), this.nextKeyOnThresholdBreach);
                logger.debug(message);
                return new ClusterStateWaitStep.Result(true, new SingleMessageFieldInfo(message));
            }
            if (ClusterStateWaitUntilThresholdStep.waitedMoreThanThresholdLevel(retryThreshold, lifecycleState, Clock.systemUTC())) {
                this.thresholdPassed.set(true);
                String message = String.format(Locale.ROOT, "[%s] lifecycle step, as part of [%s] action, for index [%s] executed for more than [%s]. Abandoning execution and moving to the next fallback step [%s]", this.getKey().name(), this.getKey().action(), idxMeta.getIndex().getName(), retryThreshold, this.nextKeyOnThresholdBreach);
                logger.debug(message);
                return new ClusterStateWaitStep.Result(true, new SingleMessageFieldInfo(message));
            }
        }
        return stepResult;
    }

    static boolean waitedMoreThanThresholdLevel(@Nullable TimeValue retryThreshold, LifecycleExecutionState lifecycleState, Clock clock) {
        assert (lifecycleState.stepTime() != null) : "lifecycle state [" + String.valueOf(lifecycleState) + "] does not have the step time set";
        if (retryThreshold != null) {
            return lifecycleState.stepTime() + retryThreshold.millis() < clock.millis();
        }
        return false;
    }

    @Override
    public Step.StepKey getNextStepKey() {
        if (this.thresholdPassed.get()) {
            return this.nextKeyOnThresholdBreach;
        }
        return super.getNextStepKey();
    }

    ClusterStateWaitStep getStepToExecute() {
        return this.stepToExecute;
    }

    Step.StepKey getNextKeyOnThreshold() {
        return this.nextKeyOnThresholdBreach;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterStateWaitUntilThresholdStep that = (ClusterStateWaitUntilThresholdStep)o;
        return super.equals(o) && Objects.equals(this.stepToExecute, that.stepToExecute) && Objects.equals(this.nextKeyOnThresholdBreach, that.nextKeyOnThresholdBreach);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.stepToExecute, this.nextKeyOnThresholdBreach);
    }
}

